/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.internal.INavigatable;
import org.eclipse.compare.internal.IOpenable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class CompareNavigator
implements ICompareNavigator {
    private boolean fLastDirection = true;
    private CompareViewerSwitchingPane[] fPanes;
    private boolean fNextFirstTime = true;

    public CompareNavigator(CompareViewerSwitchingPane[] panes) {
        this.fPanes = panes;
    }

    public CompareViewerSwitchingPane[] getPanes() {
        return this.fPanes;
    }

    public boolean selectChange(boolean next) {
        this.fLastDirection = next;
        if (next && this.fNextFirstTime && this.mustOpen()) {
            this.fNextFirstTime = false;
            this.openElement();
        }
        int n = 0;
        INavigatable[] navigators = new INavigatable[4];
        int i = 0;
        while (i < this.fPanes.length) {
            navigators[n] = CompareNavigator.getNavigator(this.fPanes[i]);
            if (navigators[n] != null) {
                ++n;
            }
            ++i;
        }
        while (n > 0) {
            if (navigators[--n].gotoDifference(next)) continue;
            return false;
        }
        return true;
    }

    private static INavigatable getNavigator(CompareViewerSwitchingPane pane) {
        if (pane == null) {
            return null;
        }
        if (pane.isEmpty()) {
            return null;
        }
        Viewer viewer = pane.getViewer();
        if (viewer == null) {
            return null;
        }
        Control control = viewer.getControl();
        if (control == null) {
            return null;
        }
        Object data = control.getData("org.eclipse.compare.internal.Navigator");
        if (data instanceof INavigatable) {
            return (INavigatable)data;
        }
        return null;
    }

    private static CompareNavigator findNavigator(Control c) {
        while (c != null && !c.isDisposed()) {
            CompareEditorInput cei;
            Object adapter;
            Object data = c.getData();
            if (data instanceof CompareEditorInput && (adapter = (cei = (CompareEditorInput)data).getAdapter(CompareNavigator.class)) instanceof CompareNavigator) {
                return (CompareNavigator)adapter;
            }
            c = c.getParent();
        }
        return null;
    }

    private boolean resetDirection() {
        boolean last = this.fLastDirection;
        this.fLastDirection = true;
        return last;
    }

    public static boolean getDirection(Control c) {
        CompareNavigator nav = CompareNavigator.findNavigator(c);
        if (nav != null) {
            return nav.resetDirection();
        }
        return true;
    }

    private boolean mustOpen() {
        if (this.fPanes == null || this.fPanes.length == 0) {
            return false;
        }
        int i = 1;
        while (i < this.fPanes.length) {
            CompareViewerSwitchingPane pane = this.fPanes[i];
            if (pane != null && pane.getInput() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void openElement() {
        if (this.fPanes == null || this.fPanes.length == 0) {
            return;
        }
        IOpenable openable = CompareNavigator.getOpenable(this.fPanes[0]);
        if (openable != null) {
            openable.openSelected();
        }
    }

    private static IOpenable getOpenable(CompareViewerSwitchingPane pane) {
        if (pane == null) {
            return null;
        }
        if (pane.isEmpty()) {
            return null;
        }
        Viewer viewer = pane.getViewer();
        if (viewer == null) {
            return null;
        }
        Control control = viewer.getControl();
        if (control == null) {
            return null;
        }
        Object data = control.getData("org.eclipse.compare.internal.Openable");
        if (data instanceof IOpenable) {
            return (IOpenable)data;
        }
        return null;
    }
}

