/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.util.Assert;

public class ManifestProvider
implements IManifestProvider {
    private static final String SEALED_VALUE = "true";
    private static final String UNSEALED_VALUE = "false";

    public Manifest create(JarPackageData jarPackage) throws CoreException {
        Assert.isNotNull((Object)jarPackage);
        if (jarPackage.isManifestGenerated()) {
            return this.createGeneratedManifest(jarPackage);
        }
        try {
            return this.createSuppliedManifest(jarPackage);
        }
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    public Manifest createDefault(String manifestVersion) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, manifestVersion);
        return manifest;
    }

    protected void putAdditionalEntries(Manifest manifest, JarPackageData jarPackage) {
    }

    private Manifest createGeneratedManifest(JarPackageData jarPackage) {
        Manifest manifest = new Manifest();
        this.putVersion(manifest, jarPackage);
        this.putSealing(manifest, jarPackage);
        this.putMainClass(manifest, jarPackage);
        this.putAdditionalEntries(manifest, jarPackage);
        return manifest;
    }

    private void putVersion(Manifest manifest, JarPackageData jarPackage) {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, jarPackage.getManifestVersion());
    }

    private void putSealing(Manifest manifest, JarPackageData jarPackage) {
        block4: {
            block3: {
                if (!jarPackage.isJarSealed()) break block3;
                manifest.getMainAttributes().put(Attributes.Name.SEALED, SEALED_VALUE);
                IPackageFragment[] packages = jarPackage.getPackagesToUnseal();
                if (packages == null) break block4;
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, UNSEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
                break block4;
            }
            IPackageFragment[] packages = jarPackage.getPackagesToSeal();
            if (packages != null) {
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, SEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
            }
        }
    }

    private void putMainClass(Manifest manifest, JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() != null && jarPackage.getManifestMainClass().getFullyQualifiedName().length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, jarPackage.getManifestMainClass().getFullyQualifiedName());
        }
    }

    private String getInManifestFormat(IPackageFragment packageFragment) {
        String name = packageFragment.getElementName();
        return String.valueOf(name.replace('.', '/')) + '/';
    }

    private Manifest createSuppliedManifest(JarPackageData jarPackage) throws CoreException, IOException {
        Manifest manifest;
        InputStream stream = jarPackage.getManifestFile().getContents(false);
        try {
            manifest = new Manifest(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return manifest;
    }
}

