/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.WorkingSetDescriptor;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public class WorkingSetTypePage
extends WizardPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private TableViewer typesListViewer;
    private Map icons;

    public WorkingSetTypePage() {
        super("workingSetTypeSelectionPage", WorkbenchMessages.Select, WorkbenchImages.getImageDescriptor("IMG_WIZBAN_WORKINGSET_WIZ"));
        this.setDescription(WorkbenchMessages.WorkingSetTypePage_description);
        this.icons = new Hashtable();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void createContent() {
        WorkingSetRegistry registry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        WorkingSetDescriptor[] descriptors = registry.getNewPageWorkingSetDescriptors();
        Table table = (Table)this.typesListViewer.getControl();
        int i = 0;
        while (i < descriptors.length) {
            TableItem tableItem = new TableItem(table, 0);
            ImageDescriptor imageDescriptor = descriptors[i].getIcon();
            if (imageDescriptor != null) {
                Image icon = (Image)this.icons.get(imageDescriptor);
                if (icon == null) {
                    icon = imageDescriptor.createImage();
                    this.icons.put(imageDescriptor, icon);
                }
                tableItem.setImage(icon);
            }
            tableItem.setText(descriptors[i].getName());
            tableItem.setData((Object)descriptors[i]);
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.working_set_type_page");
        Label typesLabel = new Label(composite, 0);
        typesLabel.setText(WorkbenchMessages.WorkingSetTypePage_typesLabel);
        GridData data = new GridData(1796);
        typesLabel.setLayoutData((Object)data);
        typesLabel.setFont(font);
        this.typesListViewer = new TableViewer(composite, 2050);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.typesListViewer.getTable().setLayoutData((Object)data);
        this.typesListViewer.getTable().setFont(font);
        this.typesListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetTypePage.this.handleSelectionChanged();
            }
        });
        this.typesListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WorkingSetTypePage.this.handleDoubleClick();
            }
        });
        this.createContent();
        this.setPageComplete(false);
    }

    public void dispose() {
        for (Image icon : this.icons.values()) {
            icon.dispose();
        }
        super.dispose();
    }

    public String getSelection() {
        boolean hasSelection;
        ISelection selection = this.typesListViewer.getSelection();
        boolean bl = hasSelection = selection != null && !selection.isEmpty();
        if (hasSelection && selection instanceof IStructuredSelection) {
            WorkingSetDescriptor workingSetDescriptor = (WorkingSetDescriptor)((IStructuredSelection)selection).getFirstElement();
            return workingSetDescriptor.getId();
        }
        return null;
    }

    private void handleDoubleClick() {
        this.handleSelectionChanged();
        this.getContainer().showPage(this.getNextPage());
    }

    private void handleSelectionChanged() {
        ISelection selection = this.typesListViewer.getSelection();
        boolean hasSelection = selection != null && !selection.isEmpty();
        this.setPageComplete(hasSelection);
    }
}

