/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.util.CVSDateFormatter;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class NotifyInfo {
    public static final char EDIT = 'E';
    public static final char UNEDIT = 'U';
    public static final char COMMIT = 'C';
    public static final char[] ALL = new char[]{'E', 'U', 'C'};
    protected static final String TAB_SEPARATOR = "\t";
    private String filename;
    private char notificationType;
    private Date timeStamp;
    private char[] watches;

    public NotifyInfo(String filename, char notificationType, Date timeStamp, char[] watches) {
        this.filename = filename;
        this.notificationType = notificationType;
        this.timeStamp = timeStamp;
        this.watches = watches;
    }

    public NotifyInfo(IContainer parent, String line) throws CVSException {
        String[] strings = Util.parseIntoSubstrings(line, "/");
        if (strings.length != 4) {
            throw new CVSException(NLS.bind((String)CVSMessages.NotifyInfo_MalformedLine, (Object[])new String[]{line}));
        }
        this.filename = strings[0];
        String type = strings[1];
        if (type.length() != 1) {
            throw new CVSException(NLS.bind((String)CVSMessages.NotifyInfo_MalformedNotificationType, (Object[])new String[]{line}));
        }
        this.notificationType = type.charAt(0);
        String date = strings[2];
        try {
            this.timeStamp = CVSDateFormatter.entryLineToDate(date);
        }
        catch (ParseException parseException) {
            throw new CVSException(NLS.bind((String)CVSMessages.NotifyInfo_MalformedNotifyDate, (Object[])new String[]{line}));
        }
        String watchesString = strings[3];
        if (watchesString.length() > 0) {
            this.watches = new char[watchesString.length()];
            int i = 0;
            while (i < watchesString.length()) {
                this.watches[i] = watchesString.charAt(i);
                ++i;
            }
        } else {
            this.watches = null;
        }
    }

    public String getNotifyLine() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append("/");
        buffer.append(this.notificationType);
        buffer.append("/");
        buffer.append(CVSDateFormatter.dateToEntryLine(this.timeStamp));
        buffer.append("/");
        if (this.watches != null) {
            int i = 0;
            while (i < this.watches.length) {
                char c = this.watches[i];
                buffer.append(c);
                ++i;
            }
        }
        return buffer.toString();
    }

    public String getServerLine(ICVSFolder parent) throws CVSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.notificationType);
        buffer.append(TAB_SEPARATOR);
        buffer.append(this.getServerTimestamp());
        buffer.append(TAB_SEPARATOR);
        buffer.append(this.getHost());
        buffer.append(TAB_SEPARATOR);
        buffer.append(this.getWorkingDirectory(parent));
        buffer.append(TAB_SEPARATOR);
        if (this.watches != null) {
            int i = 0;
            while (i < this.watches.length) {
                char c = this.watches[i];
                buffer.append(c);
                ++i;
            }
        }
        return buffer.toString();
    }

    private String getServerTimestamp() {
        return CVSDateFormatter.dateToNotifyServer(this.timeStamp);
    }

    private String getWorkingDirectory(ICVSFolder parent) throws CVSException {
        return parent.getIResource().getLocation().toString();
    }

    private String getHost() throws CVSException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw CVSException.wrapException(e);
        }
    }

    public String getName() {
        return this.filename;
    }

    public char getNotificationType() {
        return this.notificationType;
    }
}

