/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.PrepareForReplaceVisitor;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.ui.IWorkbenchPart;

public class ReplaceOperation
extends UpdateOperation {
    public ReplaceOperation(IWorkbenchPart part, IResource[] resources, CVSTag tag, boolean recurse) {
        super(part, ReplaceOperation.asResourceMappers(resources, recurse ? 2 : 1), new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, tag);
    }

    public ReplaceOperation(IWorkbenchPart part, ResourceMapping[] mappings, CVSTag tag) {
        super(part, mappings, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, tag);
    }

    protected String getTaskName() {
        return CVSUIMessages.ReplaceOperation_taskName;
    }

    protected IStatus executeCommand(final Session session, final CVSTeamProvider provider, final ICVSResource[] resources, final boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        status[0] = ReplaceOperation.this.internalExecuteCommand(session, provider, resources, recurse, monitor);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
            }, null, 1, monitor);
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
        return status[0];
    }

    private IStatus internalExecuteCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 100);
        ICVSResource[] managedResources = this.getResourcesToUpdate(resources);
        try {
            new PrepareForReplaceVisitor().visitResources(provider.getProject(), resources, CVSUIMessages.ReplaceOperation_1, recurse ? 2 : 1, Policy.subMonitorFor(monitor, 30));
            IStatus status = OK;
            if (managedResources.length > 0) {
                status = super.executeCommand(session, provider, managedResources, recurse, Policy.subMonitorFor(monitor, 70));
            }
            if (status.isOK() && CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                new PruneFolderVisitor().visit(session, resources);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected ICVSResource[] getResourcesToUpdate(ICVSResource[] resources) throws CVSException {
        ArrayList<ICVSResource> managedResources = new ArrayList<ICVSResource>();
        int i = 0;
        while (i < resources.length) {
            byte[] syncBytes;
            ICVSResource resource = resources[i];
            if (resource.isFolder() && ((ICVSFolder)resource).isCVSFolder()) {
                managedResources.add(resource);
            } else if (!resource.isFolder() && (syncBytes = ((ICVSFile)resource).getSyncBytes()) != null && !ResourceSyncInfo.isAddition((byte[])syncBytes)) {
                managedResources.add(resource);
            }
            ++i;
        }
        return managedResources.toArray(new ICVSResource[managedResources.size()]);
    }

    protected Update getUpdateCommand() {
        return Command.REPLACE;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.ReplaceOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }
}

