/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class ResourceWithStatusUtil {
    private ResourceWithStatusUtil() {
    }

    public static String getStatus(IResource resource) {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        String result = null;
        try {
            LocalResourceStatus status = svnResource.getStatus();
            result = status.isTextConflicted() ? Policy.bind("CommitDialog.conflicted") : (status.isAdded() ? Policy.bind("CommitDialog.added") : (status.isDeleted() ? Policy.bind("CommitDialog.deleted") : (status.isMissing() ? Policy.bind("CommitDialog.missing") : (status.isReplaced() ? Policy.bind("CommitDialog.replaced") : (status.isTextModified() ? Policy.bind("CommitDialog.modified") : (!status.isManaged() ? Policy.bind("CommitDialog.unversioned") : ""))))));
        }
        catch (TeamException teamException) {
            result = "";
        }
        return result;
    }

    public static String getPropertyStatus(IResource resource) {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        String result = null;
        try {
            LocalResourceStatus status = svnResource.getStatus();
            result = status.isPropConflicted() ? Policy.bind("CommitDialog.conflicted") : (svnResource.getStatus() != null && svnResource.getStatus().getPropStatus() != null && svnResource.getStatus().getPropStatus().equals((Object)SVNStatusKind.MODIFIED) ? Policy.bind("CommitDialog.modified") : "");
        }
        catch (TeamException teamException) {
            result = "";
        }
        return result;
    }
}

