/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IResourceDelta;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.SimpleDelta;

public class RubyElementDelta
extends SimpleDelta
implements IRubyElementDelta {
    protected IRubyElementDelta[] affectedChildren = EMPTY_DELTA;
    protected RubyScript ast = null;
    protected IRubyElement changedElement;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IRubyElement movedFromHandle = null;
    protected IRubyElement movedToHandle = null;
    protected static IRubyElementDelta[] EMPTY_DELTA = new IRubyElementDelta[0];

    public RubyElementDelta(IRubyElement iRubyElement) {
        this.changedElement = iRubyElement;
    }

    protected void addAffectedChild(RubyElementDelta rubyElementDelta) {
        int n;
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 8;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 8;
            }
        }
        if (this.changedElement.getElementType() >= 2) {
            this.fineGrained();
        }
        if (this.affectedChildren.length == 0) {
            this.affectedChildren = new IRubyElementDelta[]{rubyElementDelta};
            return;
        }
        SimpleDelta simpleDelta = null;
        int n2 = -1;
        if (this.affectedChildren != null) {
            n = 0;
            while (n < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[n].getElement(), rubyElementDelta.getElement())) {
                    simpleDelta = (RubyElementDelta)this.affectedChildren[n];
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        if (simpleDelta == null) {
            this.affectedChildren = this.growAndAddToArray(this.affectedChildren, rubyElementDelta);
        } else {
            switch (simpleDelta.getKind()) {
                case 1: {
                    switch (rubyElementDelta.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, n2);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (rubyElementDelta.getKind()) {
                        case 1: {
                            rubyElementDelta.kind = 4;
                            this.affectedChildren[n2] = rubyElementDelta;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (rubyElementDelta.getKind()) {
                        case 1: 
                        case 2: {
                            this.affectedChildren[n2] = rubyElementDelta;
                            return;
                        }
                        case 4: {
                            IResourceDelta[] iResourceDeltaArray;
                            IRubyElementDelta[] iRubyElementDeltaArray = rubyElementDelta.getAffectedChildren();
                            int n3 = 0;
                            while (n3 < iRubyElementDeltaArray.length) {
                                RubyElementDelta rubyElementDelta2 = (RubyElementDelta)iRubyElementDeltaArray[n3];
                                ((RubyElementDelta)simpleDelta).addAffectedChild(rubyElementDelta2);
                                ++n3;
                            }
                            n3 = (rubyElementDelta.changeFlags & 1) != 0 ? 1 : 0;
                            boolean bl = (((RubyElementDelta)simpleDelta).changeFlags & 8) != 0;
                            ((RubyElementDelta)simpleDelta).changeFlags |= rubyElementDelta.changeFlags;
                            if (n3 != 0 && bl) {
                                ((RubyElementDelta)simpleDelta).changeFlags &= 0xFFFFFFFE;
                            }
                            if ((iResourceDeltaArray = rubyElementDelta.getResourceDeltas()) != null) {
                                ((RubyElementDelta)simpleDelta).resourceDeltas = iResourceDeltaArray;
                                ((RubyElementDelta)simpleDelta).resourceDeltasCounter = rubyElementDelta.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    n = simpleDelta.getFlags();
                    this.affectedChildren[n2] = rubyElementDelta;
                    rubyElementDelta.changeFlags |= n;
                }
            }
        }
    }

    public void added(IRubyElement iRubyElement) {
        this.added(iRubyElement, 0);
    }

    public void added(IRubyElement iRubyElement, int n) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.added();
        rubyElementDelta.changeFlags |= n;
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    protected void addResourceDelta(IResourceDelta iResourceDelta) {
        switch (this.kind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.changeFlags |= 1;
                break;
            }
            default: {
                this.kind = 4;
                this.changeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = iResourceDelta;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = iResourceDelta;
    }

    public RubyElementDelta changed(IRubyElement iRubyElement, int n) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.changed(n);
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
        return rubyElementDelta;
    }

    public void changedAST(RubyScript rubyScript) {
        this.ast = rubyScript;
        this.changed(524288);
    }

    public void contentChanged() {
        this.changeFlags |= 1;
    }

    public void closed(IRubyElement iRubyElement) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.changed(1024);
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    protected RubyElementDelta createDeltaTree(IRubyElement iRubyElement, RubyElementDelta rubyElementDelta) {
        RubyElementDelta rubyElementDelta2 = rubyElementDelta;
        ArrayList arrayList = this.getAncestors(iRubyElement);
        if (arrayList == null) {
            if (this.equalsAndSameParent(rubyElementDelta.getElement(), this.getElement())) {
                this.kind = rubyElementDelta.kind;
                this.changeFlags = rubyElementDelta.changeFlags;
                this.movedToHandle = rubyElementDelta.movedToHandle;
                this.movedFromHandle = rubyElementDelta.movedFromHandle;
            }
        } else {
            int n = 0;
            int n2 = arrayList.size();
            while (n < n2) {
                IRubyElement iRubyElement2 = (IRubyElement)arrayList.get(n);
                RubyElementDelta rubyElementDelta3 = new RubyElementDelta(iRubyElement2);
                rubyElementDelta3.addAffectedChild(rubyElementDelta2);
                rubyElementDelta2 = rubyElementDelta3;
                ++n;
            }
        }
        return rubyElementDelta2;
    }

    protected boolean equalsAndSameParent(IRubyElement iRubyElement, IRubyElement iRubyElement2) {
        IRubyElement iRubyElement3;
        return iRubyElement.equals(iRubyElement2) && (iRubyElement3 = iRubyElement.getParent()) != null && iRubyElement3.equals(iRubyElement2.getParent());
    }

    protected RubyElementDelta find(IRubyElement iRubyElement) {
        if (this.equalsAndSameParent(this.changedElement, iRubyElement)) {
            return this;
        }
        int n = 0;
        while (n < this.affectedChildren.length) {
            RubyElementDelta rubyElementDelta = ((RubyElementDelta)this.affectedChildren[n]).find(iRubyElement);
            if (rubyElementDelta != null) {
                return rubyElementDelta;
            }
            ++n;
        }
        return null;
    }

    public void fineGrained() {
        this.changed(16384);
    }

    public IRubyElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    public IRubyElementDelta[] getAffectedChildren() {
        return this.affectedChildren;
    }

    private ArrayList getAncestors(IRubyElement iRubyElement) {
        IRubyElement iRubyElement2 = iRubyElement.getParent();
        if (iRubyElement2 == null) {
            return null;
        }
        ArrayList<IRubyElement> arrayList = new ArrayList<IRubyElement>();
        while (!iRubyElement2.equals(this.changedElement)) {
            arrayList.add(iRubyElement2);
            iRubyElement2 = iRubyElement2.getParent();
            if (iRubyElement2 != null) continue;
            return null;
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public RubyScript getRubyScriptAST() {
        return this.ast;
    }

    public IRubyElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected IRubyElementDelta[] getChildrenOfType(int n) {
        int n2 = this.affectedChildren.length;
        if (n2 == 0) {
            return new IRubyElementDelta[0];
        }
        ArrayList<IRubyElementDelta> arrayList = new ArrayList<IRubyElementDelta>(n2);
        int n3 = 0;
        while (n3 < n2) {
            if (this.affectedChildren[n3].getKind() == n) {
                arrayList.add(this.affectedChildren[n3]);
            }
            ++n3;
        }
        IRubyElementDelta[] iRubyElementDeltaArray = new IRubyElementDelta[arrayList.size()];
        arrayList.toArray(iRubyElementDeltaArray);
        return iRubyElementDeltaArray;
    }

    protected RubyElementDelta getDeltaFor(IRubyElement iRubyElement) {
        if (this.equalsAndSameParent(this.getElement(), iRubyElement)) {
            return this;
        }
        if (this.affectedChildren.length == 0) {
            return null;
        }
        int n = this.affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            RubyElementDelta rubyElementDelta = (RubyElementDelta)this.affectedChildren[n2];
            if (this.equalsAndSameParent(rubyElementDelta.getElement(), iRubyElement)) {
                return rubyElementDelta;
            }
            if ((rubyElementDelta = rubyElementDelta.getDeltaFor(iRubyElement)) != null) {
                return rubyElementDelta;
            }
            ++n2;
        }
        return null;
    }

    public IRubyElement getElement() {
        return this.changedElement;
    }

    public IRubyElement getMovedFromElement() {
        return this.movedFromHandle;
    }

    public IRubyElement getMovedToElement() {
        return this.movedToHandle;
    }

    public IRubyElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected IRubyElementDelta[] growAndAddToArray(IRubyElementDelta[] iRubyElementDeltaArray, IRubyElementDelta iRubyElementDelta) {
        IRubyElementDelta[] iRubyElementDeltaArray2 = iRubyElementDeltaArray;
        iRubyElementDeltaArray = new IRubyElementDelta[iRubyElementDeltaArray2.length + 1];
        System.arraycopy(iRubyElementDeltaArray2, 0, iRubyElementDeltaArray, 0, iRubyElementDeltaArray2.length);
        iRubyElementDeltaArray[iRubyElementDeltaArray2.length] = iRubyElementDelta;
        return iRubyElementDeltaArray;
    }

    protected void insertDeltaTree(IRubyElement iRubyElement, RubyElementDelta rubyElementDelta) {
        RubyElementDelta rubyElementDelta2 = this.createDeltaTree(iRubyElement, rubyElementDelta);
        if (!this.equalsAndSameParent(iRubyElement, this.getElement())) {
            this.addAffectedChild(rubyElementDelta2);
        }
    }

    public void movedFrom(IRubyElement iRubyElement, IRubyElement iRubyElement2) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.kind = 2;
        rubyElementDelta.changeFlags |= 0x20;
        rubyElementDelta.movedToHandle = iRubyElement2;
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    public void movedTo(IRubyElement iRubyElement, IRubyElement iRubyElement2) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.kind = 1;
        rubyElementDelta.changeFlags |= 0x10;
        rubyElementDelta.movedFromHandle = iRubyElement2;
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    public void opened(IRubyElement iRubyElement) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.changed(512);
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    protected void removeAffectedChild(RubyElementDelta rubyElementDelta) {
        int n = -1;
        if (this.affectedChildren != null) {
            int n2 = 0;
            while (n2 < this.affectedChildren.length) {
                if (this.equalsAndSameParent(this.affectedChildren[n2].getElement(), rubyElementDelta.getElement())) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n >= 0) {
            this.affectedChildren = this.removeAndShrinkArray(this.affectedChildren, n);
        }
    }

    protected IRubyElementDelta[] removeAndShrinkArray(IRubyElementDelta[] iRubyElementDeltaArray, int n) {
        int n2;
        IRubyElementDelta[] iRubyElementDeltaArray2 = new IRubyElementDelta[iRubyElementDeltaArray.length - 1];
        if (n > 0) {
            System.arraycopy(iRubyElementDeltaArray, 0, iRubyElementDeltaArray2, 0, n);
        }
        if ((n2 = iRubyElementDeltaArray.length - n - 1) > 0) {
            System.arraycopy(iRubyElementDeltaArray, n + 1, iRubyElementDeltaArray2, n, n2);
        }
        return iRubyElementDeltaArray2;
    }

    public void removed(IRubyElement iRubyElement) {
        this.removed(iRubyElement, 0);
    }

    public void removed(IRubyElement iRubyElement, int n) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
        RubyElementDelta rubyElementDelta2 = this.getDeltaFor(iRubyElement);
        if (rubyElementDelta2 != null) {
            rubyElementDelta2.removed();
            rubyElementDelta2.changeFlags |= n;
            rubyElementDelta2.affectedChildren = EMPTY_DELTA;
        }
    }

    public void sourceAttached(IRubyElement iRubyElement) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.changed(4096);
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    public void sourceDetached(IRubyElement iRubyElement) {
        RubyElementDelta rubyElementDelta = new RubyElementDelta(iRubyElement);
        rubyElementDelta.changed(8192);
        this.insertDeltaTree(iRubyElement, rubyElementDelta);
    }

    public String toDebugString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append('\t');
            ++n3;
        }
        stringBuffer.append(((RubyElement)this.getElement()).toDebugString());
        this.toDebugString(stringBuffer);
        IRubyElementDelta[] iRubyElementDeltaArray = this.getAffectedChildren();
        if (iRubyElementDeltaArray != null) {
            n2 = 0;
            while (n2 < iRubyElementDeltaArray.length) {
                stringBuffer.append("\n");
                stringBuffer.append(((RubyElementDelta)iRubyElementDeltaArray[n2]).toDebugString(n + 1));
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.resourceDeltasCounter) {
            stringBuffer.append("\n");
            int n4 = 0;
            while (n4 < n + 1) {
                stringBuffer.append('\t');
                ++n4;
            }
            IResourceDelta iResourceDelta = this.resourceDeltas[n2];
            stringBuffer.append(iResourceDelta.toString());
            stringBuffer.append("[");
            switch (iResourceDelta.getKind()) {
                case 1: {
                    stringBuffer.append('+');
                    break;
                }
                case 2: {
                    stringBuffer.append('-');
                    break;
                }
                case 4: {
                    stringBuffer.append('*');
                    break;
                }
                default: {
                    stringBuffer.append('?');
                }
            }
            stringBuffer.append("]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected boolean toDebugString(StringBuffer stringBuffer, int n) {
        boolean bl = super.toDebugString(stringBuffer, n);
        if ((n & 8) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CHILDREN");
            bl = true;
        }
        if ((n & 1) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CONTENT");
            bl = true;
        }
        if ((n & 0x10) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MOVED_FROM(" + ((RubyElement)this.getMovedFromElement()).toStringWithAncestors() + ")");
            bl = true;
        }
        if ((n & 0x20) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("MOVED_TO(" + ((RubyElement)this.getMovedToElement()).toStringWithAncestors() + ")");
            bl = true;
        }
        if ((n & 0x40) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("ADDED TO CLASSPATH");
            bl = true;
        }
        if ((n & 0x80) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("REMOVED FROM CLASSPATH");
            bl = true;
        }
        if ((n & 0x100) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("REORDERED");
            bl = true;
        }
        if ((n & 0x8000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("ARCHIVE CONTENT CHANGED");
            bl = true;
        }
        if ((n & 0x1000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("SOURCE ATTACHED");
            bl = true;
        }
        if ((n & 0x2000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("SOURCE DETACHED");
            bl = true;
        }
        if ((n & 0x4000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("FINE GRAINED");
            bl = true;
        }
        if ((n & 0x10000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("PRIMARY WORKING COPY");
            bl = true;
        }
        if ((n & 0x20000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CLASSPATH CHANGED");
            bl = true;
        }
        if ((n & 0x40000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("PRIMARY RESOURCE");
            bl = true;
        }
        if ((n & 0x200) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("OPENED");
            bl = true;
        }
        if ((n & 0x400) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CLOSED");
            bl = true;
        }
        if ((n & 0x80000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("AST AFFECTED");
            bl = true;
        }
        if ((n & 0x100000) != 0) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CATEGORIES");
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.toDebugString(0);
    }
}

