/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.generic;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import java.util.Collections;
import java.util.List;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericObjectType
extends ObjectType {
    final List<? extends ReferenceType> parameters;
    @CheckForNull
    final String variable;
    @CheckForNull
    final Type extension;

    public Type getUpperBound() {
        if ("+".equals(this.variable)) {
            return this.extension;
        }
        return this;
    }

    public Type getExtension() {
        return this.extension;
    }

    public String getVariable() {
        return this.variable;
    }

    public GenericUtilities.TypeCategory getTypeCategory() {
        if (this.hasParameters() && this.variable == null && this.extension == null) {
            return GenericUtilities.TypeCategory.PARAMETERS;
        }
        if (!this.hasParameters() && this.variable != null && this.extension == null) {
            if (this.variable.equals("*")) {
                return GenericUtilities.TypeCategory.WILDCARD;
            }
            return GenericUtilities.TypeCategory.TYPE_VARIABLE;
        }
        if (!this.hasParameters() && this.variable != null && this.extension != null) {
            if (this.variable.equals("+")) {
                return GenericUtilities.TypeCategory.WILDCARD_EXTENDS;
            }
            if (this.variable.equals("-")) {
                return GenericUtilities.TypeCategory.WILDCARD_SUPER;
            }
        }
        throw new IllegalStateException("The Generic Object Type is badly initialized");
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public int getNumParameters() {
        return this.parameters != null ? this.parameters.size() : 0;
    }

    public ReferenceType getParameterAt(int index) {
        if (index < this.getNumParameters()) {
            return this.parameters.get(index);
        }
        throw new IndexOutOfBoundsException(new StringBuffer().append("The index ").append(index).append(" is too large").toString());
    }

    public List<? extends ReferenceType> getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return Collections.unmodifiableList(this.parameters);
    }

    GenericObjectType(@NonNull String variable) {
        this(variable, (Type)null);
    }

    GenericObjectType(@NonNull String wildcard, Type extension) {
        super(Type.OBJECT.getClassName());
        this.variable = wildcard;
        this.extension = extension;
        this.parameters = null;
    }

    GenericObjectType(String class_name, List<? extends ReferenceType> parameters) {
        super(class_name);
        this.variable = null;
        this.extension = null;
        if (parameters == null || parameters.size() == 0) {
            throw new IllegalStateException("argument 'parameters' must contain at least 1 parameter");
        }
        this.parameters = parameters;
    }

    public ObjectType getObjectType() {
        return (ObjectType)Type.getType(this.getSignature());
    }

    public String toString(boolean includeGenerics) {
        if (!includeGenerics) {
            return super.toString();
        }
        return this.getTypeCategory().asString(this);
    }
}

