/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGPrinter;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import java.io.PrintStream;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataflowCFGPrinter<Fact, AnalysisType extends BasicAbstractDataflowAnalysis<Fact>>
extends CFGPrinter {
    private Dataflow<Fact, AnalysisType> dataflow;

    public DataflowCFGPrinter(Dataflow<Fact, AnalysisType> dataflow) {
        super(dataflow.getCFG());
        this.dataflow = dataflow;
        this.setIsForwards(((BasicAbstractDataflowAnalysis)dataflow.getAnalysis()).isForwards());
    }

    @Override
    public String edgeAnnotate(Edge edge) {
        String edgeAnnotation = "";
        try {
            edgeAnnotation = new StringBuffer().append(" ").append(((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).factToString(((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).getFactOnEdge(edge))).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return edgeAnnotation;
    }

    @Override
    public String blockStartAnnotate(BasicBlock bb) {
        boolean flip = this.isForwards() != ((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).isForwards();
        Fact fact = flip ? this.dataflow.getResultFact(bb) : this.dataflow.getStartFact(bb);
        return new StringBuffer().append(" ").append(((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).factToString(fact)).toString();
    }

    @Override
    public String blockAnnotate(BasicBlock bb) {
        boolean flip = this.isForwards() != ((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).isForwards();
        Fact fact = flip ? this.dataflow.getStartFact(bb) : this.dataflow.getResultFact(bb);
        return new StringBuffer().append(" ").append(((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).factToString(fact)).toString();
    }

    @Override
    public String instructionAnnotate(InstructionHandle handle, BasicBlock bb) {
        try {
            boolean flip = this.isForwards() != ((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).isForwards();
            Location loc = new Location(handle, bb);
            Object fact = flip ? ((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).getFactAfterLocation(loc) : ((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).getFactAtLocation(loc);
            return new StringBuffer().append(" ").append(((BasicAbstractDataflowAnalysis)this.dataflow.getAnalysis()).factToString(fact)).toString();
        }
        catch (DataflowAnalysisException e) {
            throw new IllegalStateException(new StringBuffer().append("Caught exception: ").append(e.toString()).toString());
        }
    }

    public static <Fact, AnalysisType extends BasicAbstractDataflowAnalysis<Fact>> void printCFG(Dataflow<Fact, AnalysisType> dataflow, PrintStream out) {
        DataflowCFGPrinter<Fact, AnalysisType> printer = new DataflowCFGPrinter<Fact, AnalysisType>(dataflow);
        printer.print(out);
    }
}

