/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassNotFoundExceptionParser;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractBugReporter
implements BugReporter {
    private static final boolean DEBUG_MISSING_CLASSES;
    private int verbosityLevel = 1;
    private int priorityThreshold;
    private boolean analysisUnderway;
    private boolean relaxed;
    private HashSet<String> missingClassMessageSet = new HashSet();
    private LinkedList<String> missingClassMessageList = new LinkedList();
    private Set<Error> errorSet = new HashSet<Error>();
    private List<BugReporterObserver> observerList = new LinkedList<BugReporterObserver>();
    private ProjectStats projectStats = new ProjectStats();
    private int errorCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setErrorVerbosity(int level) {
        this.verbosityLevel = level;
    }

    public void setPriorityThreshold(int threshold) {
        this.priorityThreshold = threshold;
    }

    public final void reportBug(BugInstance bugInstance) {
        ClassAnnotation primaryClass;
        if (this.priorityThreshold == 0) {
            throw new IllegalStateException("Priority threshold not set");
        }
        if (!this.analysisUnderway) {
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                this.relaxed = true;
            }
            this.analysisUnderway = true;
        }
        if ((primaryClass = bugInstance.getPrimaryClass()) != null && !AnalysisContext.currentAnalysisContext().isApplicationClass(primaryClass.getClassName())) {
            return;
        }
        if (bugInstance.getPriority() <= this.priorityThreshold || this.relaxed) {
            this.doReportBug(bugInstance);
        }
    }

    public static String getMissingClassName(ClassNotFoundException ex) {
        String message = ex.getMessage();
        String className = ClassNotFoundExceptionParser.getMissingClassName(ex);
        if (className != null) {
            if (className.indexOf(47) >= 0) {
                className = className.replace('/', '.');
            }
            return className;
        }
        return message;
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        if (DEBUG_MISSING_CLASSES) {
            System.out.println("Missing class: " + ex.toString());
            ex.printStackTrace(System.out);
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        String message = AbstractBugReporter.getMissingClassName(ex);
        if (message.startsWith("[")) {
            return;
        }
        if (!$assertionsDisabled && message.indexOf(60) != -1) {
            throw new AssertionError((Object)("message is " + message));
        }
        this.logMissingClass(message);
    }

    public void reportMissingClass(ClassDescriptor classDescriptor) {
        if (DEBUG_MISSING_CLASSES) {
            System.out.println("Missing class: " + classDescriptor);
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        this.logMissingClass(classDescriptor.toDottedClassName());
    }

    private void logMissingClass(String message) {
        if (!this.missingClassMessageSet.contains(message)) {
            this.missingClassMessageSet.add(message);
            this.missingClassMessageList.add(message);
        }
    }

    public void reportSkippedAnalysis(MethodDescriptor method) {
    }

    public void logError(String message) {
        Error error;
        if (this.verbosityLevel == 0) {
            return;
        }
        if (!this.errorSet.contains(error = new Error(this.errorCount++, message))) {
            this.errorSet.add(error);
        }
    }

    public void logError(String message, Throwable e) {
        Error error;
        if (e instanceof MethodUnprofitableException) {
            return;
        }
        if (e instanceof MissingClassException) {
            MissingClassException missingClassEx = (MissingClassException)e;
            ClassNotFoundException cnfe = missingClassEx.getClassNotFoundException();
            this.reportMissingClass(cnfe);
            return;
        }
        if (this.verbosityLevel == 0) {
            return;
        }
        if (!this.errorSet.contains(error = new Error(this.errorCount++, message, e))) {
            this.errorSet.add(error);
        }
    }

    public void reportQueuedErrors() {
        Error[] errorList = this.errorSet.toArray(new Error[this.errorSet.size()]);
        Arrays.sort(errorList, new Comparator<Error>(){

            @Override
            public int compare(Error o1, Error o2) {
                return o1.getSequence() - o2.getSequence();
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((Error)x0, (Error)x1);
            }
        });
        Error[] arr$ = errorList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Error error = arr$[i$];
            this.reportAnalysisError(new AnalysisError(error.getMessage(), error.getCause()));
        }
        Iterator i$ = this.missingClassMessageList.iterator();
        while (i$.hasNext()) {
            String aMissingClassMessageList = (String)i$.next();
            this.reportMissingClass(aMissingClassMessageList);
        }
    }

    public void addObserver(BugReporterObserver observer) {
        this.observerList.add(observer);
    }

    public ProjectStats getProjectStats() {
        return this.projectStats;
    }

    protected void notifyObservers(BugInstance bugInstance) {
        Iterator<BugReporterObserver> i$ = this.observerList.iterator();
        while (i$.hasNext()) {
            BugReporterObserver aObserverList = i$.next();
            aObserverList.reportBug(bugInstance);
        }
    }

    protected abstract void doReportBug(BugInstance var1);

    public abstract void reportAnalysisError(AnalysisError var1);

    public abstract void reportMissingClass(String var1);

    static {
        $assertionsDisabled = !AbstractBugReporter.class.desiredAssertionStatus();
        DEBUG_MISSING_CLASSES = SystemProperties.getBoolean("findbugs.debug.missingclasses");
    }

    private static class Error {
        private int sequence;
        private String message;
        private Throwable cause;

        public Error(int sequence, String message) {
            this(sequence, message, null);
        }

        public Error(int sequence, String message, Throwable cause) {
            this.sequence = sequence;
            this.message = message;
            this.cause = cause;
        }

        public int getSequence() {
            return this.sequence;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public int hashCode() {
            int hashCode = this.message.hashCode();
            if (this.cause != null) {
                hashCode += 1009 * this.cause.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Error other = (Error)obj;
            if (!this.message.equals(other.message)) {
                return false;
            }
            if (this.cause == other.cause) {
                return true;
            }
            if (this.cause == null || other.cause == null) {
                return false;
            }
            return this.cause.equals(other.cause);
        }
    }
}

