/* valaccodeobjecttypesymbolbinding.vala
 *
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#ifndef __GOBJECT_VALACCODEOBJECTTYPESYMBOLBINDING_H__
#define __GOBJECT_VALACCODEOBJECTTYPESYMBOLBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <ccode/valaccodefragment.h>
#include <vala/valaobjecttypesymbol.h>
#include <gobject/valaccodetypesymbolbinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING (vala_ccode_object_type_symbol_binding_get_type ())
#define VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING, ValaCCodeObjectTypeSymbolBinding))
#define VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING, ValaCCodeObjectTypeSymbolBindingClass))
#define VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING))
#define VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING))
#define VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING, ValaCCodeObjectTypeSymbolBindingClass))

typedef struct _ValaCCodeObjectTypeSymbolBinding ValaCCodeObjectTypeSymbolBinding;
typedef struct _ValaCCodeObjectTypeSymbolBindingClass ValaCCodeObjectTypeSymbolBindingClass;
typedef struct _ValaCCodeObjectTypeSymbolBindingPrivate ValaCCodeObjectTypeSymbolBindingPrivate;

struct _ValaCCodeObjectTypeSymbolBinding {
	ValaCCodeTypeSymbolBinding parent_instance;
	ValaCCodeObjectTypeSymbolBindingPrivate * priv;
};

struct _ValaCCodeObjectTypeSymbolBindingClass {
	ValaCCodeTypeSymbolBindingClass parent_class;
};


ValaCCodeFragment* vala_ccode_object_type_symbol_binding_register_dbus_info (ValaCCodeObjectTypeSymbolBinding* self, ValaObjectTypeSymbol* bindable);
GType vala_ccode_object_type_symbol_binding_get_type (void);


G_END_DECLS

#endif
