/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;

public class JkInputStream
implements InputBuffer,
OutputBuffer {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$JkInputStream == null ? (class$org$apache$jk$common$JkInputStream = JkInputStream.class$("org.apache.jk.common.JkInputStream")) : class$org$apache$jk$common$JkInputStream));
    private Msg bodyMsg;
    private Msg outputMsg;
    private MsgContext mc;
    private MessageBytes bodyBuff = MessageBytes.newInstance();
    private MessageBytes tempMB = MessageBytes.newInstance();
    private boolean end_of_stream = false;
    private boolean isEmpty = true;
    private boolean isFirst = true;
    private boolean isReplay = false;
    private boolean isReadRequired = false;
    private int packetSize = 8192;
    static /* synthetic */ Class class$org$apache$jk$common$JkInputStream;

    public JkInputStream(MsgContext context, int bsize) {
        this.mc = context;
        this.packetSize = bsize < 8192 ? 8192 : bsize;
        this.bodyMsg = new MsgAjp(this.packetSize);
        this.outputMsg = new MsgAjp(this.packetSize);
    }

    public JkInputStream(MsgContext context) {
        this(context, 8192);
    }

    public void setIsReadRequired(boolean irr) {
        this.isReadRequired = irr;
    }

    public boolean isReadRequired() {
        return this.isReadRequired;
    }

    public void recycle() {
        if (this.isReadRequired && this.isFirst) {
            try {
                this.receive();
            }
            catch (IOException iex) {
                log.debug((Object)"Error consuming request body", (Throwable)iex);
            }
        }
        this.end_of_stream = false;
        this.isEmpty = true;
        this.isFirst = true;
        this.isReplay = false;
        this.isReadRequired = false;
        this.bodyBuff.recycle();
        this.tempMB.recycle();
    }

    public void endMessage() throws IOException {
        this.outputMsg.reset();
        this.outputMsg.appendByte(5);
        this.outputMsg.appendByte(1);
        this.mc.getSource().send(this.outputMsg, this.mc);
        this.mc.getSource().flush(this.outputMsg, this.mc);
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!res.isCommitted()) {
            res.sendHeaders();
        }
        int len = chunk.getLength();
        byte[] buf = this.outputMsg.getBuffer();
        int chunkSize = buf.length - this.outputMsg.getHeaderLength() - 4;
        int off = 0;
        while (len > 0) {
            int thisTime = len;
            if (thisTime > chunkSize) {
                thisTime = chunkSize;
            }
            len -= thisTime;
            this.outputMsg.reset();
            this.outputMsg.appendByte(3);
            if (log.isTraceEnabled()) {
                log.trace((Object)("doWrite " + off + " " + thisTime + " " + len));
            }
            this.outputMsg.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
            off += thisTime;
            this.mc.getSource().send(this.outputMsg, this.mc);
        }
        return 0;
    }

    public int doRead(ByteChunk responseChunk, Request req) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doRead " + this.end_of_stream + " " + responseChunk.getOffset() + " " + responseChunk.getLength()));
        }
        if (this.end_of_stream) {
            return -1;
        }
        if (this.isFirst && this.isReadRequired) {
            if (!this.receive()) {
                return 0;
            }
        } else if (this.isEmpty && !this.refillReadBuffer()) {
            return -1;
        }
        ByteChunk bc = this.bodyBuff.getByteChunk();
        responseChunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
        this.isEmpty = true;
        return responseChunk.getLength();
    }

    public boolean receive() throws IOException {
        this.isFirst = false;
        this.bodyMsg.reset();
        int err = this.mc.getSource().receive(this.bodyMsg, this.mc);
        if (log.isDebugEnabled()) {
            log.info((Object)("Receiving: getting request body chunk " + err + " " + this.bodyMsg.getLen()));
        }
        if (err < 0) {
            throw new IOException();
        }
        if (this.bodyMsg.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMsg.peekInt();
        if (blen == 0) {
            return false;
        }
        if (log.isTraceEnabled()) {
            this.bodyMsg.dump("Body buffer");
        }
        this.bodyMsg.getBytes(this.bodyBuff);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Data:\n" + this.bodyBuff));
        }
        this.isEmpty = false;
        return true;
    }

    private boolean refillReadBuffer() throws IOException {
        if (this.isReplay) {
            this.end_of_stream = true;
        }
        if (this.end_of_stream) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"refillReadBuffer: end of stream ");
            }
            return false;
        }
        this.bodyMsg.reset();
        this.bodyMsg.appendByte(6);
        this.bodyMsg.appendInt(this.packetSize - 4 - 2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("refillReadBuffer " + Thread.currentThread()));
        }
        this.mc.getSource().send(this.bodyMsg, this.mc);
        this.mc.getSource().flush(this.bodyMsg, this.mc);
        boolean moreData = this.receive();
        if (!moreData) {
            this.end_of_stream = true;
        }
        return moreData;
    }

    public void appendHead(Response res) throws IOException {
        long contentLength;
        String contentLanguage;
        if (log.isDebugEnabled()) {
            log.debug((Object)("COMMIT sending headers " + res + " " + res.getMimeHeaders()));
        }
        C2BConverter c2b = this.mc.getConverter();
        this.outputMsg.reset();
        this.outputMsg.appendByte(4);
        this.outputMsg.appendInt(res.getStatus());
        String message = res.getMessage();
        message = message == null ? HttpMessages.getMessage((int)res.getStatus()) : message.replace('\n', ' ').replace('\r', ' ');
        this.tempMB.setString(message);
        c2b.convert(this.tempMB);
        this.outputMsg.appendBytes(this.tempMB);
        MimeHeaders headers = res.getMimeHeaders();
        String contentType = res.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = res.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = res.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        int numHeaders = headers.size();
        this.outputMsg.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            c2b.convert(hN);
            this.outputMsg.appendBytes(hN);
            MessageBytes hV = headers.getValue(i);
            c2b.convert(hV);
            this.outputMsg.appendBytes(hV);
        }
        this.mc.getSource().send(this.outputMsg, this.mc);
    }

    public void setReplay(ByteChunk replay) {
        this.isFirst = false;
        this.isEmpty = false;
        this.isReplay = true;
        this.bodyBuff.setBytes(replay.getBytes(), replay.getStart(), replay.getLength());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("org.apache.tomcat.util.http.HttpMessages");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

