/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.catalina.startup.BootstrapServiceContext;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.catalina.startup.SecurityClassLoad;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;

public final class BootstrapService
implements Daemon {
    private static Daemon service = null;
    private static int debug = 0;
    private Object catalinaService = null;

    public void init(DaemonContext context) throws Exception {
        Object[] param;
        String[] arguments = null;
        if (context != null && (arguments = context.getArguments()) != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (!arguments[i].equals("-debug")) continue;
                debug = 1;
            }
        }
        BootstrapService.log("Create Catalina server");
        this.setCatalinaHome();
        this.setCatalinaBase();
        ClassLoader commonLoader = null;
        ClassLoader catalinaLoader = null;
        ClassLoader sharedLoader = null;
        try {
            File[] unpacked = new File[1];
            File[] packed = new File[1];
            File[] packed2 = new File[2];
            ClassLoaderFactory.setDebug(debug);
            unpacked[0] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "classes");
            packed2[0] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "endorsed");
            packed2[1] = new File(BootstrapService.getCatalinaHome(), "common" + File.separator + "lib");
            commonLoader = ClassLoaderFactory.createClassLoader(unpacked, packed2, null);
            unpacked[0] = new File(BootstrapService.getCatalinaHome(), "server" + File.separator + "classes");
            packed[0] = new File(BootstrapService.getCatalinaHome(), "server" + File.separator + "lib");
            catalinaLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
            System.err.println("Created catalinaLoader in: " + BootstrapService.getCatalinaHome() + File.separator + "server" + File.separator + "lib");
            unpacked[0] = new File(BootstrapService.getCatalinaBase(), "shared" + File.separator + "classes");
            packed[0] = new File(BootstrapService.getCatalinaBase(), "shared" + File.separator + "lib");
            sharedLoader = ClassLoaderFactory.createClassLoader(unpacked, packed, commonLoader);
        }
        catch (Throwable t) {
            BootstrapService.log("Class loader creation threw exception", t);
        }
        Thread.currentThread().setContextClassLoader(catalinaLoader);
        SecurityClassLoad.securityClassLoad(catalinaLoader);
        if (debug >= 1) {
            BootstrapService.log("Loading startup class");
        }
        Class<?> startupClass = catalinaLoader.loadClass("org.apache.catalina.startup.CatalinaService");
        Object startupInstance = startupClass.newInstance();
        if (debug >= 1) {
            BootstrapService.log("Setting startup class properties");
        }
        String methodName = "setParentClassLoader";
        Class[] paramTypes = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] paramValues = new Object[]{sharedLoader};
        Method method = startupInstance.getClass().getMethod(methodName, paramTypes);
        method.invoke(startupInstance, paramValues);
        this.catalinaService = startupInstance;
        methodName = "load";
        if (arguments == null || arguments.length == 0) {
            paramTypes = null;
            param = null;
        } else {
            paramTypes[0] = arguments.getClass();
            param = new Object[]{arguments};
        }
        method = this.catalinaService.getClass().getMethod(methodName, paramTypes);
        if (debug >= 1) {
            BootstrapService.log("Calling startup class " + method);
        }
        method.invoke(this.catalinaService, param);
    }

    public void start() throws Exception {
        BootstrapService.log("Starting service");
        String methodName = "start";
        Method method = this.catalinaService.getClass().getMethod(methodName, null);
        method.invoke(this.catalinaService, null);
        BootstrapService.log("Service started");
    }

    public void stop() throws Exception {
        BootstrapService.log("Stopping service");
        String methodName = "stop";
        Method method = this.catalinaService.getClass().getMethod(methodName, null);
        method.invoke(this.catalinaService, null);
        BootstrapService.log("Service stopped");
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!"-debug".equals(args[i])) continue;
            debug = 1;
        }
        if (service == null) {
            service = new BootstrapService();
            try {
                BootstrapServiceContext p0 = new BootstrapServiceContext();
                p0.setArguments(args);
                service.init(p0);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
        try {
            String command = args[0];
            if (command.equals("start")) {
                service.start();
            } else if (command.equals("stop")) {
                service.stop();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        if (System.getProperty("catalina.home") != null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        } else {
            System.setProperty("catalina.base", System.getProperty("user.dir"));
        }
    }

    private void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        System.setProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static String getCatalinaHome() {
        return System.getProperty("catalina.home", System.getProperty("user.dir"));
    }

    private static String getCatalinaBase() {
        return System.getProperty("catalina.base", BootstrapService.getCatalinaHome());
    }

    private static void log(String message) {
        System.out.print("Bootstrap: ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        BootstrapService.log(message);
        exception.printStackTrace(System.out);
    }
}

