/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics;

import java.awt.EventQueue;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.topics.screen.TopicsTopComponent;

public class TopicsAction
extends CallableSystemAction
implements InitialAction {
    public TopicsAction() {
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                TopicsAction.this.enableDisable();
            }
        });
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/Topics.png";
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TopicsAction");
    }

    private void enableDisable() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                TopicsAction.this.setEnabled(data != null);
            }
        });
    }

    public String getID() {
        return "topics";
    }

    public void performAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                if (data == null) {
                    return;
                }
                WindowUtils.closeWindows();
                TopicsTopComponent tc = TopicsTopComponent.findInstance();
                Mode mode = WindowManager.getDefault().findMode("Setup");
                if (mode != null) {
                    mode.dockInto((TopComponent)tc);
                }
                tc.open();
                tc.requestActive();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.topics");
    }
}

