/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class FileBasedURLMapper
extends URLMapper {
    public final URL getURL(FileObject fileObject, int n) {
        if (n == 2) {
            return null;
        }
        URL uRL = null;
        try {
            if (fileObject instanceof BaseFileObj) {
                BaseFileObj baseFileObj = (BaseFileObj)fileObject;
                uRL = FileBasedURLMapper.fileToURL(baseFileObj.getFileName().getFile(), fileObject);
            } else if (fileObject instanceof RootObj) {
                RootObj rootObj = (RootObj)fileObject;
                return this.getURL((FileObject)rootObj.getRealRoot(), n);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public final FileObject[] getFileObjects(URL uRL) {
        File file;
        if (!"file".equals(uRL.getProtocol())) {
            return null;
        }
        FileObject fileObject = null;
        try {
            file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(uRISyntaxException.getLocalizedMessage()).append(" [").append(uRL.toExternalForm()).append(']');
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
            if (Utilities.isWindows() && uRL.getAuthority() != null) {
                Exceptions.attachLocalizedMessage((Throwable)illegalArgumentException, (String)NbBundle.getMessage(FileBasedURLMapper.class, (String)"MSG_UNC_PATH"));
            }
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
            return null;
        }
        FileBasedFileSystem.getInstance();
        fileObject = FileBasedFileSystem.getFileObject(file, FileObjectFactory.Caller.ToFileObject);
        return new FileObject[]{fileObject};
    }

    private static URL fileToURL(File file, FileObject fileObject) throws MalformedURLException {
        String string;
        URL uRL = null;
        if (fileObject.isFolder() && (!fileObject.isValid() || fileObject.isVirtual()) && !(string = file.toURI().toURL().toExternalForm()).endsWith("/")) {
            uRL = new URL(string + "/");
        }
        uRL = uRL == null ? file.toURI().toURL() : uRL;
        return uRL;
    }
}

