/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.dao;

import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import tr.util.Observable;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.ActionsScreens;
import tr.view.actions.screens.columns.ActionsColumn;
import tr.view.actions.screens.dao.ScreensDAO;
import tr.view.actions.screens.filters.ActionsFilter;

final class ScreensDAOProperties
implements ScreensDAO {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    private static final Preferences trPrefs = Preferences.userRoot().node("ThinkingRock");
    private static final String PREFS_PATH_SCREENS = "actions/screens";
    private static ScreensDAO instance;
    private ActionsScreens actionsScreens;

    public static ScreensDAO getInstance() {
        if (instance == null) {
            instance = new ScreensDAOProperties();
        }
        return instance;
    }

    private ScreensDAOProperties() {
    }

    public ActionsScreens getData() {
        if (this.actionsScreens != null) {
            return this.actionsScreens;
        }
        if (this.hasPersistantData()) {
            try {
                this.restore();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.actionsScreens == null) {
            this.actionsScreens = new ActionsScreens();
        }
        return this.actionsScreens;
    }

    public boolean hasPersistantData() {
        try {
            return trPrefs.nodeExists(PREFS_PATH_SCREENS);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void delete() {
        try {
            trPrefs.remove(PREFS_PATH_SCREENS);
            trPrefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void persist() throws Exception {
    }

    public void restore() throws Exception {
        if (this.hasPersistantData()) {
            this.load();
        }
    }

    private void load() {
        LOG.fine("Attempting to load actions screens from preferences.");
        this.actionsScreens = new ActionsScreens();
        if (!this.hasPersistantData()) {
            return;
        }
        try {
            Preferences prefs = trPrefs.node(PREFS_PATH_SCREENS);
            int i = 0;
            while (prefs.nodeExists("screen" + i)) {
                Preferences prefsScreen = prefs.node("screen" + i++);
                ActionsScreen screen = ActionsScreen.create(prefsScreen.get("key", ""));
                screen.setColumnOrder(prefsScreen.getByteArray("order", null));
                screen.setSortColumns(prefsScreen.getByteArray("sortfields", null));
                screen.setSortStatus(prefsScreen.getByteArray("sortstatus", null));
                int j = -1;
                while (prefsScreen.nodeExists("field" + ++j)) {
                    Preferences prefsField = prefsScreen.node("field" + j);
                    ActionsColumn field = (ActionsColumn)screen.getColumns().get(j);
                    field.setVisible(prefsField.getBoolean("visible", field.isVisible()));
                    field.setWidth(prefsField.getInt("width", field.getWidth()));
                }
                int k = -1;
                while (prefsScreen.nodeExists("filter" + ++k)) {
                    String value;
                    Preferences prefsFilter = prefsScreen.node("filter" + k);
                    ActionsFilter filter = screen.getFilters().get(k);
                    filter.setUsed(prefsFilter.getBoolean("used", false));
                    filter.setShown(prefsFilter.getBoolean("visible", false));
                    Preferences prefsValues = prefsFilter.node("values");
                    Vector<String> values = new Vector<String>();
                    for (int n = 0; n < Integer.MAX_VALUE && !"%%%NONE%%%".equals(value = prefsValues.get("value" + n, "%%%NONE%%%")); ++n) {
                        values.add(value);
                    }
                    filter.setSerialValues(values.toArray(new String[0]));
                }
                screen.setShowFilters(prefsScreen.getBoolean("showFilters", true));
                this.actionsScreens.getScreens().add((Observable)screen);
            }
        }
        catch (BackingStoreException ex) {
            LOG.severe("Backing Store Exception");
        }
    }

    public void reset() {
    }
}

