/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class InlineContainer
extends FObj {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private String id;
    private SpaceProperty lineHeight;
    private boolean blockItemFound = false;

    public InlineContainer(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.dominantBaseline = pList.get(82).getEnum();
        this.id = pList.get(113).getString();
        this.lineHeight = pList.get(131).getSpace();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            this.missingChildElementError("marker* (%block;)+");
        }
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalName() {
        return "inline-container";
    }

    public int getNameId() {
        return 16;
    }
}

