/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jdesktop.swingx.renderer.CellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeCellContext
extends CellContext<JTree> {
    protected Icon leafIcon;
    protected Icon closedIcon;
    protected Icon openIcon;
    private Border treeFocusBorder;

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    protected Color getSelectionBackground() {
        return UIManager.getColor("Tree.selectionBackground");
    }

    @Override
    protected Color getSelectionForeground() {
        return UIManager.getColor("Tree.selectionForeground");
    }

    @Override
    protected String getUIPrefix() {
        return "Tree.";
    }

    protected Icon getLeafIcon() {
        return this.leafIcon != null ? this.leafIcon : UIManager.getIcon(this.getUIKey("leafIcon"));
    }

    protected Icon getOpenIcon() {
        return this.openIcon != null ? this.openIcon : UIManager.getIcon(this.getUIKey("openIcon"));
    }

    protected Icon getClosedIcon() {
        return this.closedIcon != null ? this.closedIcon : UIManager.getIcon(this.getUIKey("closedIcon"));
    }

    @Override
    public Icon getIcon() {
        if (this.isLeaf()) {
            return this.getLeafIcon();
        }
        if (this.isExpanded()) {
            return this.getOpenIcon();
        }
        return this.getClosedIcon();
    }

    @Override
    protected Border getFocusBorder() {
        if (this.treeFocusBorder == null) {
            this.treeFocusBorder = new TreeFocusBorder();
        }
        return this.treeFocusBorder;
    }

    public class TreeFocusBorder
    extends LineBorder {
        private Color treeBackground;
        private Color focusColor;

        public TreeFocusBorder() {
            super(Color.BLACK);
            this.treeBackground = TreeCellContext.this.getBackground();
            if (this.treeBackground != null) {
                this.focusColor = new Color(~this.treeBackground.getRGB());
            }
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color color = UIManager.getColor("Tree.selectionBorderColor");
            if (color != null) {
                this.lineColor = color;
            }
            if (this.isDashed()) {
                if (this.treeBackground != c.getBackground()) {
                    this.treeBackground = c.getBackground();
                    this.focusColor = new Color(~this.treeBackground.getRGB());
                }
                Color old = g.getColor();
                g.setColor(this.focusColor);
                BasicGraphicsUtils.drawDashedRect(g, x, y, width, height);
                g.setColor(old);
            } else {
                super.paintBorder(c, g, x, y, width, height);
            }
        }

        private boolean isDashed() {
            return Boolean.TRUE.equals(UIManager.get("Tree.drawDashedFocusIndicator"));
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

