/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.date.combo;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import tr.swing.date.chooser.DateChooser;
import tr.swing.date.chooser.DateChooserDialog;
import tr.swing.date.combo.DateItem;
import tr.swing.date.combo.DateType;

public class DateCombo
extends JComboBox
implements ActionListener {
    public static final String PROPERTY_DATE = "date";
    private final Frame frame;
    private final boolean calc;
    private final DateFormat df;
    private final DateItem chosen;
    private final DateChooser dateChooser;

    public DateCombo(Frame frame, DateItem[] items, boolean calc, DateFormat df) {
        super(new DefaultComboBoxModel<DateItem>(items));
        this.frame = frame;
        this.calc = calc;
        this.df = df;
        this.dateChooser = new DateChooser(frame);
        this.chosen = new DateItem(DateType.NONE, "", 0L);
        this.insertItemAt(this.chosen, 0);
        this.setMaximumRowCount(items.length + 1);
        this.setSelectedItem(null);
        this.addActionListener(this);
    }

    public void stopChangeEvents() {
        this.removeActionListener(this);
    }

    public void startChangeEvents() {
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        DateItem item = (DateItem)this.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item == DateItem.DATE_CHOOSER) {
            DateChooserDialog dialog = this.dateChooser.getDialog();
            Date date = dialog.select(DateCombo.getDate(this.chosen), this);
            if (dialog.cancelled()) {
                this.setSelectedIndex(0);
                return;
            }
            if (date == null) {
                this.chosen.type = DateItem.NONE.type;
                this.chosen.label = DateItem.NONE.label;
                this.chosen.value = DateItem.NONE.value;
            } else {
                this.chosen.type = DateType.MS;
                this.chosen.label = this.df.format(date);
                this.chosen.value = date.getTime();
            }
        } else if (this.calc) {
            if (item.type == DateType.DAYS) {
                Calendar c = Calendar.getInstance();
                c.add(6, (int)item.value);
                this.chosen.type = DateType.MS;
                this.chosen.label = this.df.format(c.getTime());
                this.chosen.value = c.getTimeInMillis();
            } else if (item.type == DateType.MS) {
                this.chosen.type = DateType.MS;
                this.chosen.label = this.df.format(new Date(item.value));
                this.chosen.value = item.value;
            }
        } else {
            this.chosen.type = item.type;
            this.chosen.label = item.label;
            this.chosen.value = item.value;
        }
        this.setSelectedIndex(0);
        this.fireValueChange();
    }

    public void fireValueChange() {
        this.firePropertyChange(PROPERTY_DATE, null, null);
    }

    public DateItem getDateItem(DateType type, long value) {
        if (type == DateType.MS) {
            this.chosen.type = type;
            this.chosen.value = value;
            this.chosen.label = this.df.format(new Date(value));
            return this.chosen;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            DateItem item = (DateItem)this.getItemAt(i);
            if (item.type != type || item.value != value) continue;
            return item;
        }
        return null;
    }

    public void setSelectedItem(Object object) {
        if (object instanceof DateItem) {
            DateItem dateItem = (DateItem)object;
            super.setSelectedItem(this.getDateItem(dateItem.type, dateItem.value));
        } else {
            super.setSelectedItem(object);
        }
    }

    public static Date getDate(DateItem item) {
        if (item == null) {
            return null;
        }
        if (item.type == DateType.DAYS) {
            Calendar c = Calendar.getInstance();
            c.add(6, (int)item.value);
            return c.getTime();
        }
        if (item.type == DateType.MS) {
            return new Date(item.value);
        }
        return null;
    }
}

