/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Dur
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5013232281547134583L;
    private static final int DAYS_PER_WEEK = 7;
    private static final int WEEKS_PER_YEAR = 52;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int DAYS_PER_YEAR = 365;
    private Log log = LogFactory.getLog((Class)Dur.class);
    private boolean negative;
    private int weeks;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;

    public Dur(String value) {
        this.negative = false;
        this.weeks = 0;
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        String token = null;
        String prevToken = null;
        StringTokenizer t = new StringTokenizer(value, "+-PWDTHMS", true);
        while (t.hasMoreTokens()) {
            prevToken = token;
            token = t.nextToken();
            if ("+".equals(token)) {
                this.negative = false;
                continue;
            }
            if ("-".equals(token)) {
                this.negative = true;
                continue;
            }
            if ("P".equals(token)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Redundant [P] token ignored.");
                continue;
            }
            if ("W".equals(token)) {
                this.weeks = Integer.parseInt(prevToken);
                continue;
            }
            if ("D".equals(token)) {
                this.days = Integer.parseInt(prevToken);
                continue;
            }
            if ("T".equals(token)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Redundant [T] token ignored.");
                continue;
            }
            if ("H".equals(token)) {
                this.hours = Integer.parseInt(prevToken);
                continue;
            }
            if ("M".equals(token)) {
                this.minutes = Integer.parseInt(prevToken);
                continue;
            }
            if (!"S".equals(token)) continue;
            this.seconds = Integer.parseInt(prevToken);
        }
    }

    public Dur(int weeks) {
        this.weeks = weeks;
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
    }

    public Dur(int days, int hours, int minutes, int seconds) {
        this.weeks = 0;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public Dur(Date start, Date end) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        int yearDelta = endCal.get(1) - startCal.get(1);
        int weekDelta = endCal.get(3) - startCal.get(3);
        int dayDelta = endCal.get(6) - startCal.get(6);
        int hourDelta = endCal.get(11) - startCal.get(11);
        int minuteDelta = endCal.get(12) - startCal.get(12);
        int secondDelta = endCal.get(13) - startCal.get(13);
        if (yearDelta < 0 || yearDelta == 0 && dayDelta < 0 || yearDelta == 0 && dayDelta == 0 && hourDelta < 0 || yearDelta == 0 && dayDelta == 0 && hourDelta == 0 && minuteDelta < 0 || yearDelta == 0 && dayDelta == 0 && hourDelta == 0 && minuteDelta == 0 && secondDelta < 0) {
            this.negative = true;
        }
        if (dayDelta % 7 + hourDelta + minuteDelta + secondDelta == 0) {
            while (startCal.get(1) != endCal.get(1)) {
                weekDelta = 52 * (endCal.get(1) - startCal.get(1));
                this.weeks += weekDelta;
                startCal.add(3, weekDelta);
            }
            if (startCal.get(3) != endCal.get(3)) {
                weekDelta = endCal.get(3) - startCal.get(3);
                this.weeks += weekDelta;
            }
            this.weeks = Math.abs(this.weeks);
            this.days = 0;
            this.hours = 0;
            this.minutes = 0;
            this.seconds = 0;
        } else {
            if (secondDelta > 0 && this.negative) {
                startCal.add(12, -1);
                this.seconds = 60 - secondDelta;
            } else if (secondDelta < 0 && !this.negative) {
                startCal.add(12, 1);
                this.seconds = 60 + secondDelta;
            } else {
                this.seconds = Math.abs(secondDelta);
            }
            minuteDelta = endCal.get(12) - startCal.get(12);
            if (minuteDelta > 0 && this.negative) {
                startCal.add(10, -1);
                this.minutes = 60 - minuteDelta;
            } else if (minuteDelta < 0 && !this.negative) {
                startCal.add(10, 1);
                this.minutes = 60 + minuteDelta;
            } else {
                this.minutes = Math.abs(minuteDelta);
            }
            hourDelta = endCal.get(11) - startCal.get(11);
            if (hourDelta > 0 && this.negative) {
                startCal.add(6, -1);
                this.hours = 24 - hourDelta;
            } else if (hourDelta < 0 && !this.negative) {
                startCal.add(6, 1);
                this.hours = 24 + hourDelta;
            } else {
                this.hours = Math.abs(hourDelta);
            }
            while (startCal.get(1) != endCal.get(1)) {
                dayDelta = 365 * (endCal.get(1) - startCal.get(1));
                this.days += dayDelta;
                startCal.add(6, dayDelta);
            }
            if (startCal.get(6) != endCal.get(6)) {
                this.days += endCal.get(6) - startCal.get(6);
            }
            this.days = Math.abs(this.days);
            this.weeks = 0;
        }
    }

    public final Date getTime(Date start) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        if (this.isNegative()) {
            cal.add(3, -this.weeks);
            cal.add(7, -this.days);
            cal.add(11, -this.hours);
            cal.add(12, -this.minutes);
            cal.add(13, -this.seconds);
        } else {
            cal.add(3, this.weeks);
            cal.add(7, this.days);
            cal.add(11, this.hours);
            cal.add(12, this.minutes);
            cal.add(13, this.seconds);
        }
        return cal.getTime();
    }

    public final Dur negate() {
        Dur negated = new Dur(this.days, this.hours, this.minutes, this.seconds);
        negated.weeks = this.weeks;
        negated.negative = !this.negative;
        return negated;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        if (this.negative) {
            b.append('-');
        }
        b.append('P');
        if (this.weeks > 0) {
            b.append(this.weeks);
            b.append('W');
        } else {
            if (this.days > 0) {
                b.append(this.days);
                b.append('D');
            }
            if (this.hours > 0 || this.minutes > 0 || this.seconds > 0) {
                b.append('T');
                if (this.hours > 0) {
                    b.append(this.hours);
                    b.append('H');
                }
                if (this.minutes > 0) {
                    b.append(this.minutes);
                    b.append('M');
                }
                if (this.seconds > 0) {
                    b.append(this.seconds);
                    b.append('S');
                }
            }
        }
        return b.toString();
    }

    public final int compareTo(Object arg0) {
        return this.compareTo((Dur)arg0);
    }

    public final int compareTo(Dur arg0) {
        if (this.isNegative() != arg0.isNegative()) {
            if (this.isNegative()) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        if (this.getWeeks() != arg0.getWeeks()) {
            return this.getWeeks() - arg0.getWeeks();
        }
        if (this.getDays() != arg0.getDays()) {
            return this.getDays() - arg0.getDays();
        }
        if (this.getHours() != arg0.getHours()) {
            return this.getHours() - arg0.getHours();
        }
        if (this.getMinutes() != arg0.getMinutes()) {
            return this.getMinutes() - arg0.getMinutes();
        }
        return this.getSeconds() - arg0.getSeconds();
    }

    public final int getDays() {
        return this.days;
    }

    public final int getHours() {
        return this.hours;
    }

    public final int getMinutes() {
        return this.minutes;
    }

    public final boolean isNegative() {
        return this.negative;
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final int getWeeks() {
        return this.weeks;
    }
}

