/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.Serializable;
import java.util.Iterator;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;

public abstract class Component
implements Serializable {
    public static final String BEGIN = "BEGIN";
    public static final String END = "END";
    public static final String VEVENT = "VEVENT";
    public static final String VTODO = "VTODO";
    public static final String VJOURNAL = "VJOURNAL";
    public static final String VFREEBUSY = "VFREEBUSY";
    public static final String VTIMEZONE = "VTIMEZONE";
    public static final String VALARM = "VALARM";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private String name;
    private PropertyList properties;

    protected Component(String s) {
        this(s, new PropertyList());
    }

    protected Component(String s, PropertyList p) {
        this.name = s;
        this.properties = p;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(BEGIN);
        buffer.append(':');
        buffer.append(this.getName());
        buffer.append("\r\n");
        buffer.append(this.getProperties());
        buffer.append(END);
        buffer.append(':');
        buffer.append(this.getName());
        buffer.append("\r\n");
        return buffer.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final PropertyList getProperties() {
        return this.properties;
    }

    public final PropertyList getProperties(String name) {
        return this.getProperties().getProperties(name);
    }

    public final Property getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public final void validate() throws ValidationException {
        this.validate(true);
    }

    public abstract void validate(boolean var1) throws ValidationException;

    protected final void validateProperties() throws ValidationException {
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            property.validate();
        }
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Component) {
            Component c = (Component)arg0;
            return this.getName().equals(c.getName()) && this.getProperties().equals(c.getProperties());
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return this.getName().hashCode() + this.getProperties().hashCode();
    }
}

