/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.prefs;

import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class ExtractPrefs {
    private static final Logger LOG = Logger.getLogger("tr.extract.prefs");
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/extract");
    private static final String KEY_PATH = "path";
    private static final String DEF_PATH = System.getProperty("user.home");
    private static final String KEY_ENCODING = "encoding";
    private static final String DEF_ENCODING = "";

    public static final String getPath() {
        return prefs.get(KEY_PATH, DEF_PATH);
    }

    public static final void setPath(String value) {
        prefs.put(KEY_PATH, value);
        ExtractPrefs.flush();
    }

    public static final String getEncoding() {
        return prefs.get(KEY_ENCODING, DEF_ENCODING);
    }

    public static final void setEncoding(String value) {
        prefs.put(KEY_ENCODING, value == null ? DEF_ENCODING : value.trim());
        ExtractPrefs.flush();
    }

    private static void flush() {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            LOG.severe("Extract preferences error. " + ex.getMessage());
        }
    }
}

