/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VisualizerNode
extends EventListenerList
implements NodeListener,
TreeNode,
Runnable {
    private static final VisualizerNode TEMPLATE = new VisualizerNode(0);
    static final Logger LOG = Logger.getLogger(VisualizerNode.class.getName());
    private static final Reference<VisualizerChildren> NO_REF = new WeakReference<Object>(null);
    private static WeakHashMap<VisualizerNode, Reference<VisualizerNode>> cache = new WeakHashMap();
    public static final VisualizerNode EMPTY = VisualizerNode.getVisualizer(null, Node.EMPTY);
    private static final QP QUEUE = new QP();
    private static final String UNKNOWN = new String();
    static final long serialVersionUID = 3726728244698316872L;
    private static final String NO_HTML_DISPLAYNAME = "noHtmlDisplayName";
    private static Icon defaultIcon;
    private static final String DEFAULT_ICON = "org/openide/nodes/defaultNode.png";
    private Icon icon = null;
    Node node;
    private int hashCode;
    private Reference<VisualizerChildren> children = NO_REF;
    private VisualizerChildren parent;
    private String name;
    private String displayName;
    private String shortDescription;
    private transient boolean inRead;
    private String htmlDisplayName = null;
    private int cachedIconType = -1;

    private VisualizerNode(int n) {
        this.hashCode = n;
        this.node = null;
    }

    private VisualizerNode(Node node) {
        this.node = node;
        this.hashCode = System.identityHashCode(this.node);
        this.node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)this.node));
        this.name = UNKNOWN;
        this.displayName = UNKNOWN;
        this.shortDescription = UNKNOWN;
    }

    public static VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node) {
        return VisualizerNode.getVisualizer(visualizerChildren, node, true);
    }

    public static synchronized VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node, boolean bl) {
        VisualizerNode visualizerNode;
        VisualizerNode.TEMPLATE.hashCode = System.identityHashCode(node);
        VisualizerNode.TEMPLATE.node = node;
        Reference<VisualizerNode> reference = cache.get(TEMPLATE);
        VisualizerNode.TEMPLATE.hashCode = 0;
        VisualizerNode.TEMPLATE.node = null;
        VisualizerNode visualizerNode2 = visualizerNode = reference == null ? null : reference.get();
        if (visualizerNode == null) {
            if (!bl) {
                return null;
            }
            visualizerNode = new VisualizerNode(node);
            cache.put(visualizerNode, new WeakReference<VisualizerNode>(visualizerNode));
        }
        if (visualizerChildren != null) {
            visualizerNode.parent = visualizerChildren;
        }
        return visualizerNode;
    }

    public String getShortDescription() {
        String string = this.shortDescription;
        if (string == UNKNOWN) {
            this.shortDescription = string = this.node.getShortDescription();
        }
        return string;
    }

    public String getDisplayName() {
        if (this.displayName == UNKNOWN) {
            this.displayName = this.node == null ? null : this.node.getDisplayName();
        }
        return this.displayName;
    }

    public String getName() {
        if (this.name == UNKNOWN) {
            this.name = this.node == null ? null : this.node.getName();
        }
        return this.name;
    }

    public List<VisualizerNode> getChildren() {
        VisualizerChildren visualizerChildren = this.children.get();
        if (visualizerChildren == null && !this.node.isLeaf()) {
            Node[] nodeArray = this.node.getChildren().getNodes();
            visualizerChildren = (VisualizerChildren)Children.MUTEX.readAccess((Mutex.Action)new Mutex.Action<VisualizerChildren>(){

                public VisualizerChildren run() {
                    Node[] nodeArray = VisualizerNode.this.node.getChildren().getNodes();
                    VisualizerChildren visualizerChildren = new VisualizerChildren(VisualizerNode.this, nodeArray);
                    VisualizerNode.this.notifyVisualizerChildrenChange(nodeArray.length, visualizerChildren);
                    return visualizerChildren;
                }
            });
        }
        if (LOG.isLoggable(Level.FINER)) assert (visualizerChildren == null || !visualizerChildren.list.contains(null)) : visualizerChildren.list + " from " + this.node;
        return visualizerChildren == null ? Collections.emptyList() : visualizerChildren.list;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getChildren().indexOf(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public TreeNode getChildAt(int n) {
        List<VisualizerNode> list = this.getChildren();
        VisualizerNode visualizerNode = list.get(n);
        assert (visualizerNode != null) : "Null child in " + list + " from " + this.node;
        return visualizerNode;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration<VisualizerNode> children() {
        List<VisualizerNode> list = this.getChildren();
        assert (!list.contains(null)) : "Null child in " + list + " from " + this.node;
        return Collections.enumeration(list);
    }

    @Override
    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    @Override
    public TreeNode getParent() {
        Node node = this.node.getParentNode();
        return node == null ? null : VisualizerNode.getVisualizer(null, node);
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = this.children.get();
        LOG.log(Level.FINER, "childrenAdded {0}", nodeMemberEvent);
        if (visualizerChildren == null) {
            LOG.log(Level.FINER, "childrenAdded - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Added(visualizerChildren, nodeMemberEvent.getDelta(), nodeMemberEvent.getDeltaIndices()));
        LOG.log(Level.FINER, "childrenAdded - end");
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = this.children.get();
        LOG.log(Level.FINER, "childrenRemoved {0}", nodeMemberEvent);
        if (visualizerChildren == null) {
            LOG.log(Level.FINER, "childrenRemoved - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Removed(visualizerChildren, nodeMemberEvent.getDelta()));
        LOG.log(Level.FINER, "childrenRemoved - end");
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        this.doChildrenReordered(nodeReorderEvent.getPermutation());
    }

    void doChildrenReordered(int[] nArray) {
        VisualizerChildren visualizerChildren = this.children.get();
        LOG.log(Level.FINER, "childrenReordered {0}", (Object)nArray);
        if (visualizerChildren == null) {
            LOG.log(Level.FINER, "childrenReordered - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Reordered(visualizerChildren, nArray));
        LOG.log(Level.FINER, "childrenReordered - end");
    }

    void reorderChildren(Comparator<VisualizerNode> comparator) {
        assert (SwingUtilities.isEventDispatchThread());
        VisualizerChildren visualizerChildren = this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        new VisualizerEvent.Reordered(visualizerChildren, comparator).run();
    }

    void naturalOrder() {
        this.children.clear();
        this.getChildren();
        this.reorderChildren(new Comparator<VisualizerNode>(){

            @Override
            public int compare(VisualizerNode visualizerNode, VisualizerNode visualizerNode2) {
                return 0;
            }
        });
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        String string = propertyChangeEvent.getPropertyName();
        boolean bl2 = bl = "icon".equals(string) || "openedIcon".equals(string);
        if ("name".equals(string) || "displayName".equals(string) || bl) {
            if (bl) {
                this.cachedIconType = -1;
            }
            if ("displayName".equals(string)) {
                this.htmlDisplayName = null;
            }
            QUEUE.runSafe(this);
            return;
        }
        if ("shortDescription".equals(string) && this.shortDescription != UNKNOWN) {
            QUEUE.runSafe(this);
            return;
        }
        if ("leaf".equals(string)) {
            QUEUE.runSafe(new PropLeafChange());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.inRead) {
            try {
                this.inRead = true;
                Children.MUTEX.readAccess((Runnable)this);
            }
            finally {
                this.inRead = false;
            }
            return;
        }
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
        for (VisualizerNode visualizerNode = this; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            Object[] objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).update(this);
            }
        }
    }

    void notifyVisualizerChildrenChange(int n, VisualizerChildren visualizerChildren) {
        this.children = n == 0 ? new StrongReference<VisualizerChildren>(visualizerChildren) : new WeakReference<VisualizerChildren>(visualizerChildren);
    }

    public synchronized void addNodeModel(NodeModel nodeModel) {
        this.add(NodeModel.class, nodeModel);
    }

    public synchronized void removeNodeModel(NodeModel nodeModel) {
        this.remove(NodeModel.class, nodeModel);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualizerNode)) {
            return false;
        }
        VisualizerNode visualizerNode = (VisualizerNode)object;
        return visualizerNode.node == this.node;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName == null) {
            this.htmlDisplayName = this.node.getHtmlDisplayName();
            if (this.htmlDisplayName == null) {
                this.htmlDisplayName = NO_HTML_DISPLAYNAME;
            }
        }
        return this.htmlDisplayName == NO_HTML_DISPLAYNAME ? null : this.htmlDisplayName;
    }

    Icon getIcon(boolean bl, boolean bl2) {
        int n = VisualizerNode.getCacheType(bl, bl2);
        if (this.cachedIconType != n) {
            Image image;
            int n2 = bl2 ? 2 : 1;
            Image image2 = image = bl ? this.node.getOpenedIcon(n2) : this.node.getIcon(n2);
            if (image == null) {
                String string = bl ? "getOpenedIcon" : "getIcon";
                LOG.warning("Node \"" + this.node.getName() + "\" [" + this.node.getClass().getName() + "] cannot return null from " + string + "(). See Node." + string + " contract.");
                this.icon = VisualizerNode.getDefaultIcon();
            } else {
                this.icon = new ImageIcon(image);
            }
        }
        this.cachedIconType = n;
        return this.icon;
    }

    private static final int getCacheType(boolean bl, boolean bl2) {
        return (bl ? 2 : 0) | (bl2 ? 1 : 0);
    }

    private static Icon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new ImageIcon(Utilities.loadImage((String)DEFAULT_ICON));
        }
        return defaultIcon;
    }

    static void runQueue() {
        QUEUE.run();
    }

    VisualizerNode[] getPathToRoot() {
        return this.getPathToRoot(0);
    }

    VisualizerNode[] getPathToRoot(int n) {
        VisualizerNode[] visualizerNodeArray = this.parent == null || this.parent.parent == null ? new VisualizerNode[n] : this.parent.parent.getPathToRoot(++n);
        visualizerNodeArray[visualizerNodeArray.length - n] = this;
        return visualizerNodeArray;
    }

    private class PropLeafChange
    implements Runnable {
        public void run() {
            VisualizerNode.this.children = NO_REF;
            for (VisualizerNode visualizerNode = VisualizerNode.this; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
                Object[] objectArray = visualizerNode.getListenerList();
                for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                    ((NodeModel)objectArray[i]).structuralChange(VisualizerNode.this);
                }
            }
        }
    }

    private static final class QP
    implements Runnable {
        private LinkedList<Runnable> queue = null;

        QP() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSafe(Runnable runnable) {
            boolean bl = false;
            QP qP = this;
            synchronized (qP) {
                if (this.queue == null) {
                    this.queue = new LinkedList();
                    bl = true;
                }
                this.queue.add(runnable);
            }
            if (bl) {
                if (Children.MUTEX.isWriteAccess()) {
                    Children.MUTEX.postReadRequest((Runnable)this);
                } else {
                    Mutex.EVENT.writeAccess((Runnable)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Enumeration<Runnable> enumeration;
            if (!Mutex.EVENT.isWriteAccess()) {
                Mutex.EVENT.writeAccess((Runnable)this);
                return;
            }
            Runnable runnable = this;
            synchronized (runnable) {
                if (this.queue == null) {
                    LOG.log(Level.FINER, "Queue empty");
                    return;
                }
                enumeration = Collections.enumeration(this.queue);
                this.queue = null;
                LOG.log(Level.FINER, "Queue emptied");
            }
            while (enumeration.hasMoreElements()) {
                runnable = enumeration.nextElement();
                LOG.log(Level.FINER, "Running {0}", runnable);
                Children.MUTEX.readAccess(runnable);
                LOG.log(Level.FINER, "Finished {0}", runnable);
                if (!(runnable instanceof PropLeafChange) || !enumeration.hasMoreElements()) continue;
                runnable = enumeration.nextElement();
                LOG.log(Level.FINER, "Removing {0}", runnable);
            }
            LOG.log(Level.FINER, "Queue processing over");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StrongReference<T>
    extends WeakReference<T> {
        private T o;

        public StrongReference(T t) {
            super(null);
            this.o = t;
        }

        @Override
        public T get() {
            return this.o;
        }
    }
}

