# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ConnectionInterfaceRenaming(dbus.service.Interface):
    """\
      An interface on connections to support protocols where the unique
    identifiers of contacts can change. Because handles are immutable,
    this is represented by a pair of handles, that representing the
    old name, and that representing the new one.
    """

    def __init__(self):
        self._interfaces.add('org.freedesktop.Telepathy.Connection.Interface.Renaming')

    @dbus.service.method('org.freedesktop.Telepathy.Connection.Interface.Renaming', in_signature='s', out_signature='')
    def RequestRename(self, name):
        """
        Request that the user's own identifier is changed on the server.
          If successful, a Renamed signal will be emitted for the current
          "self handle" as returned by GetSelfHandle.
        It is protocol-dependent how the identifier that's actually
          used will be derived from the supplied identifier; some sort of
          normalization might take place.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Connection.Interface.Renaming', signature='uu')
    def Renamed(self, original, new):
        """
        Emitted when the unique identifier of a contact on the server
          changes.

        Any channels associated with the contact's original handle will
          continue to be to that handle, and so are no longer useful (unless
          the contact renames back, or another contact connects with that
          unique ID). Clients may open a similar channel associated with the
          new handle to continue communicating with the contact.

        For example, if a GUI client associates text
          channels with chat windows, it should detach the old channel
          from the chat window, closing it, and associate a channel to the
          new handle with the same window.

        If the contact's old handle is in any of the member lists of
          a channel which has the groups interface, it will be removed from
          the channel and the new handle will be added. The resulting
          MembersChanged signal must be emitted after the Renamed
          signal; the reason should be RENAMED.
        

        The handles may be either general-purpose or channel-specific.
          If the original handle is general-purpose, the new handle must be
          general-purpose; if the original handle is channel-specific, the
          new handle must be channel-specific in the same channel.
        
      
        """
        pass
  