'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.10/tcllib-1.10/modules/term/ansi_cctrl.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "term::ansi::code::ctrl" n 0.1 term "Terminal control"
.BS
.SH NAME
term::ansi::code::ctrl \- ANSI control sequences
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBterm::ansi::code  ?0.1?\fR
.sp
package require \fBterm::ansi::code::ctrl  ?0.1?\fR
.sp
\fB::term::ansi::code::ctrl::names\fR
.sp
\fB::term::ansi::code::ctrl::import\fR ?\fIns\fR? ?\fIarg\fR...?
.sp
\fB::term::ansi::code::ctrl::eeol\fR
.sp
\fB::term::ansi::code::ctrl::esol\fR
.sp
\fB::term::ansi::code::ctrl::el\fR
.sp
\fB::term::ansi::code::ctrl::ed\fR
.sp
\fB::term::ansi::code::ctrl::eu\fR
.sp
\fB::term::ansi::code::ctrl::es\fR
.sp
\fB::term::ansi::code::ctrl::sd\fR
.sp
\fB::term::ansi::code::ctrl::su\fR
.sp
\fB::term::ansi::code::ctrl::ch\fR
.sp
\fB::term::ansi::code::ctrl::sc\fR
.sp
\fB::term::ansi::code::ctrl::rc\fR
.sp
\fB::term::ansi::code::ctrl::sca\fR
.sp
\fB::term::ansi::code::ctrl::rca\fR
.sp
\fB::term::ansi::code::ctrl::st\fR
.sp
\fB::term::ansi::code::ctrl::ct\fR
.sp
\fB::term::ansi::code::ctrl::cat\fR
.sp
\fB::term::ansi::code::ctrl::qdc\fR
.sp
\fB::term::ansi::code::ctrl::qds\fR
.sp
\fB::term::ansi::code::ctrl::qcp\fR
.sp
\fB::term::ansi::code::ctrl::rd\fR
.sp
\fB::term::ansi::code::ctrl::elw\fR
.sp
\fB::term::ansi::code::ctrl::dlw\fR
.sp
\fB::term::ansi::code::ctrl::eg\fR
.sp
\fB::term::ansi::code::ctrl::lg\fR
.sp
\fB::term::ansi::code::ctrl::scs0\fR \fItag\fR
.sp
\fB::term::ansi::code::ctrl::scs1\fR \fItag\fR
.sp
\fB::term::ansi::code::ctrl::sda\fR \fIarg\fR...
.sp
\fB::term::ansi::code::ctrl::sda_fgblack\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgred\fR
.sp
\fB::term::ansi::code::ctrl::sda_fggreen\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgyellow\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgblue\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgmagenta\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgcyan\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgwhite\fR
.sp
\fB::term::ansi::code::ctrl::sda_fgdefault\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgblack\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgred\fR
.sp
\fB::term::ansi::code::ctrl::sda_bggreen\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgyellow\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgblue\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgmagenta\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgcyan\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgwhite\fR
.sp
\fB::term::ansi::code::ctrl::sda_bgdefault\fR
.sp
\fB::term::ansi::code::ctrl::sda_bold\fR
.sp
\fB::term::ansi::code::ctrl::sda_dim\fR
.sp
\fB::term::ansi::code::ctrl::sda_italic\fR
.sp
\fB::term::ansi::code::ctrl::sda_underline\fR
.sp
\fB::term::ansi::code::ctrl::sda_blink\fR
.sp
\fB::term::ansi::code::ctrl::sda_revers\fR
.sp
\fB::term::ansi::code::ctrl::sda_hidden\fR
.sp
\fB::term::ansi::code::ctrl::sda_strike\fR
.sp
\fB::term::ansi::code::ctrl::sda_nobold\fR
.sp
\fB::term::ansi::code::ctrl::sda_noitalic\fR
.sp
\fB::term::ansi::code::ctrl::sda_nounderline\fR
.sp
\fB::term::ansi::code::ctrl::sda_noblink\fR
.sp
\fB::term::ansi::code::ctrl::sda_norevers\fR
.sp
\fB::term::ansi::code::ctrl::sda_nohidden\fR
.sp
\fB::term::ansi::code::ctrl::sda_nostrike\fR
.sp
\fB::term::ansi::code::ctrl::sda_reset\fR
.sp
\fB::term::ansi::send::fcp\fR \fIrow\fR \fIcol\fR
.sp
\fB::term::ansi::code::ctrl::cu\fR ?\fIn\fR?
.sp
\fB::term::ansi::code::ctrl::cd\fR ?\fIn\fR?
.sp
\fB::term::ansi::code::ctrl::cf\fR ?\fIn\fR?
.sp
\fB::term::ansi::code::ctrl::cb\fR ?\fIn\fR?
.sp
\fB::term::ansi::code::ctrl::ss\fR ?\fIs\fR \fIe\fR?
.sp
\fB::term::ansi::code::ctrl::skd\fR \fIcode\fR \fIstr\fR
.sp
\fB::term::ansi::code::ctrl::title\fR \fIstr\fR
.sp
\fB::term::ansi::code::ctrl::gron\fR
.sp
\fB::term::ansi::code::ctrl::groff\fR
.sp
\fB::term::ansi::code::ctrl::tlc\fR
.sp
\fB::term::ansi::code::ctrl::trc\fR
.sp
\fB::term::ansi::code::ctrl::brc\fR
.sp
\fB::term::ansi::code::ctrl::blc\fR
.sp
\fB::term::ansi::code::ctrl::ltj\fR
.sp
\fB::term::ansi::code::ctrl::ttj\fR
.sp
\fB::term::ansi::code::ctrl::rtj\fR
.sp
\fB::term::ansi::code::ctrl::btj\fR
.sp
\fB::term::ansi::code::ctrl::fwj\fR
.sp
\fB::term::ansi::code::ctrl::hl\fR
.sp
\fB::term::ansi::code::ctrl::vl\fR
.sp
\fB::term::ansi::code::ctrl::groptim\fR \fIstr\fR
.sp
\fB::term::ansi::code::ctrl::clear\fR
.sp
\fB::term::ansi::code::ctrl::init\fR
.sp
\fB::term::ansi::code::ctrl::showat\fR \fIrow\fR \fIcol\fR \fItext\fR
.sp
.BE
.SH DESCRIPTION
This package provides symbolic names for the ANSI control
sequences. For each sequence a single command is provided which
returns the sequence as its result. None of the commands of this
package write to a channel; that is handled by higher level packages,
like \fBterm::ansi::send\fR.
.SH API
.SS Introspection
.TP
\fB::term::ansi::code::ctrl::names\fR
This command is for introspection. It returns as its result a list
containing the names of all attribute commands.
.TP
\fB::term::ansi::code::ctrl::import\fR ?\fIns\fR? ?\fIarg\fR...?
This command imports some or all attribute commands into the namespace
\fIns\fR. This is by default the namespace \fIctrl\fR. Note that this
is relative namespace name, placing the imported command into a child
of the current namespace. By default all commands are imported, this
can howver be restricted by listing the names of the wanted commands
after the namespace argument.
.PP
.SS Sequences
.TP
\fB::term::ansi::code::ctrl::eeol\fR
Erase (to) End Of Line
.TP
\fB::term::ansi::code::ctrl::esol\fR
Erase (to) Start Of Line
.TP
\fB::term::ansi::code::ctrl::el\fR
Erase (current) Line
.TP
\fB::term::ansi::code::ctrl::ed\fR
Erase Down (to bottom)
.TP
\fB::term::ansi::code::ctrl::eu\fR
Erase Up (to top)
.TP
\fB::term::ansi::code::ctrl::es\fR
Erase Screen
.TP
\fB::term::ansi::code::ctrl::sd\fR
Scroll Down
.TP
\fB::term::ansi::code::ctrl::su\fR
Scroll Up
.TP
\fB::term::ansi::code::ctrl::ch\fR
Cursor Home
.TP
\fB::term::ansi::code::ctrl::sc\fR
Save Cursor
.TP
\fB::term::ansi::code::ctrl::rc\fR
Restore Cursor (Unsave)
.TP
\fB::term::ansi::code::ctrl::sca\fR
Save Cursor + Attributes
.TP
\fB::term::ansi::code::ctrl::rca\fR
Restore Cursor + Attributes
.TP
\fB::term::ansi::code::ctrl::st\fR
Set Tab (@ current position)
.TP
\fB::term::ansi::code::ctrl::ct\fR
Clear Tab (@ current position)
.TP
\fB::term::ansi::code::ctrl::cat\fR
Clear All Tabs
.TP
\fB::term::ansi::code::ctrl::qdc\fR
Query Device Code
.TP
\fB::term::ansi::code::ctrl::qds\fR
Query Device Status
.TP
\fB::term::ansi::code::ctrl::qcp\fR
Query Cursor Position
.TP
\fB::term::ansi::code::ctrl::rd\fR
Reset Device
.TP
\fB::term::ansi::code::ctrl::elw\fR
Enable Line Wrap
.TP
\fB::term::ansi::code::ctrl::dlw\fR
Disable Line Wrap
.TP
\fB::term::ansi::code::ctrl::eg\fR
Enter Graphics Mode
.TP
\fB::term::ansi::code::ctrl::lg\fR
Exit Graphics Mode
.TP
\fB::term::ansi::code::ctrl::scs0\fR \fItag\fR
Set default character set
.TP
\fB::term::ansi::code::ctrl::scs1\fR \fItag\fR
Set alternate character set
Select Character Set.
.sp
Choose which character set is used for either default (scs0) or
alternate font (scs1). This does not change whether default or
alternate font are used, only their definition.
.sp
The legal tags, and their meanings, are:
.RS
.TP
A
United Kingdom Set
.TP
B
ASCII Set
.TP
0
Special Graphics
.TP
1
Alternate Character ROM Standard Character Set
.TP
2
Alternate Character ROM Special Graphics
.RE
.TP
\fB::term::ansi::code::ctrl::sda\fR \fIarg\fR...
Set Display Attributes. The arguments are the code sequences for the possible
attributes, as provided by the package \fBterm::ansi::code::attr\fR. For
convenience this package also provides additional commands each setting a single
specific attribute.
.TP
\fB::term::ansi::code::ctrl::sda_fgblack\fR
Set text color to \fIBlack\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgred\fR
Set text color to \fIRed\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fggreen\fR
Set text color to \fIGreen\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgyellow\fR
Set text color to \fIYellow\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgblue\fR
Set text color to \fIBlue\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgmagenta\fR
Set text color to \fIMagenta\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgcyan\fR
Set text color to \fICyan\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgwhite\fR
Set text color to \fIWhite\fR.
.TP
\fB::term::ansi::code::ctrl::sda_fgdefault\fR
Set default text color (\fIBlack\fR).
.TP
\fB::term::ansi::code::ctrl::sda_bgblack\fR
Set background to \fIBlack\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgred\fR
Set background to \fIRed\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bggreen\fR
Set background to \fIGreen\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgyellow\fR
Set background to \fIYellow\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgblue\fR
Set background to \fIBlue\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgmagenta\fR
Set background to \fIMagenta\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgcyan\fR
Set background to \fICyan\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgwhite\fR
Set background to \fIWhite\fR.
.TP
\fB::term::ansi::code::ctrl::sda_bgdefault\fR
Set default background (Transparent).
.TP
\fB::term::ansi::code::ctrl::sda_bold\fR
Bold on.
.TP
\fB::term::ansi::code::ctrl::sda_dim\fR
Dim on.
.TP
\fB::term::ansi::code::ctrl::sda_italic\fR
Italics on.
.TP
\fB::term::ansi::code::ctrl::sda_underline\fR
Underscore on.
.TP
\fB::term::ansi::code::ctrl::sda_blink\fR
Blink on.
.TP
\fB::term::ansi::code::ctrl::sda_revers\fR
Reverse on.
.TP
\fB::term::ansi::code::ctrl::sda_hidden\fR
Hidden on.
.TP
\fB::term::ansi::code::ctrl::sda_strike\fR
Strike-through on.
.TP
\fB::term::ansi::code::ctrl::sda_nobold\fR
Bold off.
.TP
\fB::term::ansi::code::ctrl::sda_noitalic\fR
Italics off.
.TP
\fB::term::ansi::code::ctrl::sda_nounderline\fR
Underscore off.
.TP
\fB::term::ansi::code::ctrl::sda_noblink\fR
Blink off.
.TP
\fB::term::ansi::code::ctrl::sda_norevers\fR
Reverse off.
.TP
\fB::term::ansi::code::ctrl::sda_nohidden\fR
Hidden off.
.TP
\fB::term::ansi::code::ctrl::sda_nostrike\fR
Strike-through off.
.TP
\fB::term::ansi::code::ctrl::sda_reset\fR
Reset all attributes to their default values.
.TP
\fB::term::ansi::send::fcp\fR \fIrow\fR \fIcol\fR
Force Cursor Position (aka Go To).
.TP
\fB::term::ansi::code::ctrl::cu\fR ?\fIn\fR?
Cursor Up. \fIn\fR defaults to 1.
.TP
\fB::term::ansi::code::ctrl::cd\fR ?\fIn\fR?
Cursor Down. \fIn\fR defaults to 1.
.TP
\fB::term::ansi::code::ctrl::cf\fR ?\fIn\fR?
Cursor Forward. \fIn\fR defaults to 1.
.TP
\fB::term::ansi::code::ctrl::cb\fR ?\fIn\fR?
Cursor Backward. \fIn\fR defaults to 1.
.TP
\fB::term::ansi::code::ctrl::ss\fR ?\fIs\fR \fIe\fR?
Scroll Screen (entire display, or between rows start end, inclusive).
.TP
\fB::term::ansi::code::ctrl::skd\fR \fIcode\fR \fIstr\fR
Set Key Definition.
.TP
\fB::term::ansi::code::ctrl::title\fR \fIstr\fR
Set the terminal title.
.TP
\fB::term::ansi::code::ctrl::gron\fR
Switch to character/box graphics. I.e. switch to the alternate font.
.TP
\fB::term::ansi::code::ctrl::groff\fR
Switch to regular characters. I.e. switch to the default font.
.TP
\fB::term::ansi::code::ctrl::tlc\fR
Character graphics, Top Left Corner.
.TP
\fB::term::ansi::code::ctrl::trc\fR
Character graphics, Top Right Corner.
.TP
\fB::term::ansi::code::ctrl::brc\fR
Character graphics, Bottom Right Corner.
.TP
\fB::term::ansi::code::ctrl::blc\fR
Character graphics, Bottom Left Corner.
.TP
\fB::term::ansi::code::ctrl::ltj\fR
Character graphics, Left T Junction.
.TP
\fB::term::ansi::code::ctrl::ttj\fR
Character graphics, Top T Junction.
.TP
\fB::term::ansi::code::ctrl::rtj\fR
Character graphics, Right T Junction.
.TP
\fB::term::ansi::code::ctrl::btj\fR
Character graphics, Bottom T Junction.
.TP
\fB::term::ansi::code::ctrl::fwj\fR
Character graphics, Four-Way Junction.
.TP
\fB::term::ansi::code::ctrl::hl\fR
Character graphics, Horizontal Line.
.TP
\fB::term::ansi::code::ctrl::vl\fR
Character graphics, Vertical Line.
.TP
\fB::term::ansi::code::ctrl::groptim\fR \fIstr\fR
Optimize character graphics. The generator commands above create way to many
superfluous commands shifting into and out of the graphics mode. This command
removes all shifts which are not needed. To this end it also knows which
characters will look the same in both modes, to handle strings created outside
of this package.
.TP
\fB::term::ansi::code::ctrl::clear\fR
Clear screen. In essence a sequence of CursorHome + EraseDown.
.TP
\fB::term::ansi::code::ctrl::init\fR
Initialize default and alternate fonts to ASCII and box graphics.
.TP
\fB::term::ansi::code::ctrl::showat\fR \fIrow\fR \fIcol\fR \fItext\fR
Format the block of text for display at the specified location.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIterm\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
ansi, attribute control, color control, control, terminal
.SH COPYRIGHT
.nf
Copyright (c) 2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi