/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

final class OptFunctionNode {
    FunctionNode fnode;
    private OptLocalVariable[] optVars;
    private int directTargetIndex = -1;
    private boolean itsParameterNumberContext;
    boolean itsContainsCalls0;
    boolean itsContainsCalls1;

    OptFunctionNode(FunctionNode functionNode) {
        this.fnode = functionNode;
        int n = functionNode.getParamAndVarCount();
        int n2 = functionNode.getParamCount();
        this.optVars = new OptLocalVariable[n];
        for (int i = 0; i != n; ++i) {
            String string = functionNode.getParamOrVarName(i);
            this.optVars[i] = new OptLocalVariable(string, i < n2);
        }
        functionNode.setCompilerData(this);
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFnNode, int n) {
        FunctionNode functionNode = scriptOrFnNode.getFunctionNode(n);
        return (OptFunctionNode)functionNode.getCompilerData();
    }

    static OptFunctionNode get(ScriptOrFnNode scriptOrFnNode) {
        return (OptFunctionNode)scriptOrFnNode.getCompilerData();
    }

    boolean isTargetOfDirectCall() {
        return this.directTargetIndex >= 0;
    }

    int getDirectTargetIndex() {
        return this.directTargetIndex;
    }

    void setDirectTargetIndex(int n) {
        if (n < 0 || this.directTargetIndex >= 0) {
            Kit.codeBug();
        }
        this.directTargetIndex = n;
    }

    void setParameterNumberContext(boolean bl) {
        this.itsParameterNumberContext = bl;
    }

    boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    int getVarCount() {
        return this.optVars.length;
    }

    OptLocalVariable getVar(int n) {
        return this.optVars[n];
    }

    OptLocalVariable getVar(String string) {
        int n = this.fnode.getParamOrVarIndex(string);
        if (n < 0) {
            return null;
        }
        return this.optVars[n];
    }

    void establishVarsIndices() {
        int n = this.optVars.length;
        for (int i = 0; i != n; ++i) {
            this.optVars[i].setIndex(i);
        }
    }

    OptLocalVariable[] getVarsArray() {
        return this.optVars;
    }
}

