/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public abstract class SecurityController {
    public abstract GeneratedClassLoader createClassLoader(ClassLoader var1, Object var2);

    public static GeneratedClassLoader createLoader(ClassLoader classLoader, Object object) {
        GeneratedClassLoader generatedClassLoader;
        SecurityController securityController;
        Context context = Context.getContext();
        if (classLoader == null) {
            classLoader = context.getApplicationClassLoader();
        }
        if ((securityController = context.getSecurityController()) == null) {
            generatedClassLoader = context.createClassLoader(classLoader);
        } else {
            Object object2 = securityController.getDynamicSecurityDomain(object);
            generatedClassLoader = securityController.createClassLoader(classLoader, object2);
        }
        return generatedClassLoader;
    }

    public abstract Object getDynamicSecurityDomain(Object var1);

    public Object callWithDomain(Object object, Context context, final Callable callable, Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) throws JavaScriptException {
        return this.execWithDomain(context, scriptable, new Script(){

            public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        }, object);
    }

    public Object execWithDomain(Context context, Scriptable scriptable, Script script, Object object) throws JavaScriptException {
        throw new IllegalStateException("callWithDomain should be overridden");
    }
}

