/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

class NativeScript
extends NativeFunction
implements Script {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;
    private int prototypeIdShift = -1;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeScript nativeScript = new NativeScript(null);
        nativeScript.prototypeIdShift = nativeScript.getMaxId();
        nativeScript.addAsPrototype(nativeScript.prototypeIdShift + 4, context, scriptable, bl);
    }

    private NativeScript(Script script) {
        this.script = script;
    }

    public String getClassName() {
        return "Script";
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.script != null) {
            return this.script.exec(context, scriptable);
        }
        return Undefined.instance;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    public int getLength() {
        return 0;
    }

    public int getArity() {
        return 0;
    }

    public String getEncodedSource() {
        if (this.script instanceof NativeFunction) {
            return ((NativeFunction)((Object)this.script)).getEncodedSource();
        }
        return super.getEncodedSource();
    }

    public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(context, scriptable);
    }

    public int methodArity(int n) {
        if (0 <= this.prototypeIdShift) {
            switch (n - this.prototypeIdShift) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (0 <= this.prototypeIdShift) {
            switch (n - this.prototypeIdShift) {
                case 1: {
                    String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
                    Script script = NativeScript.compile(context, string);
                    NativeScript nativeScript = new NativeScript(script);
                    nativeScript.setParentScope(scriptable);
                    nativeScript.setPrototype(NativeScript.getClassPrototype(scriptable, "Script"));
                    return nativeScript;
                }
                case 2: {
                    NativeScript nativeScript = NativeScript.realThis(scriptable2, idFunction);
                    Script script = nativeScript.script;
                    if (script == null) {
                        script = nativeScript;
                    }
                    return context.decompileScript(script, NativeScript.getTopLevelScope(scriptable), 0);
                }
                case 4: {
                    throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
                }
                case 3: {
                    NativeScript nativeScript = NativeScript.realThis(scriptable2, idFunction);
                    String string = ScriptRuntime.toString(objectArray, 0);
                    nativeScript.script = NativeScript.compile(context, string);
                    return nativeScript;
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static NativeScript realThis(Scriptable scriptable, IdFunction idFunction) {
        if (!(scriptable instanceof NativeScript)) {
            throw NativeScript.incompatibleCallError(idFunction);
        }
        return (NativeScript)scriptable;
    }

    private static Script compile(Context context, String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        if (string2 == null) {
            string2 = "<Script object>";
            nArray[0] = 1;
        }
        return context.compileString(string, string2, nArray[0], null);
    }

    protected String getIdName(int n) {
        if (0 <= this.prototypeIdShift) {
            switch (n - this.prototypeIdShift) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 4: {
                    return "exec";
                }
                case 3: {
                    return "compile";
                }
            }
        }
        return super.getIdName(n);
    }

    protected int mapNameToId(String string) {
        int n;
        if (0 <= this.prototypeIdShift && (n = NativeScript.toPrototypeId(string)) != 0) {
            return this.prototypeIdShift + n;
        }
        return super.mapNameToId(string);
    }

    private static int toPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "exec";
                n = 4;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 3;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

