/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private boolean prototypeFlag;

    NativeError() {
    }

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeError nativeError = new NativeError();
        nativeError.prototypeFlag = true;
        ScriptableObject.putProperty((Scriptable)nativeError, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)new Integer(0));
        nativeError.addAsPrototype(3, context, scriptable, bl);
    }

    static NativeError make(Context context, Scriptable scriptable, IdFunction idFunction, Object[] objectArray) {
        Scriptable scriptable2 = (Scriptable)idFunction.get("prototype", (Scriptable)idFunction);
        NativeError nativeError = new NativeError();
        nativeError.setPrototype(scriptable2);
        nativeError.setParentScope(scriptable);
        if (objectArray.length >= 1) {
            ScriptableObject.putProperty((Scriptable)nativeError, "message", (Object)ScriptRuntime.toString(objectArray[0]));
            if (objectArray.length >= 2) {
                ScriptableObject.putProperty((Scriptable)nativeError, "fileName", objectArray[1]);
                if (objectArray.length >= 3) {
                    int n = ScriptRuntime.toInt32(objectArray[2]);
                    ScriptableObject.putProperty((Scriptable)nativeError, "lineNumber", (Object)new Integer(n));
                }
            }
        }
        return nativeError;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return 1;
            }
            if (n == 2) {
                return 0;
            }
            if (n == 3) {
                return 0;
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (n == 1) {
                return NativeError.make(context, scriptable, idFunction, objectArray);
            }
            if (n == 2) {
                return NativeError.js_toString(scriptable2);
            }
            if (n == 3) {
                return NativeError.js_toSource(context, scriptable, scriptable2);
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private static String js_toString(Scriptable scriptable) {
        return NativeError.getString(scriptable, "name") + ": " + NativeError.getString(scriptable, "message");
    }

    private static String js_toSource(Context context, Scriptable scriptable, Scriptable scriptable2) throws JavaScriptException {
        Object object = ScriptableObject.getProperty(scriptable2, "name");
        Object object2 = ScriptableObject.getProperty(scriptable2, "message");
        Object object3 = ScriptableObject.getProperty(scriptable2, "fileName");
        Object object4 = ScriptableObject.getProperty(scriptable2, "lineNumber");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(new ");
        if (object == NOT_FOUND) {
            object = Undefined.instance;
        }
        stringBuffer.append(ScriptRuntime.toString(object));
        stringBuffer.append("(");
        if (object2 != NOT_FOUND || object3 != NOT_FOUND || object4 != NOT_FOUND) {
            if (object2 == NOT_FOUND) {
                object2 = "";
            }
            stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object2));
            if (object3 != NOT_FOUND || object4 != NOT_FOUND) {
                int n;
                stringBuffer.append(", ");
                if (object3 == NOT_FOUND) {
                    object3 = "";
                }
                stringBuffer.append(ScriptRuntime.uneval(context, scriptable, object3));
                if (object4 != NOT_FOUND && (n = ScriptRuntime.toInt32(object4)) != 0) {
                    stringBuffer.append(", ");
                    stringBuffer.append(ScriptRuntime.toString(n));
                }
            }
        }
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    public String getClassName() {
        return "Error";
    }

    public String toString() {
        return NativeError.js_toString(this);
    }

    private static String getString(Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == NOT_FOUND) {
            return "";
        }
        return ScriptRuntime.toString(object);
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            if (n == 1) {
                return "constructor";
            }
            if (n == 2) {
                return "toString";
            }
            if (n == 3) {
                return "toSource";
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 8) {
            char c = string.charAt(3);
            if (c == 'o') {
                string2 = "toSource";
                n = 3;
            } else if (c == 't') {
                string2 = "toString";
                n = 2;
            }
        } else if (n2 == 11) {
            string2 = "constructor";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

