/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.classfile.ClassFileField;
import org.mozilla.classfile.ClassFileMethod;
import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.ExceptionTableEntry;
import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.ObjArray;

public class ClassFileWriter {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    private static final int LineNumberTableSize = 16;
    private static final int ExceptionTableSize = 4;
    private static final long FileHeaderConstant = -3819410108756852691L;
    private static final boolean DEBUGSTACK = false;
    private static final boolean DEBUGLABELS = false;
    private static final boolean DEBUGCODE = false;
    private static final int CodeBufferSize = 128;
    private String generatedClassName;
    private ExceptionTableEntry[] itsExceptionTable;
    private int itsExceptionTableTop;
    private int[] itsLineNumberTable;
    private int itsLineNumberTableTop;
    private byte[] itsCodeBuffer = new byte[256];
    private int itsCodeBufferTop;
    private ConstantPool itsConstantPool;
    private short itsSourceFileAttributeIndex;
    private ClassFileMethod itsCurrentMethod;
    private short itsStackTop;
    private short itsMaxStack;
    private short itsMaxLocals;
    private ObjArray itsMethods = new ObjArray();
    private ObjArray itsFields = new ObjArray();
    private ObjArray itsInterfaces = new ObjArray();
    private short itsFlags;
    private short itsThisClassIndex;
    private short itsSuperClassIndex;
    private short itsSourceFileNameIndex;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private char[] tmpCharBuffer = new char[64];

    public ClassFileWriter(String string, String string2, String string3) {
        this.generatedClassName = string;
        this.itsConstantPool = new ConstantPool(this);
        this.itsThisClassIndex = this.itsConstantPool.addClass(string);
        this.itsSuperClassIndex = this.itsConstantPool.addClass(string2);
        if (string3 != null) {
            this.itsSourceFileNameIndex = this.itsConstantPool.addUtf8(string3);
        }
        this.itsFlags = 1;
    }

    public final String getClassName() {
        return this.generatedClassName;
    }

    public void addInterface(String string) {
        short s = this.itsConstantPool.addClass(string);
        this.itsInterfaces.add(new Short(s));
    }

    public void setFlags(short s) {
        this.itsFlags = s;
    }

    static String getSlashedForm(String string) {
        return string.replace('.', '/');
    }

    public static String classNameToSignature(String string) {
        int n = string.length();
        int n2 = 1 + n;
        char[] cArray = new char[n2 + 1];
        cArray[0] = 76;
        cArray[n2] = 59;
        string.getChars(0, n, cArray, 1);
        for (int i = 1; i != n2; ++i) {
            if (cArray[i] != '.') continue;
            cArray[i] = 47;
        }
        return new String(cArray, 0, n2 + 1);
    }

    public void addField(String string, String string2, short s) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        this.itsFields.add(new ClassFileField(s2, s3, s));
    }

    public void addField(String string, String string2, short s, int n) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        ClassFileField classFileField = new ClassFileField(s2, s3, s);
        classFileField.setAttributes(this.itsConstantPool.addUtf8("ConstantValue"), (short)0, (short)0, this.itsConstantPool.addConstant(n));
        this.itsFields.add(classFileField);
    }

    public void addField(String string, String string2, short s, long l) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        ClassFileField classFileField = new ClassFileField(s2, s3, s);
        classFileField.setAttributes(this.itsConstantPool.addUtf8("ConstantValue"), (short)0, (short)2, this.itsConstantPool.addConstant(l));
        this.itsFields.add(classFileField);
    }

    public void addField(String string, String string2, short s, double d) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        ClassFileField classFileField = new ClassFileField(s2, s3, s);
        classFileField.setAttributes(this.itsConstantPool.addUtf8("ConstantValue"), (short)0, (short)2, this.itsConstantPool.addConstant(d));
        this.itsFields.add(classFileField);
    }

    public void startMethod(String string, String string2, short s) {
        short s2 = this.itsConstantPool.addUtf8(string);
        short s3 = this.itsConstantPool.addUtf8(string2);
        this.itsCurrentMethod = new ClassFileMethod(s2, s3, s);
        this.itsMethods.add(this.itsCurrentMethod);
    }

    public void stopMethod(short s, JavaVariable[] javaVariableArray) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.itsCurrentMethod == null) {
            throw new IllegalStateException("No method to stop");
        }
        this.fixLabelGotos();
        this.itsMaxLocals = s;
        int n5 = 0;
        if (this.itsLineNumberTable != null) {
            n5 = 8 + this.itsLineNumberTableTop * 4;
        }
        int n6 = 0;
        if (javaVariableArray != null) {
            n6 = 8 + javaVariableArray.length * 10;
        }
        int n7 = 14 + this.itsCodeBufferTop + 2 + this.itsExceptionTableTop * 8 + 2 + n5 + n6;
        byte[] byArray = new byte[n7];
        int n8 = 0;
        short s2 = this.itsConstantPool.addUtf8("Code");
        n8 = ClassFileWriter.putInt16(s2, byArray, n8);
        n8 = ClassFileWriter.putInt32(n7 -= 6, byArray, n8);
        n8 = ClassFileWriter.putInt16(this.itsMaxStack, byArray, n8);
        n8 = ClassFileWriter.putInt16(this.itsMaxLocals, byArray, n8);
        n8 = ClassFileWriter.putInt32(this.itsCodeBufferTop, byArray, n8);
        System.arraycopy(this.itsCodeBuffer, 0, byArray, n8, this.itsCodeBufferTop);
        n8 += this.itsCodeBufferTop;
        if (this.itsExceptionTableTop > 0) {
            n8 = ClassFileWriter.putInt16(this.itsExceptionTableTop, byArray, n8);
            for (n4 = 0; n4 < this.itsExceptionTableTop; ++n4) {
                ExceptionTableEntry exceptionTableEntry = this.itsExceptionTable[n4];
                n3 = this.getLabelPC(exceptionTableEntry.itsStartLabel);
                n2 = this.getLabelPC(exceptionTableEntry.itsEndLabel);
                n = this.getLabelPC(exceptionTableEntry.itsHandlerLabel);
                short s3 = exceptionTableEntry.itsCatchType;
                if (n3 == -1) {
                    throw new IllegalStateException("start label not defined");
                }
                if (n2 == -1) {
                    throw new IllegalStateException("end label not defined");
                }
                if (n == -1) {
                    throw new IllegalStateException("handler label not defined");
                }
                n8 = ClassFileWriter.putInt16(n3, byArray, n8);
                n8 = ClassFileWriter.putInt16(n2, byArray, n8);
                n8 = ClassFileWriter.putInt16(n, byArray, n8);
                n8 = ClassFileWriter.putInt16(s3, byArray, n8);
            }
        } else {
            n8 = ClassFileWriter.putInt16(0, byArray, n8);
        }
        n4 = 0;
        if (this.itsLineNumberTable != null) {
            ++n4;
        }
        if (javaVariableArray != null) {
            ++n4;
        }
        n8 = ClassFileWriter.putInt16(n4, byArray, n8);
        if (this.itsLineNumberTable != null) {
            short s4 = this.itsConstantPool.addUtf8("LineNumberTable");
            n8 = ClassFileWriter.putInt16(s4, byArray, n8);
            n3 = 2 + this.itsLineNumberTableTop * 4;
            n8 = ClassFileWriter.putInt32(n3, byArray, n8);
            n8 = ClassFileWriter.putInt16(this.itsLineNumberTableTop, byArray, n8);
            for (n2 = 0; n2 < this.itsLineNumberTableTop; ++n2) {
                n8 = ClassFileWriter.putInt32(this.itsLineNumberTable[n2], byArray, n8);
            }
        }
        if (javaVariableArray != null) {
            short s5 = this.itsConstantPool.addUtf8("LocalVariableTable");
            n8 = ClassFileWriter.putInt16(s5, byArray, n8);
            n3 = javaVariableArray.length;
            n2 = 2 + n3 * 10;
            n8 = ClassFileWriter.putInt32(n2, byArray, n8);
            n8 = ClassFileWriter.putInt16(n3, byArray, n8);
            for (n = 0; n < n3; ++n) {
                JavaVariable javaVariable = javaVariableArray[n];
                int n9 = javaVariable.getStartPC();
                n8 = ClassFileWriter.putInt16(n9, byArray, n8);
                int n10 = this.itsCodeBufferTop - n9;
                n8 = ClassFileWriter.putInt16(n10, byArray, n8);
                short s6 = this.itsConstantPool.addUtf8(javaVariable.getName());
                n8 = ClassFileWriter.putInt16(s6, byArray, n8);
                String string = javaVariable.getTypeDescriptor();
                short s7 = this.itsConstantPool.addUtf8(string);
                n8 = ClassFileWriter.putInt16(s7, byArray, n8);
                short s8 = javaVariable.getJRegister();
                n8 = ClassFileWriter.putInt16(s8, byArray, n8);
            }
        }
        this.itsCurrentMethod.setCodeAttribute(byArray);
        this.itsExceptionTable = null;
        this.itsExceptionTableTop = 0;
        this.itsLineNumberTableTop = 0;
        this.itsCodeBufferTop = 0;
        this.itsCurrentMethod = null;
        this.itsMaxStack = 0;
        this.itsStackTop = 0;
        this.itsLabelTableTop = 0;
        this.itsFixupTableTop = 0;
    }

    public void add(byte by) {
        if (ClassFileWriter.opcodeCount(by) != 0) {
            throw new IllegalArgumentException("Unexpected operands");
        }
        int n = this.itsStackTop + ClassFileWriter.stackChange(by);
        if (n < 0 || Short.MAX_VALUE < n) {
            ClassFileWriter.badStack(n);
        }
        this.addToCodeBuffer(by);
        this.itsStackTop = (short)n;
        if (n > this.itsMaxStack) {
            this.itsMaxStack = (short)n;
        }
    }

    public void add(byte by, int n) {
        int n2 = this.itsStackTop + ClassFileWriter.stackChange(by);
        if (n2 < 0 || Short.MAX_VALUE < n2) {
            ClassFileWriter.badStack(n2);
        }
        switch (by) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE && (n < 0 || n > 65535)) {
                    throw new IllegalArgumentException("Bad label for branch");
                }
                int n3 = this.itsCodeBufferTop;
                this.addToCodeBuffer(by);
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                    this.addToCodeInt16(n);
                    break;
                }
                int n4 = this.getLabelPC(n);
                if (n4 != -1) {
                    int n5 = n4 - n3;
                    this.addToCodeInt16(n5);
                    break;
                }
                this.addLabelFixup(n, n3 + 1);
                this.addToCodeInt16(0);
                break;
            }
            case 16: {
                if ((byte)n != n) {
                    throw new IllegalArgumentException("out of range byte");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 17: {
                if ((short)n != n) {
                    throw new IllegalArgumentException("out of range short");
                }
                this.addToCodeBuffer(by);
                this.addToCodeInt16(n);
                break;
            }
            case -68: {
                if (0 > n || n >= 256) {
                    throw new IllegalArgumentException("out of range index");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -76: 
            case -75: {
                if (0 > n || n >= 65536) {
                    throw new IllegalArgumentException("out of range field");
                }
                this.addToCodeBuffer(by);
                this.addToCodeInt16(n);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (0 > n || n >= 65536) {
                    throw new IllegalArgumentException("out of range index");
                }
                if (n >= 256 || by == 19 || by == 20) {
                    if (by == 18) {
                        this.addToCodeBuffer((byte)19);
                    } else {
                        this.addToCodeBuffer(by);
                    }
                    this.addToCodeInt16(n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (0 > n || n >= 65536) {
                    throw new IllegalArgumentException("out of range variable");
                }
                if (n >= 256) {
                    this.addToCodeBuffer((byte)-60);
                    this.addToCodeBuffer(by);
                    this.addToCodeInt16(n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected opcode for 1 operand");
            }
        }
        this.itsStackTop = (short)n2;
        if (n2 > this.itsMaxStack) {
            this.itsMaxStack = (short)n2;
        }
    }

    public void addLoadConstant(int n) {
        this.add((byte)18, this.itsConstantPool.addConstant(n));
    }

    public void addLoadConstant(long l) {
        this.add((byte)20, this.itsConstantPool.addConstant(l));
    }

    public void addLoadConstant(float f) {
        this.add((byte)18, this.itsConstantPool.addConstant(f));
    }

    public void addLoadConstant(double d) {
        this.add((byte)20, this.itsConstantPool.addConstant(d));
    }

    public void addLoadConstant(String string) {
        this.add((byte)18, this.itsConstantPool.addConstant(string));
    }

    public void add(byte by, int n, int n2) {
        int n3 = this.itsStackTop + ClassFileWriter.stackChange(by);
        if (n3 < 0 || Short.MAX_VALUE < n3) {
            ClassFileWriter.badStack(n3);
        }
        if (by == -124) {
            if (0 > n || n >= 65536) {
                throw new IllegalArgumentException("out of range variable");
            }
            if (0 > n2 || n2 >= 65536) {
                throw new IllegalArgumentException("out of range increment");
            }
            if (n > 255 || n2 < -128 || n2 > 127) {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeInt16(n);
                this.addToCodeInt16(n2);
            } else {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)n2);
            }
        } else if (by == -59) {
            if (0 > n || n >= 65536) {
                throw new IllegalArgumentException("out of range index");
            }
            if (0 > n2 || n2 >= 256) {
                throw new IllegalArgumentException("out of range dimensions");
            }
            this.addToCodeBuffer((byte)-59);
            this.addToCodeInt16(n);
            this.addToCodeBuffer((byte)n2);
        } else {
            throw new IllegalArgumentException("Unexpected opcode for 2 operands");
        }
        this.itsStackTop = (short)n3;
        if (n3 > this.itsMaxStack) {
            this.itsMaxStack = (short)n3;
        }
    }

    public void add(byte by, String string) {
        int n = this.itsStackTop + ClassFileWriter.stackChange(by);
        if (n < 0 || Short.MAX_VALUE < n) {
            ClassFileWriter.badStack(n);
        }
        switch (by) {
            case -69: 
            case -67: 
            case -64: 
            case -63: {
                short s = this.itsConstantPool.addClass(string);
                this.addToCodeBuffer(by);
                this.addToCodeInt16(s);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad opcode for class reference");
            }
        }
        this.itsStackTop = (short)n;
        if (n > this.itsMaxStack) {
            this.itsMaxStack = (short)n;
        }
    }

    public void add(byte by, String string, String string2, String string3) {
        int n = this.itsStackTop + ClassFileWriter.stackChange(by);
        char c = string3.charAt(0);
        int n2 = c == 'J' || c == 'D' ? 2 : 1;
        switch (by) {
            case -78: 
            case -76: {
                n += n2;
                break;
            }
            case -77: 
            case -75: {
                n -= n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad opcode for field reference");
            }
        }
        if (n < 0 || Short.MAX_VALUE < n) {
            ClassFileWriter.badStack(n);
        }
        short s = this.itsConstantPool.addFieldRef(string, string2, string3);
        this.addToCodeBuffer(by);
        this.addToCodeInt16(s);
        this.itsStackTop = (short)n;
        if (n > this.itsMaxStack) {
            this.itsMaxStack = (short)n;
        }
    }

    public void add(byte by, String string, String string2, String string3, String string4) {
        this.addInvoke(by, string, string2, string3 + string4);
    }

    public void addInvoke(byte by, String string, String string2, String string3) {
        int n = ClassFileWriter.sizeOfParameters(string3);
        int n2 = n >>> 16;
        short s = (short)n;
        int n3 = this.itsStackTop + s;
        if ((n3 += ClassFileWriter.stackChange(by)) < 0 || Short.MAX_VALUE < n3) {
            ClassFileWriter.badStack(n3);
        }
        switch (by) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.addToCodeBuffer(by);
                if (by == -71) {
                    short s2 = this.itsConstantPool.addInterfaceMethodRef(string, string2, string3);
                    this.addToCodeInt16(s2);
                    this.addToCodeBuffer((byte)(n2 + 1));
                    this.addToCodeBuffer((byte)0);
                    break;
                }
                short s3 = this.itsConstantPool.addMethodRef(string, string2, string3);
                this.addToCodeInt16(s3);
                break;
            }
            default: {
                throw new IllegalArgumentException("bad opcode for method reference");
            }
        }
        this.itsStackTop = (short)n3;
        if (n3 > this.itsMaxStack) {
            this.itsMaxStack = (short)n3;
        }
    }

    public void addPush(int n) {
        if ((byte)n == n) {
            if (n == -1) {
                this.add((byte)2);
            } else if (0 <= n && n <= 5) {
                this.add((byte)(3 + n));
            } else {
                this.add((byte)16, (byte)n);
            }
        } else if ((short)n == n) {
            this.add((byte)17, (short)n);
        } else {
            this.addLoadConstant(n);
        }
    }

    public void addPush(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.addPush(n);
            this.add((byte)-123);
        } else {
            this.addLoadConstant(l);
        }
    }

    public void addPush(double d) {
        if (d == 0.0) {
            this.add((byte)14);
            if (1.0 / d < 0.0) {
                this.add((byte)119);
            }
        } else if (d == 1.0 || d == -1.0) {
            this.add((byte)15);
            if (d < 0.0) {
                this.add((byte)119);
            }
        } else {
            this.addLoadConstant(d);
        }
    }

    public void addPush(String string) {
        int n = string.length();
        int n2 = this.itsConstantPool.getUtfEncodingLimit(string, 0, n);
        if (n2 == n) {
            this.addLoadConstant(string);
            return;
        }
        this.add((byte)-69, "java/lang/StringBuffer");
        this.add((byte)89);
        this.addPush(n);
        this.addInvoke((byte)-73, "java/lang/StringBuffer", "<init>", "(I)V");
        int n3 = 0;
        while (true) {
            this.add((byte)89);
            String string2 = string.substring(n3, n2);
            this.addLoadConstant(string2);
            this.addInvoke((byte)-74, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            this.add((byte)87);
            if (n2 == n) break;
            n3 = n2;
            n2 = this.itsConstantPool.getUtfEncodingLimit(string, n2, n);
        }
        this.addInvoke((byte)-74, "java/lang/StringBuffer", "toString", "()Ljava/lang/String;");
    }

    public boolean isUnderStringSizeLimit(String string) {
        return this.itsConstantPool.isUnderUtfEncodingLimit(string);
    }

    public void addIStore(int n) {
        this.xop((byte)59, (byte)54, n);
    }

    public void addLStore(int n) {
        this.xop((byte)63, (byte)55, n);
    }

    public void addFStore(int n) {
        this.xop((byte)67, (byte)56, n);
    }

    public void addDStore(int n) {
        this.xop((byte)71, (byte)57, n);
    }

    public void addAStore(int n) {
        this.xop((byte)75, (byte)58, n);
    }

    public void addILoad(int n) {
        this.xop((byte)26, (byte)21, n);
    }

    public void addLLoad(int n) {
        this.xop((byte)30, (byte)22, n);
    }

    public void addFLoad(int n) {
        this.xop((byte)34, (byte)23, n);
    }

    public void addDLoad(int n) {
        this.xop((byte)38, (byte)24, n);
    }

    public void addALoad(int n) {
        this.xop((byte)42, (byte)25, n);
    }

    public void addLoadThis() {
        this.add((byte)42);
    }

    private void xop(byte by, byte by2, int n) {
        switch (n) {
            case 0: {
                this.add(by);
                break;
            }
            case 1: {
                this.add((byte)(by + 1));
                break;
            }
            case 2: {
                this.add((byte)(by + 2));
                break;
            }
            case 3: {
                this.add((byte)(by + 3));
                break;
            }
            default: {
                this.add(by2, n);
            }
        }
    }

    public int addTableSwitch(int n, int n2) {
        int n3;
        int n4;
        if (n > n2) {
            throw new IllegalArgumentException("Bad bounds: " + n + ' ' + n2);
        }
        int n5 = this.itsStackTop + ClassFileWriter.stackChange(-86);
        if (n5 < 0 || Short.MAX_VALUE < n5) {
            ClassFileWriter.badStack(n5);
        }
        int n6 = n2 - n + 1;
        int n7 = n4 = this.addReservedCodeSpace(1 + n3 + 4 * (3 + n6));
        this.itsCodeBuffer[n4++] = -86;
        for (n3 = 3 & (this.itsCodeBufferTop ^ 0xFFFFFFFF); n3 != 0; --n3) {
            this.itsCodeBuffer[n4++] = 0;
        }
        n4 += 4;
        n4 = ClassFileWriter.putInt32(n, this.itsCodeBuffer, n4);
        ClassFileWriter.putInt32(n2, this.itsCodeBuffer, n4);
        this.itsStackTop = (short)n5;
        if (n5 > this.itsMaxStack) {
            this.itsMaxStack = (short)n5;
        }
        return n7;
    }

    public final void markTableSwitchDefault(int n) {
        this.setTableSwitchJump(n, -1, this.itsCodeBufferTop);
    }

    public final void markTableSwitchCase(int n, int n2) {
        this.setTableSwitchJump(n, n2, this.itsCodeBufferTop);
    }

    public final void markTableSwitchCase(int n, int n2, int n3) {
        if (0 > n3 || n3 > this.itsMaxStack) {
            throw new IllegalArgumentException("Bad stack index: " + n3);
        }
        this.itsStackTop = (short)n3;
        this.setTableSwitchJump(n, n2, this.itsCodeBufferTop);
    }

    public void setTableSwitchJump(int n, int n2, int n3) {
        if (0 > n3 || n3 > this.itsCodeBufferTop) {
            throw new IllegalArgumentException("Bad jump target: " + n3);
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("Bad case index: " + n2);
        }
        int n4 = 3 & ~n;
        int n5 = n2 < 0 ? n + 1 + n4 : n + 1 + n4 + 4 * (3 + n2);
        if (0 > n || n > this.itsCodeBufferTop - 16 - n4 - 1) {
            throw new IllegalArgumentException(n + " is outside a possible range of tableswitch" + " in already generated code");
        }
        if (this.itsCodeBuffer[n] != -86) {
            throw new IllegalArgumentException(n + " is not offset of tableswitch statement");
        }
        if (0 > n5 || n5 + 4 > this.itsCodeBufferTop) {
            throw new IllegalArgumentException("Too big case index: " + n2);
        }
        ClassFileWriter.putInt32(n3 - n, this.itsCodeBuffer, n5);
    }

    public int acquireLabel() {
        int n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        return n | Integer.MIN_VALUE;
    }

    public void markLabel(int n) {
        if (n >= 0) {
            throw new IllegalArgumentException("Bad label, no biscuit");
        }
        if ((n &= Integer.MAX_VALUE) > this.itsLabelTableTop) {
            throw new IllegalArgumentException("Bad label");
        }
        if (this.itsLabelTable[n] != -1) {
            throw new IllegalStateException("Can only mark label once");
        }
        this.itsLabelTable[n] = this.itsCodeBufferTop;
    }

    public void markLabel(int n, short s) {
        this.markLabel(n);
        this.itsStackTop = s;
    }

    public void markHandler(int n) {
        this.itsStackTop = 1;
        this.markLabel(n);
    }

    private int getLabelPC(int n) {
        if (n >= 0) {
            throw new IllegalArgumentException("Bad label, no biscuit");
        }
        if ((n &= Integer.MAX_VALUE) >= this.itsLabelTableTop) {
            throw new IllegalArgumentException("Bad label");
        }
        return this.itsLabelTable[n];
    }

    private void addLabelFixup(int n, int n2) {
        if (n >= 0) {
            throw new IllegalArgumentException("Bad label, no biscuit");
        }
        if ((n &= Integer.MAX_VALUE) >= this.itsLabelTableTop) {
            throw new IllegalArgumentException("Bad label");
        }
        int n3 = this.itsFixupTableTop;
        if (this.itsFixupTable == null || n3 == this.itsFixupTable.length) {
            if (this.itsFixupTable == null) {
                this.itsFixupTable = new long[40];
            } else {
                long[] lArray = new long[this.itsFixupTable.length * 2];
                System.arraycopy(this.itsFixupTable, 0, lArray, 0, n3);
                this.itsFixupTable = lArray;
            }
        }
        this.itsFixupTableTop = n3 + 1;
        this.itsFixupTable[n3] = (long)n << 32 | (long)n2;
    }

    private void fixLabelGotos() {
        byte[] byArray = this.itsCodeBuffer;
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long l = this.itsFixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.itsLabelTable[n];
            if (n3 == -1) {
                throw new RuntimeException();
            }
            int n4 = n3 - (n2 - 1);
            if ((short)n4 != n4) {
                throw new RuntimeException("Program too complex: too big jump offset");
            }
            byArray[n2] = (byte)(n4 >> 8);
            byArray[n2 + 1] = (byte)n4;
        }
        this.itsFixupTableTop = 0;
    }

    public int getCurrentCodeOffset() {
        return this.itsCodeBufferTop;
    }

    public short getStackTop() {
        return this.itsStackTop;
    }

    public void adjustStackTop(int n) {
        int n2 = this.itsStackTop + n;
        if (n2 < 0 || Short.MAX_VALUE < n2) {
            ClassFileWriter.badStack(n2);
        }
        this.itsStackTop = (short)n2;
        if (n2 > this.itsMaxStack) {
            this.itsMaxStack = (short)n2;
        }
    }

    private void addToCodeBuffer(byte by) {
        int n = this.addReservedCodeSpace(1);
        this.itsCodeBuffer[n] = by;
    }

    private void addToCodeInt16(int n) {
        int n2 = this.addReservedCodeSpace(2);
        ClassFileWriter.putInt16(n, this.itsCodeBuffer, n2);
    }

    private int addReservedCodeSpace(int n) {
        if (this.itsCurrentMethod == null) {
            throw new IllegalArgumentException("No method to add to");
        }
        int n2 = this.itsCodeBufferTop;
        int n3 = n2 + n;
        if (n3 > this.itsCodeBuffer.length) {
            int n4 = this.itsCodeBuffer.length * 2;
            if (n3 > n4) {
                n4 = n3;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.itsCodeBuffer, 0, byArray, 0, n2);
            this.itsCodeBuffer = byArray;
        }
        this.itsCodeBufferTop = n3;
        return n2;
    }

    public void addExceptionHandler(int n, int n2, int n3, String string) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Bad startLabel");
        }
        if ((n2 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Bad endLabel");
        }
        if ((n3 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Bad handlerLabel");
        }
        short s = string == null ? (short)0 : this.itsConstantPool.addClass(string);
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry(n, n2, n3, s);
        int n4 = this.itsExceptionTableTop;
        if (n4 == 0) {
            this.itsExceptionTable = new ExceptionTableEntry[4];
        } else if (n4 == this.itsExceptionTable.length) {
            ExceptionTableEntry[] exceptionTableEntryArray = new ExceptionTableEntry[n4 * 2];
            System.arraycopy(this.itsExceptionTable, 0, exceptionTableEntryArray, 0, n4);
            this.itsExceptionTable = exceptionTableEntryArray;
        }
        this.itsExceptionTable[n4] = exceptionTableEntry;
        this.itsExceptionTableTop = n4 + 1;
    }

    public void addLineNumberEntry(short s) {
        if (this.itsCurrentMethod == null) {
            throw new IllegalArgumentException("No method to stop");
        }
        int n = this.itsLineNumberTableTop;
        if (n == 0) {
            this.itsLineNumberTable = new int[16];
        } else if (n == this.itsLineNumberTable.length) {
            int[] nArray = new int[n * 2];
            System.arraycopy(this.itsLineNumberTable, 0, nArray, 0, n);
            this.itsLineNumberTable = nArray;
        }
        this.itsLineNumberTable[n] = (this.itsCodeBufferTop << 16) + s;
        this.itsLineNumberTableTop = n + 1;
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = this.toByteArray();
        outputStream.write(byArray);
    }

    private int getWriteSize() {
        int n;
        int n2 = 0;
        if (this.itsSourceFileNameIndex != 0) {
            this.itsConstantPool.addUtf8("SourceFile");
        }
        n2 += 8;
        n2 += this.itsConstantPool.getWriteSize();
        n2 += 2;
        n2 += 2;
        n2 += 2;
        n2 += 2;
        n2 += 2 * this.itsInterfaces.size();
        n2 += 2;
        for (n = 0; n < this.itsFields.size(); ++n) {
            n2 += ((ClassFileField)this.itsFields.get(n)).getWriteSize();
        }
        n2 += 2;
        for (n = 0; n < this.itsMethods.size(); ++n) {
            n2 += ((ClassFileMethod)this.itsMethods.get(n)).getWriteSize();
        }
        if (this.itsSourceFileNameIndex != 0) {
            n2 += 2;
            n2 += 2;
            n2 += 4;
            n2 += 2;
        } else {
            n2 += 2;
        }
        return n2;
    }

    public byte[] toByteArray() {
        int n;
        int n2 = this.getWriteSize();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        short s = 0;
        if (this.itsSourceFileNameIndex != 0) {
            s = this.itsConstantPool.addUtf8("SourceFile");
        }
        n3 = ClassFileWriter.putInt64(-3819410108756852691L, byArray, n3);
        n3 = this.itsConstantPool.write(byArray, n3);
        n3 = ClassFileWriter.putInt16(this.itsFlags, byArray, n3);
        n3 = ClassFileWriter.putInt16(this.itsThisClassIndex, byArray, n3);
        n3 = ClassFileWriter.putInt16(this.itsSuperClassIndex, byArray, n3);
        n3 = ClassFileWriter.putInt16(this.itsInterfaces.size(), byArray, n3);
        for (n = 0; n < this.itsInterfaces.size(); ++n) {
            short s2 = (Short)this.itsInterfaces.get(n);
            n3 = ClassFileWriter.putInt16(s2, byArray, n3);
        }
        n3 = ClassFileWriter.putInt16(this.itsFields.size(), byArray, n3);
        for (n = 0; n < this.itsFields.size(); ++n) {
            ClassFileField classFileField = (ClassFileField)this.itsFields.get(n);
            n3 = classFileField.write(byArray, n3);
        }
        n3 = ClassFileWriter.putInt16(this.itsMethods.size(), byArray, n3);
        for (n = 0; n < this.itsMethods.size(); ++n) {
            ClassFileMethod classFileMethod = (ClassFileMethod)this.itsMethods.get(n);
            n3 = classFileMethod.write(byArray, n3);
        }
        if (this.itsSourceFileNameIndex != 0) {
            n3 = ClassFileWriter.putInt16(1, byArray, n3);
            n3 = ClassFileWriter.putInt16(s, byArray, n3);
            n3 = ClassFileWriter.putInt32(2, byArray, n3);
            n3 = ClassFileWriter.putInt16(this.itsSourceFileNameIndex, byArray, n3);
        } else {
            n3 = ClassFileWriter.putInt16(0, byArray, n3);
        }
        if (n3 != n2) {
            throw new RuntimeException();
        }
        return byArray;
    }

    static int putInt64(long l, byte[] byArray, int n) {
        n = ClassFileWriter.putInt32((int)(l >>> 32), byArray, n);
        return ClassFileWriter.putInt32((int)l, byArray, n);
    }

    private static void badStack(int n) {
        String string = n < 0 ? "Stack underflow: " + n : "Too big stack: " + n;
        throw new IllegalStateException(string);
    }

    private static int sizeOfParameters(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(41);
        if (3 <= n && string.charAt(0) == '(' && 1 <= n2 && n2 + 1 < n) {
            boolean bl = true;
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            block15: while (n3 != n2) {
                switch (string.charAt(n3)) {
                    default: {
                        bl = false;
                        break block15;
                    }
                    case 'D': 
                    case 'J': {
                        --n4;
                    }
                    case 'B': 
                    case 'C': 
                    case 'F': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        --n4;
                        ++n5;
                        ++n3;
                        continue block15;
                    }
                    case '[': {
                        char c = string.charAt(++n3);
                        while (c == '[') {
                            c = string.charAt(++n3);
                        }
                        switch (c) {
                            default: {
                                bl = false;
                                break block15;
                            }
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'J': 
                            case 'S': 
                            case 'Z': {
                                --n4;
                                ++n5;
                                ++n3;
                                continue block15;
                            }
                            case 'L': 
                        }
                    }
                    case 'L': {
                        --n4;
                        ++n5;
                        int n6 = string.indexOf(59, ++n3);
                        if (n3 + 1 > n6 || n6 >= n2) {
                            bl = false;
                            break block15;
                        }
                        n3 = n6 + 1;
                        continue block15;
                    }
                }
            }
            if (bl) {
                switch (string.charAt(n2 + 1)) {
                    default: {
                        bl = false;
                        break;
                    }
                    case 'D': 
                    case 'J': {
                        ++n4;
                    }
                    case 'B': 
                    case 'C': 
                    case 'F': 
                    case 'I': 
                    case 'L': 
                    case 'S': 
                    case 'Z': 
                    case '[': {
                        ++n4;
                    }
                    case 'V': 
                }
                if (bl) {
                    return n5 << 16 | 0xFFFF & n4;
                }
            }
        }
        throw new IllegalArgumentException("Bad parameter signature: " + string);
    }

    static int putInt16(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    static int putInt32(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        return n2 + 4;
    }

    static int opcodeCount(int n) {
        switch (n) {
            case -128: 
            case -127: 
            case -126: 
            case -125: 
            case -123: 
            case -122: 
            case -121: 
            case -120: 
            case -119: 
            case -118: 
            case -117: 
            case -116: 
            case -115: 
            case -114: 
            case -113: 
            case -112: 
            case -111: 
            case -110: 
            case -109: 
            case -108: 
            case -107: 
            case -106: 
            case -105: 
            case -104: 
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: 
            case -66: 
            case -65: 
            case -62: 
            case -61: 
            case -60: 
            case -54: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                return 0;
            }
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -87: 
            case -78: 
            case -77: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -69: 
            case -68: 
            case -67: 
            case -64: 
            case -63: 
            case -58: 
            case -57: 
            case -56: 
            case -55: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return 1;
            }
            case -124: 
            case -59: {
                return 2;
            }
            case -86: 
            case -85: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Bad opcode: " + n);
    }

    static int stackChange(int n) {
        switch (n) {
            case 80: 
            case 82: {
                return -4;
            }
            case -108: 
            case -105: 
            case -104: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return -3;
            }
            case -127: 
            case -125: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -83: 
            case -81: 
            case 55: 
            case 57: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 127: {
                return -2;
            }
            case -128: 
            case -126: 
            case -120: 
            case -119: 
            case -114: 
            case -112: 
            case -107: 
            case -106: 
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -86: 
            case -85: 
            case -84: 
            case -82: 
            case -80: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -71: 
            case -65: 
            case -62: 
            case -61: 
            case -58: 
            case -57: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 106: 
            case 108: 
            case 110: 
            case 112: 
            case 114: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return -1;
            }
            case -124: 
            case -122: 
            case -118: 
            case -117: 
            case -113: 
            case -111: 
            case -110: 
            case -109: 
            case -89: 
            case -87: 
            case -79: 
            case -78: 
            case -77: 
            case -72: 
            case -68: 
            case -67: 
            case -66: 
            case -64: 
            case -63: 
            case -60: 
            case -56: 
            case -54: 
            case -2: 
            case -1: 
            case 0: 
            case 47: 
            case 49: 
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return 0;
            }
            case -123: 
            case -121: 
            case -116: 
            case -115: 
            case -88: 
            case -69: 
            case -59: 
            case -55: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 89: 
            case 90: 
            case 91: {
                return 1;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Bad opcode: " + n);
    }

    private static String bytecodeStr(byte by) {
        return "";
    }

    final char[] getCharBuffer(int n) {
        if (n > this.tmpCharBuffer.length) {
            int n2 = this.tmpCharBuffer.length * 2;
            if (n > n2) {
                n2 = n;
            }
            this.tmpCharBuffer = new char[n2];
        }
        return this.tmpCharBuffer;
    }
}

