/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XLoadable;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XModule;
import com.sun.star.frame.XStorable;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.DateTime;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.util.XRefreshable;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.document.OfficeDocument;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.GregorianCalendar;

public class TextDocument {
    public XComponent xComponent;
    public XTextDocument xTextDocument;
    public XNumberFormats NumberFormats;
    public XDocumentInfo xDocInfo;
    public XStatusIndicator xProgressBar;
    public XFrame xFrame;
    public XText xText;
    public XMultiServiceFactory xMSFDoc;
    public XMultiServiceFactory xMSF;
    public XNumberFormatsSupplier xNumberFormatsSupplier;
    public XWindowPeer xWindowPeer;
    public int PageWidth;
    public int ScaleWidth;
    public Size DocSize;
    public Rectangle PosSize;
    public Locale CharLocale;
    public XStorable xStorable;

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, XTerminateListener xTerminateListener, String string) {
        this.xMSF = xMultiServiceFactory;
        this.xFrame = OfficeDocument.createNewFrame(xMultiServiceFactory, xTerminateListener, string);
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, String string, boolean bl, XTerminateListener xTerminateListener) {
        this.xMSF = xMultiServiceFactory;
        this.xFrame = OfficeDocument.createNewFrame(xMultiServiceFactory, xTerminateListener);
        this.xTextDocument = this.loadAsPreview(string, true);
        this.xComponent = (XComponent)UnoRuntime.queryInterface((Class)XComponent.class, (Object)this.xTextDocument);
        if (bl) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, boolean bl, XTerminateListener xTerminateListener) {
        this.xMSF = xMultiServiceFactory;
        XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
        XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface((Class)XFramesSupplier.class, (Object)xDesktop);
        this.xFrame = xFramesSupplier.getActiveFrame();
        this.xComponent = (XComponent)UnoRuntime.queryInterface((Class)XComponent.class, (Object)this.xFrame.getController().getModel());
        this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)XTextDocument.class, (Object)this.xComponent);
        if (bl) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, ModuleIdentifier moduleIdentifier, boolean bl) {
        this.xMSF = xMultiServiceFactory;
        try {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)XTextDocument.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.text.TextDocument"));
            XLoadable xLoadable = (XLoadable)UnoRuntime.queryInterface((Class)XLoadable.class, (Object)this.xTextDocument);
            xLoadable.initNew();
            XModule xModule = (XModule)UnoRuntime.queryInterface((Class)XModule.class, (Object)this.xTextDocument);
            xModule.setIdentifier(moduleIdentifier.getIdentifier());
            XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface((Class)XComponentLoader.class, (Object)xDesktop);
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue("Model", -1, (Object)this.xTextDocument, PropertyState.DIRECT_VALUE)};
            xComponentLoader.loadComponentFromURL("private:object", "_blank", 0, propertyValueArray);
            this.xFrame = this.xTextDocument.getCurrentController().getFrame();
            this.xComponent = (XComponent)UnoRuntime.queryInterface((Class)XComponent.class, (Object)this.xTextDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.showStatusIndicator();
        }
        this.init();
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, XTextDocument xTextDocument, boolean bl) {
        XStatusIndicatorFactory xStatusIndicatorFactory;
        this.xMSF = xMultiServiceFactory;
        this.xFrame = xTextDocument.getCurrentController().getFrame();
        this.xComponent = (XComponent)UnoRuntime.queryInterface((Class)XComponent.class, (Object)xTextDocument);
        this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)XTextDocument.class, (Object)this.xComponent);
        if (bl) {
            xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface((Class)XStatusIndicatorFactory.class, (Object)this.xFrame);
            this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
            this.xProgressBar.start("", 100);
            this.xProgressBar.setValue(5);
        }
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)XMultiServiceFactory.class, (Object)this.xTextDocument);
        this.xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        xStatusIndicatorFactory = (XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)XDocumentInfoSupplier.class, (Object)this.xTextDocument);
        this.xDocInfo = xStatusIndicatorFactory.getDocumentInfo();
        this.CharLocale = (Locale)Helper.getUnoStructValue(this.xComponent, "CharLocale");
        this.xText = this.xTextDocument.getText();
    }

    private void init() {
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)XMultiServiceFactory.class, (Object)this.xTextDocument);
        this.xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)XDocumentInfoSupplier.class, (Object)this.xTextDocument);
        this.xDocInfo = xDocumentInfoSupplier.getDocumentInfo();
        this.CharLocale = (Locale)Helper.getUnoStructValue(this.xComponent, "CharLocale");
        this.xStorable = (XStorable)UnoRuntime.queryInterface((Class)XStorable.class, (Object)this.xTextDocument);
        this.xText = this.xTextDocument.getText();
    }

    private void showStatusIndicator() {
        XStatusIndicatorFactory xStatusIndicatorFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface((Class)XStatusIndicatorFactory.class, (Object)this.xFrame);
        this.xProgressBar = xStatusIndicatorFactory.createStatusIndicator();
        this.xProgressBar.start("", 100);
        this.xProgressBar.setValue(5);
    }

    public XTextDocument loadAsPreview(String string, boolean bl) {
        Object object;
        PropertyValue[] propertyValueArray = new PropertyValue[3];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "ReadOnly";
        propertyValueArray[0].Value = Boolean.TRUE;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "AsTemplate";
        propertyValueArray[1].Value = bl ? Boolean.TRUE : Boolean.FALSE;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "Preview";
        propertyValueArray[2].Value = Boolean.TRUE;
        if (this.xTextDocument != null) {
            try {
                object = (XModifiable)UnoRuntime.queryInterface((Class)XModifiable.class, (Object)this.xTextDocument);
                object.setModified(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace(System.out);
            }
        }
        object = OfficeDocument.load((XInterface)this.xFrame, string, "_self", propertyValueArray);
        this.xTextDocument = (XTextDocument)object;
        this.DocSize = this.getPageSize();
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)XMultiServiceFactory.class, (Object)this.xTextDocument);
        ViewHandler viewHandler = new ViewHandler(this.xMSFDoc, this.xTextDocument);
        try {
            viewHandler.setViewSetting("ZoomType", new Short(2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        TextFieldHandler textFieldHandler = new TextFieldHandler(this.xMSF, this.xTextDocument);
        textFieldHandler.updateDocInfoFields();
        return this.xTextDocument;
    }

    public Size getPageSize() {
        try {
            XStyleFamiliesSupplier xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface((Class)XStyleFamiliesSupplier.class, (Object)this.xTextDocument);
            XNameAccess xNameAccess = null;
            xNameAccess = xStyleFamiliesSupplier.getStyleFamilies();
            XNameContainer xNameContainer = null;
            xNameContainer = (XNameContainer)UnoRuntime.queryInterface((Class)XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            XStyle xStyle = (XStyle)UnoRuntime.queryInterface((Class)XStyle.class, (Object)xNameContainer.getByName("First Page"));
            return (Size)Helper.getUnoPropertyValue(xStyle, "Size");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public TextDocument(XMultiServiceFactory xMultiServiceFactory, String string, PropertyValue[] propertyValueArray, XTerminateListener xTerminateListener) {
        this.xMSF = xMultiServiceFactory;
        XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
        this.xFrame = OfficeDocument.createNewFrame(xMultiServiceFactory, xTerminateListener);
        Object object = OfficeDocument.load((XInterface)this.xFrame, string, "_self", propertyValueArray);
        this.xTextDocument = (XTextDocument)object;
        this.xComponent = (XComponent)UnoRuntime.queryInterface((Class)XComponent.class, (Object)this.xTextDocument);
        XWindow xWindow = this.xFrame.getComponentWindow();
        this.xWindowPeer = (XWindowPeer)UnoRuntime.queryInterface((Class)XWindowPeer.class, (Object)this.xFrame.getComponentWindow());
        this.xMSFDoc = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)XMultiServiceFactory.class, (Object)this.xTextDocument);
        this.xNumberFormatsSupplier = (XNumberFormatsSupplier)UnoRuntime.queryInterface((Class)XNumberFormatsSupplier.class, (Object)this.xTextDocument);
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)XDocumentInfoSupplier.class, (Object)this.xTextDocument);
        this.xDocInfo = xDocumentInfoSupplier.getDocumentInfo();
        this.CharLocale = (Locale)Helper.getUnoStructValue(this.xComponent, "CharLocale");
    }

    public static XTextCursor createTextCursor(Object object) {
        XSimpleText xSimpleText = (XSimpleText)UnoRuntime.queryInterface((Class)XSimpleText.class, (Object)object);
        XTextCursor xTextCursor = xSimpleText.createTextCursor();
        return xTextCursor;
    }

    public int getCharWidth(String string) {
        int n = 200;
        this.xTextDocument.lockControllers();
        int n2 = string.length();
        XTextCursor xTextCursor = TextDocument.createTextCursor(this.xTextDocument.getText());
        xTextCursor.gotoStart(false);
        Helper.setUnoPropertyValue(xTextCursor, "PageDescName", "First Page");
        xTextCursor.setString(string);
        XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface((Class)XTextViewCursorSupplier.class, (Object)this.xTextDocument.getCurrentController());
        XTextViewCursor xTextViewCursor = xTextViewCursorSupplier.getViewCursor();
        xTextViewCursor.gotoStart(false);
        int n3 = xTextViewCursor.getPosition().X;
        xTextViewCursor.gotoEnd(false);
        int n4 = xTextViewCursor.getPosition().X;
        n = (n4 - n3) / n2;
        xTextCursor.gotoStart(false);
        xTextCursor.gotoEnd(true);
        xTextCursor.setString("");
        this.unlockallControllers();
        return n;
    }

    public void unlockallControllers() {
        while (this.xTextDocument.hasControllersLocked()) {
            this.xTextDocument.unlockControllers();
        }
    }

    public void refresh() {
        XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface((Class)XRefreshable.class, (Object)this.xTextDocument);
        xRefreshable.refresh();
    }

    public void setWizardTemplateDocInfo(String string, String string2) {
        try {
            Object object = Configuration.getConfigurationRoot(this.xMSF, "/org.openoffice.UserProfile/Data", false);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)XNameAccess.class, (Object)object);
            Object object2 = xNameAccess.getByName("givenname");
            Object object3 = xNameAccess.getByName("sn");
            String string3 = (String)object2 + " " + (String)object3;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2);
            int n3 = gregorianCalendar.get(5);
            DateTime dateTime = new DateTime();
            dateTime.Day = (short)n3;
            dateTime.Month = (short)n2;
            dateTime.Year = (short)n;
            Helper.DateUtils dateUtils = new Helper.DateUtils(this.xMSF, this.xTextDocument);
            int n4 = dateUtils.getFormat((short)20);
            String string4 = dateUtils.format(n4, dateTime);
            XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)XDocumentInfoSupplier.class, (Object)this.xTextDocument);
            XDocumentInfo xDocumentInfo = xDocumentInfoSupplier.getDocumentInfo();
            Helper.setUnoPropertyValue(xDocumentInfo, "Author", string3);
            Helper.setUnoPropertyValue(xDocumentInfo, "ModifiedBy", string3);
            String string5 = (String)Helper.getUnoPropertyValue(xDocumentInfo, "Description");
            string5 = string5 + " " + string2;
            string5 = JavaTools.replaceSubString(string5, string, "<wizard_name>");
            string5 = JavaTools.replaceSubString(string5, string4, "<current_date>");
            Helper.setUnoPropertyValue(xDocumentInfo, "Description", string5);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean removeTextContent(Object object) {
        try {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)XTextContent.class, (Object)object);
            this.xText.removeTextContent(xTextContent);
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace(System.out);
            return false;
        }
    }

    public static int getPageCount(Object object) {
        XModel xModel = (XModel)UnoRuntime.queryInterface((Class)XModel.class, (Object)object);
        XController xController = xModel.getCurrentController();
        XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface((Class)XTextViewCursorSupplier.class, (Object)xController);
        XTextViewCursor xTextViewCursor = xTextViewCursorSupplier.getViewCursor();
        XPageCursor xPageCursor = (XPageCursor)UnoRuntime.queryInterface((Class)XPageCursor.class, (Object)xTextViewCursor);
        xPageCursor.jumpToLastPage();
        return xPageCursor.getPage();
    }

    public static class ModuleIdentifier {
        private String m_identifier;

        protected final String getIdentifier() {
            return this.m_identifier;
        }

        public ModuleIdentifier(String string) {
            this.m_identifier = string;
        }
    }
}

