/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;

public class SmartSteppingImpl
extends SmartSteppingCallback
implements PropertyChangeListener {
    private Set exclusionPatterns = new HashSet();
    private SmartSteppingFilter smartSteppingFilter;
    private SourcePath engineContext;

    public void initFilter(SmartSteppingFilter f) {
        this.smartSteppingFilter = f;
    }

    public boolean stopHere(ContextProvider lookupProvider, JPDAThread thread, SmartSteppingFilter f) {
        String name;
        int i;
        String className = thread.getClassName();
        if (className == null) {
            return false;
        }
        SourcePath ectx = this.getEngineContext(lookupProvider);
        boolean b = ectx.sourceAvailable(thread, null, false);
        if (b) {
            return true;
        }
        String n1 = className.replace('.', '/');
        while ((i = (name = n1).lastIndexOf(47)) >= 0 && !ectx.sourceAvailable(n1 = name.substring(0, i), false)) {
        }
        HashSet<String> s = new HashSet<String>();
        s.add(name.replace('/', '.') + ".*");
        this.addExclusionPatterns(s);
        return false;
    }

    private void addExclusionPatterns(Set ep) {
        this.smartSteppingFilter.addExclusionPatterns(ep);
        this.exclusionPatterns.addAll(ep);
    }

    private void removeExclusionPatterns() {
        this.smartSteppingFilter.removeExclusionPatterns(this.exclusionPatterns);
        this.exclusionPatterns = new HashSet();
    }

    private SourcePath getEngineContext(ContextProvider lookupProvider) {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)lookupProvider.lookupFirst(null, SourcePath.class);
            this.engineContext.addPropertyChangeListener(this);
        }
        return this.engineContext;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "sourceRoots") {
            this.removeExclusionPatterns();
        }
    }
}

