/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.ejb;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ArrayInitialization;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfig;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfigProperty;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.metadata.Utils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbBuilderUtil {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(EjbBuilderUtil.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    public static final String JAVAX_EJB_REMOTE = "javax.ejb.Remote";
    public static final String JAVAX_EJB_LOCAL = "javax.ejb.Local";
    public static final String JAVAX_EJB_STATELESS = "javax.ejb.Stateless";
    public static final String JAVAX_EJB_STATEFUL = "javax.ejb.Stateful";
    public static final String JAVAX_EJB_MESSAGEDRIVEN = "javax.ejb.MessageDriven";
    public static final String JAVAX_EJB_EJB = "javax.ejb.EJB";
    public static final String WS_PKG = "javax.xml.ws.";
    public static final String WS_SERVICE_CLASS_NAME = "Service";
    public static final String WS_ENDPOINT_CLASS_NAME = "Endpoint";
    public static final String JAVAX_ANNOTATION_RESOURCE = "javax.annotation.Resource";
    public static final String JAVAX_ANNOTATION_WEBSERVICEREF = "javax.xml.ws.WebServiceRef";
    private EjbJar ejbJar;

    public EjbBuilderUtil(EjbJar ejbJar) {
        this.ejbJar = ejbJar;
    }

    public void webServiceRefNNAdded(JavaClass javaClass, Element member, Annotation annotation) {
        ServiceRef sref;
        block17: {
            sref = null;
            try {
                ServiceRef[] srefs;
                String javaClassName = javaClass.getName();
                Session sb = this.getSession(javaClassName);
                MessageDriven md = this.getMessageDriven(javaClassName);
                String serviceRefName = javaClassName + "/" + ((NamedElement)member).getName();
                Object object = sb == null ? (md == null ? null : md.getServiceRef()) : (srefs = sb.getServiceRef());
                if (srefs == null) break block17;
                for (ServiceRef sr : srefs) {
                    if (!serviceRefName.equals(sr.getServiceRefName())) continue;
                    sref = sr;
                    break;
                }
            }
            catch (VersionNotSupportedException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        if (sref == null) {
            return;
        }
        JavaModelPackage jmp = (JavaModelPackage)javaClass.refImmediatePackage();
        Type _ServiceType = jmp.getJavaClass().resolve("javax.xml.ws.Service");
        Type _EndpointType = jmp.getJavaClass().resolve("javax.xml.ws.Endpoint");
        JavaClass typeJC = null;
        JavaClass valueJC = null;
        if (member instanceof Field) {
            typeJC = (JavaClass)((Field)member).getTypeName().getElement();
        }
        String wsdlFileAttr = null;
        for (AttributeValue av : annotation.getAttributeValues()) {
            String aName = av.getDefinition().getName();
            InitialValue val = av.getValue();
            if (val instanceof ClassExpression) {
                TypeReference tr = ((ClassExpression)val).getClassName();
                JavaClass jc = (JavaClass)tr.getElement();
                if ("type".equals(aName)) {
                    typeJC = jc;
                }
                if (!"value".equals(aName)) continue;
                valueJC = jc;
                continue;
            }
            if (!(val instanceof StringLiteral) || !"wsdlLocation".equals(aName)) continue;
            StringLiteral sl = (StringLiteral)val;
            wsdlFileAttr = sl.getValue();
        }
        if (valueJC == null) {
            sref.setServiceInterface(typeJC.getName());
        }
        if (Utils.isOfType((JavaClass)typeJC, (Type)_EndpointType) && valueJC != null) {
            sref.setServiceInterface(valueJC.getName());
        }
        if (valueJC != null && Utils.isOfType(valueJC, (Type)_ServiceType)) {
            PortComponentRef pcr = null;
            try {
                pcr = sref.newPortComponentRef();
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (pcr != null) {
                pcr.setServiceEndpointInterface(typeJC.getName());
                sref.addPortComponentRef(pcr);
            }
        }
        if (wsdlFileAttr != null) {
            try {
                URI wsdlFileURI = new URI(wsdlFileAttr);
                sref.setWsdlFile(wsdlFileURI);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    }

    public String handleMessageDriven(JavaClass javaClass, Annotation annotation) {
        if (LOG) {
            LOGGER.log("handleMessageDriven: " + javaClass.getName() + ", " + annotation.getType().getName());
        }
        Map<String, String> activationConfigProperties = this.getActivationConfigProperties(annotation);
        MessageDriven mdb = this.getMessageDriven(javaClass.getName());
        try {
            mdb.setMessageDestinationType(activationConfigProperties.get("destinationType"));
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        this.addOrUpdateActivationConfigProperty(mdb, "destinationType", activationConfigProperties.get("destinationType"));
        this.addOrUpdateActivationConfigProperty(mdb, "acknowledgeMode", activationConfigProperties.get("acknowledgeMode"));
        this.addOrUpdateActivationConfigProperty(mdb, "subscriptionDurability", activationConfigProperties.get("subscriptionDurability"));
        this.addOrUpdateActivationConfigProperty(mdb, "messageSelector", activationConfigProperties.get("messageSelector"));
        try {
            this.addOrUpdateAssemblyDescriptorForMDB(mdb);
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return mdb.getEjbName();
    }

    public void updateLocal(JavaClass javaClass) {
        if (javaClass.isInterface()) {
            Collection implementors = javaClass.getImplementors();
            for (ClassDefinition cd : implementors) {
                if (!(cd instanceof JavaClass) || ((JavaClass)cd).isInterface()) continue;
                try {
                    this.handleInterfaces((JavaClass)cd);
                }
                catch (VersionNotSupportedException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        } else {
            try {
                this.handleInterfaces(javaClass);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    public void updateRemote(JavaClass javaClass) {
        this.updateLocal(javaClass);
    }

    public void handleInterfaces(JavaClass jc) throws VersionNotSupportedException {
        Session session = this.getSession(jc.getName());
        if (session == null) {
            ErrorManager.getDefault().log("Session bean for " + jc.getName() + " class not found.");
            return;
        }
        ArrayList<JavaClass> businessInterfaces = new ArrayList<JavaClass>();
        List interfaces = jc.getInterfaces();
        for (JavaClass interfaceClass : interfaces) {
            String fqn = interfaceClass.getName();
            if ("java.io.Serializable".equals(fqn) || "java.io.Externalizable".equals(fqn) || fqn.startsWith("javax.ejb")) continue;
            businessInterfaces.add(interfaceClass);
        }
        int biCount = businessInterfaces.size();
        if (biCount < 1) {
            return;
        }
        List<Object> remoteInterfaces = new ArrayList<String>();
        Annotation aRemote = EjbBuilderUtil.findAnnotation((AnnotableElement)jc, JAVAX_EJB_REMOTE);
        if (aRemote != null) {
            remoteInterfaces = EjbBuilderUtil.getInterfaceNames(aRemote);
        }
        remoteInterfaces.addAll(EjbBuilderUtil.getAnnotatedInterfaces(businessInterfaces, JAVAX_EJB_REMOTE));
        List<Object> localInterfaces = new ArrayList<String>();
        Annotation aLocal = EjbBuilderUtil.findAnnotation((AnnotableElement)jc, JAVAX_EJB_LOCAL);
        if (aLocal != null) {
            localInterfaces = EjbBuilderUtil.getInterfaceNames(aLocal);
        }
        localInterfaces.addAll(EjbBuilderUtil.getAnnotatedInterfaces(businessInterfaces, JAVAX_EJB_LOCAL));
        if (localInterfaces.isEmpty() && remoteInterfaces.isEmpty() && biCount == 1) {
            String name = ((JavaClass)businessInterfaces.get(0)).getName();
            if (!EjbBuilderUtil.containsName(session.getBusinessLocal(), name) && !name.endsWith("Remote")) {
                session.addBusinessLocal(name);
                session.setLocal(name);
            }
            return;
        }
        if (localInterfaces.isEmpty()) {
            session.setBusinessLocal(new String[0]);
        } else {
            for (String string : localInterfaces) {
                if (EjbBuilderUtil.containsName(session.getBusinessLocal(), string)) continue;
                session.addBusinessLocal(string);
            }
            session.setLocal((String)localInterfaces.get(0));
        }
        if (remoteInterfaces.isEmpty()) {
            session.setBusinessRemote(new String[0]);
        } else {
            for (String string : remoteInterfaces) {
                if (EjbBuilderUtil.containsName(session.getBusinessRemote(), string)) continue;
                session.addBusinessRemote(string);
            }
            session.setRemote((String)remoteInterfaces.get(0));
        }
    }

    public static Session findReferencedSessionBean(TypedElement element, Annotation annotation) {
        ArrayList<Session> localInterfaceExposers = new ArrayList<Session>();
        ArrayList<Session> remoteInterfaceExposers = new ArrayList<Session>();
        String typeName = element.getType().getName();
        List<Session> sbs = EjbBuilderUtil.getSessionBeansFromAllProjects();
        for (Session session : sbs) {
            if (EjbBuilderUtil.exposesLocalInterface(session, typeName)) {
                localInterfaceExposers.add(session);
            }
            if (!EjbBuilderUtil.exposesRemoteInterface(session, typeName)) continue;
            remoteInterfaceExposers.add(session);
        }
        AttributeValue av = EjbBuilderUtil.findAttribute(annotation, "beanName");
        if (av == null) {
            int localExposers = localInterfaceExposers.size();
            int remoteExposers = remoteInterfaceExposers.size();
            if (localExposers != 0) {
                return (Session)localInterfaceExposers.get(0);
            }
            if (remoteExposers != 0) {
                return (Session)remoteInterfaceExposers.get(0);
            }
        } else {
            String beanName;
            InitialValue value = av.getValue();
            if (value instanceof StringLiteral && (beanName = ((StringLiteral)value).getValue()) != null) {
                return EjbBuilderUtil.getSessionByEjbNameFromAllProjects(sbs, beanName);
            }
        }
        return null;
    }

    public static boolean exposesLocalInterface(Session session, String typeName) {
        try {
            for (String businessLocal : session.getBusinessLocal()) {
                if (!typeName.equals(businessLocal)) continue;
                return true;
            }
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return false;
    }

    public static boolean exposesRemoteInterface(Session session, String typeName) {
        try {
            for (String businessRemote : session.getBusinessRemote()) {
                if (!typeName.equals(businessRemote)) continue;
                return true;
            }
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return false;
    }

    public Session getSession(String ejbClass) {
        return (Session)this.getEnterpriseBeans().findBeanByName("Session", "EjbClass", ejbClass);
    }

    public MessageDriven getMessageDriven(String ejbClass) {
        return (MessageDriven)this.getEnterpriseBeans().findBeanByName("MessageDriven", "EjbClass", ejbClass);
    }

    public EnterpriseBeans getEnterpriseBeans() {
        EnterpriseBeans enterpriseBeans = this.ejbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            enterpriseBeans = this.ejbJar.newEnterpriseBeans();
            this.ejbJar.setEnterpriseBeans(enterpriseBeans);
        }
        return enterpriseBeans;
    }

    private static Session getSessionByEjbNameFromAllProjects(List<Session> sbs, String ejbName) {
        if (ejbName != null) {
            for (Session session : sbs) {
                if (!ejbName.equals(session.getEjbName())) continue;
                return session;
            }
        }
        return null;
    }

    public static List<Session> getSessionBeansFromAllProjects() {
        ArrayList<Session> result = new ArrayList<Session>();
        for (EjbJar ejbJar : DDProvider.getDefault().getRoots()) {
            EnterpriseBeans ebs = ejbJar.getEnterpriseBeans();
            if (ebs == null) continue;
            for (Session session : ebs.getSession()) {
                result.add(session);
            }
        }
        return result;
    }

    private static boolean containsName(String[] array, String name) {
        for (String elem : array) {
            if (!elem.equals(name)) continue;
            return true;
        }
        return false;
    }

    private void addOrUpdateActivationConfigProperty(MessageDriven mdb, String propertyName, String propertyValue) {
        if (LOG) {
            LOGGER.log("addOrUpdateActivationConfigProperty : " + mdb.getEjbClass() + ", " + propertyName + ", " + propertyValue);
        }
        try {
            ActivationConfig activationConfig = mdb.getActivationConfig();
            if (activationConfig == null) {
                if (LOG) {
                    LOGGER.log("addOrUpdateActivationConfigProperty 2 - creating new ActivationConfig");
                }
                activationConfig = mdb.newActivationConfig();
                mdb.setActivationConfig(activationConfig);
            }
            ActivationConfigProperty[] acps = activationConfig.getActivationConfigProperty();
            if (LOG) {
                LOGGER.log("addOrUpdateActivationConfigProperty 3: " + acps.length);
            }
            for (int i = 0; i < acps.length; ++i) {
                if (LOG) {
                    LOGGER.log("addOrUpdateActivationConfigProperty 4: " + acps[i].getActivationConfigPropertyName() + ", " + acps[i].getActivationConfigPropertyValue());
                }
                if (!acps[i].getActivationConfigPropertyName().equals(propertyName)) continue;
                if (propertyValue == null) {
                    activationConfig.removeActivationConfigProperty(acps[i]);
                } else {
                    acps[i].setActivationConfigPropertyValue(propertyValue);
                }
                return;
            }
            if (propertyValue != null) {
                if (LOG) {
                    LOGGER.log("addOrUpdateActivationConfigProperty 5");
                }
                ActivationConfigProperty newAcp = activationConfig.newActivationConfigProperty();
                newAcp.setActivationConfigPropertyName(propertyName);
                newAcp.setActivationConfigPropertyValue(propertyValue);
                activationConfig.addActivationConfigProperty(newAcp);
            }
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void addOrUpdateAssemblyDescriptorForMDB(MessageDriven mb) throws VersionNotSupportedException {
        AssemblyDescriptor ad = this.ejbJar.getSingleAssemblyDescriptor();
        if (ad == null) {
            ad = this.ejbJar.newAssemblyDescriptor();
            this.ejbJar.setAssemblyDescriptor(ad);
        }
        MessageDestination[] messageDestinations = ad.getMessageDestination();
        String ejbName = mb.getEjbName();
        for (int i = 0; i < messageDestinations.length; ++i) {
            if (!messageDestinations[i].getMessageDestinationName().equals(mb.getMessageDestinationLink())) continue;
            return;
        }
        MessageDestination md = ad.newMessageDestination();
        md.setDisplayName("Destination for " + ejbName);
        md.setMessageDestinationName(ejbName);
        ad.addMessageDestination(md);
        mb.setMessageDestinationLink(ejbName);
        ContainerTransaction ct = ad.newContainerTransaction();
        ct.setTransAttribute("Required");
        Method m = ct.newMethod();
        m.setEjbName(ejbName);
        m.setMethodName("*");
        ct.addMethod(m);
        ad.addContainerTransaction(ct);
    }

    private Map<String, String> getActivationConfigProperties(Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("null passed to EjbBuilderUtil.getActivationConfigProperties(Annotation)");
        }
        if (!JAVAX_EJB_MESSAGEDRIVEN.equals(annotation.getType().getName())) {
            throw new IllegalArgumentException("javax.ejb.MessageDriven annotation was expected, but " + annotation.getType().getName() + " was passed");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (AttributeValue av : annotation.getAttributeValues()) {
            if (!"activationConfig".equals(av.getName())) continue;
            ArrayInitialization ai = (ArrayInitialization)av.getValue();
            for (InitialValue iv : ai.getElementValues()) {
                if (!(iv instanceof Annotation)) continue;
                Annotation acp = (Annotation)iv;
                List nameAndValue = acp.getAttributeValues();
                assert (nameAndValue.size() == 2);
                AttributeValue av1 = (AttributeValue)nameAndValue.get(0);
                AttributeValue av2 = (AttributeValue)nameAndValue.get(1);
                String attribute1 = ((StringLiteral)av1.getValue()).getValue();
                String attribute2 = ((StringLiteral)av2.getValue()).getValue();
                if ("propertyName".equals(av1.getDefinition().getName())) {
                    resultMap.put(attribute1, attribute2);
                    continue;
                }
                resultMap.put(attribute2, attribute1);
            }
        }
        return resultMap;
    }

    private static Annotation findAnnotation(AnnotableElement element, String fqnAnnotation) {
        List annotations = element.getAnnotations();
        for (Annotation a : annotations) {
            AnnotationType t = a.getType();
            if (t == null || !t.getName().equals(fqnAnnotation)) continue;
            return a;
        }
        return null;
    }

    private static Set<String> getAnnotatedInterfaces(List<? extends AnnotableElement> list, String fqnAnnotation) {
        HashSet<String> result = new HashSet<String>();
        for (AnnotableElement annotableElement : list) {
            if (EjbBuilderUtil.findAnnotation(annotableElement, fqnAnnotation) == null) continue;
            result.add(annotableElement.getName());
        }
        return result;
    }

    private static AttributeValue findAttribute(Annotation annotation, String attributeName) {
        List attributeValues = annotation.getAttributeValues();
        for (AttributeValue av : attributeValues) {
            String avName = av.getName();
            if (avName == null || !avName.equals(attributeName)) continue;
            return av;
        }
        return null;
    }

    private static List<String> getInterfaceNames(Annotation annotation) {
        ArrayList<String> result = new ArrayList<String>();
        AttributeValue valueAV = EjbBuilderUtil.findAttribute(annotation, "value");
        if (valueAV != null) {
            for (Object elem : ((ArrayInitialization)valueAV.getValue()).getElementValues()) {
                result.add(((ClassExpression)elem).getClassName().getName());
            }
        }
        return result;
    }
}

