/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class Log
implements LayoutCharacters {
    protected static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    protected final int MaxErrors;
    protected final int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean dumpOnError;
    public String encoding;
    private Name sourcename;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<Name, Integer>> recorded = new HashSet<Pair<Name, Integer>>();
    protected char[] buf = null;
    private int bp;
    private int line;
    private int lineStart;
    private static final String compilerRB = "com.sun.tools.javac.resources.compiler";
    private static ResourceBundle messageRB;

    protected Log(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        context.put(logKey, this);
        this.errWriter = errWriter;
        this.warnWriter = warnWriter;
        this.noticeWriter = noticeWriter;
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-nowarn") == null;
        this.sourcename = Name.Table.instance((Context)context).__input;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
        this.encoding = (String)options.get("-encoding");
    }

    private int getIntOption(Options options, String optionName, int defaultValue) {
        String s = (String)options.get(optionName);
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return defaultValue;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter result = context.get(outKey);
        if (result == null) {
            result = new PrintWriter(System.err);
            context.put(outKey, result);
        }
        return result;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter defaultWriter) {
        this(context, defaultWriter, defaultWriter, defaultWriter);
    }

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public Name useSource(Name name) {
        Name prev = this.sourcename;
        this.sourcename = name;
        if (prev != this.sourcename) {
            this.buf = null;
        }
        return prev;
    }

    protected void setBuf(char[] newBuf) {
        this.buf = newBuf;
        this.bp = 0;
        this.lineStart = 0;
        this.line = 1;
    }

    public Name currentSource() {
        return this.sourcename;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    protected boolean shouldReport(int pos) {
        boolean shouldReport;
        Pair<Name, Integer> coords = new Pair<Name, Integer>(this.sourcename, new Integer(pos));
        boolean bl = shouldReport = !this.recorded.contains(coords);
        if (shouldReport) {
            this.recorded.add(coords);
        }
        return shouldReport;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean findLine(int pos) {
        boolean result = false;
        try {
            if (this.buf == null) {
                int n;
                FileInputStream fis = new FileInputStream(this.sourcename.toString());
                InputStreamReader in = this.encoding != null ? new InputStreamReader((InputStream)fis, this.encoding) : new InputStreamReader(fis);
                CharArrayWriter out = new CharArrayWriter();
                char[] cb = new char[4096];
                while ((n = in.read(cb)) > 0) {
                    out.write(cb, 0, n);
                }
                this.buf = out.toCharArray();
                in.close();
                fis.close();
                this.lineStart = this.bp = 0;
                this.line = 1;
            } else if (this.lineStart > pos) {
                this.lineStart = this.bp = 0;
                this.line = 1;
            }
            this.bp = this.lineStart;
            block7: while (this.bp < this.buf.length && this.bp < pos) {
                switch (this.buf[this.bp]) {
                    case '\r': {
                        ++this.bp;
                        if (this.bp >= this.buf.length || this.buf[this.bp] == '\n') {
                            // empty if block
                        }
                        ++this.line;
                        this.lineStart = ++this.bp;
                        continue block7;
                    }
                    case '\n': {
                        ++this.line;
                        this.lineStart = ++this.bp;
                        continue block7;
                    }
                }
                ++this.bp;
            }
            result = this.bp < this.buf.length;
        }
        catch (IOException e) {
            Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable", new Object[0]));
        }
        return result;
    }

    private void printErrLine(int pos, PrintWriter writer) {
        int lineEnd;
        for (lineEnd = this.lineStart; lineEnd < this.buf.length && this.buf[lineEnd] != '\r' && this.buf[lineEnd] != '\n'; ++lineEnd) {
        }
        Log.printLines(writer, new String(this.buf, this.lineStart, lineEnd - this.lineStart));
        int column = 0;
        this.bp = this.lineStart;
        while (this.bp < pos) {
            column = this.buf[this.bp] == '\t' ? column / 8 * 8 + 8 : ++column;
            ++this.bp;
        }
        char[] ptr = new char[column + 1];
        for (int i = 0; i < column; ++i) {
            ptr[i] = 32;
        }
        ptr[column] = 94;
        Log.printLines(writer, new String(ptr, 0, column + 1));
        this.errWriter.flush();
    }

    public static void printLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    private void printDiagnostic(int pos, String msg, PrintWriter writer) {
        if (pos != -1 && this.findLine(pos)) {
            Log.printLines(writer, this.sourcename + ":" + this.line + ": " + msg);
            this.printErrLine(pos, writer);
        } else {
            Log.printLines(writer, msg);
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    public void error(int pos, String key, Object[] args) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(pos)) {
            this.printDiagnostic(pos, (pos == -1 ? Log.getText("compiler.err.error", new Object[0]) : "") + Log.getText("compiler.err." + key, args), this.errWriter);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int pos, String key, Object[] args) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printDiagnostic(pos, Log.getText("compiler.warn.warning", new Object[0]) + Log.getText("compiler.warn." + key, args), this.warnWriter);
            this.prompt();
            ++this.nwarnings;
        }
    }

    public void note(String key, Object[] args) {
        if (this.emitWarnings) {
            this.noticeWriter.print(Log.getText("compiler.note.note", new Object[0]));
            String msg = Log.getText("compiler.note." + key, args);
            Log.printLines(this.noticeWriter, msg);
            this.noticeWriter.flush();
        }
    }

    public static String getLocalizedString(String key, Object[] args) {
        return Log.getText("compiler.misc." + key, args);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public static String getText(String key, Object[] _args) {
        String[] args = new String[_args.length];
        for (int i = 0; i < _args.length; ++i) {
            args[i] = "" + _args[i];
        }
        if (messageRB == null) {
            Log.initResource();
        }
        try {
            return MessageFormat.format(messageRB.getString(key), args);
        }
        catch (MissingResourceException e) {
            String msg = "compiler message file broken: key=" + key + " arguments={0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(msg, args);
        }
    }

    private void printRawError(int pos, String msg) {
        if (pos == -1) {
            Log.printLines(this.errWriter, "error: " + msg);
        } else if (this.findLine(pos)) {
            Log.printLines(this.errWriter, this.sourcename + ":" + this.line + ": " + msg);
            this.printErrLine(pos, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int pos, String msg) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(pos)) {
            this.printRawError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(pos, "warning: " + msg);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    protected int getLineNumber(int pos) {
        if (pos != -1 && this.findLine(pos)) {
            return this.line;
        }
        return 0;
    }

    protected int getColumnNumber(int pos) {
        if (pos != -1 && this.findLine(pos)) {
            int column = 0;
            this.bp = this.lineStart;
            while (this.bp < pos) {
                if (this.bp >= this.buf.length) {
                    return 0;
                }
                column = this.buf[this.bp] == '\t' ? column / 8 * 8 + 8 : ++column;
                ++this.bp;
            }
            return column + 1;
        }
        return 0;
    }
}

