/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.util.Iterator;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.Target;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentConfigurationProvider;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ServerFileDistributor;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.plugins.api.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerProgress;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class InitialServerFileDistributor
extends ServerProgress {
    ServerString serverString;
    DeploymentTarget dtarget;
    IncrementalDeployment incDeployment;
    Target target;
    boolean inPlace = false;

    public InitialServerFileDistributor(DeploymentTarget dtarget, Target target) {
        super(dtarget.getServer().getServerInstance());
        this.serverString = dtarget.getServer();
        this.dtarget = dtarget;
        this.target = target;
        this.incDeployment = this.serverString.getServerInstance().getIncrementalDeployment();
    }

    public File distribute() {
        DeploymentConfigurationProvider deployment = this.dtarget.getDeploymentConfigurationProvider();
        J2eeModule source = this.dtarget.getModule();
        DeployableObject deployable = deployment.getDeployableObject(null);
        String name = this.dtarget.getDeploymentName();
        File dir = this.incDeployment.getDirectoryForNewApplication(name, this.target, deployment.getDeploymentConfiguration());
        try {
            if (dir == null) {
                this.inPlace = true;
                if (this.dtarget.getModule().getContentDirectory() != null) {
                    dir = FileUtil.toFile((FileObject)this.dtarget.getModule().getContentDirectory());
                }
                if (dir == null) {
                    String msg = NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_InPlaceNoSupport");
                    this.setStatusDistributeFailed(msg);
                    return null;
                }
                this.setStatusDistributeCompleted(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_InPlaceDeployment", (Object)dir));
                return dir;
            }
            this.setStatusDistributeRunning(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_RunningInitialDeploy", (Object)this.dtarget.getDeploymentName(), (Object)dir));
            this._distribute(source.getArchiveContents(), dir, null);
            if (source instanceof J2eeModuleContainer) {
                J2eeModule[] childModules = ((J2eeModuleContainer)source).getModules(null);
                for (int i = 0; i < childModules.length; ++i) {
                    String uri = childModules[i].getUrl();
                    DeployableObject childModule = deployment.getDeployableObject(uri);
                    File subdir = this.incDeployment.getDirectoryForNewModule(dir, uri, childModule, deployment.getDeploymentConfiguration());
                    this._distribute(childModules[i].getArchiveContents(), subdir, uri);
                }
            }
            this.setStatusDistributeCompleted(NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_DoneInitialDistribute", (Object)this.dtarget.getDeploymentName()));
            return dir;
        }
        catch (Exception e) {
            this.setStatusDistributeFailed(e.getMessage());
            ErrorManager.getDefault().notify(1, (Throwable)e);
            if (!this.inPlace && !this.cleanup(dir)) {
                this.setStatusDistributeFailed("Failed to cleanup the data after unsucesful distribution");
            }
            return null;
        }
    }

    public void cleanup() {
        if (this.inPlace) {
            return;
        }
        DeploymentConfigurationProvider deployment = this.dtarget.getDeploymentConfigurationProvider();
        J2eeModule source = this.dtarget.getModule();
        DeployableObject deployable = deployment.getDeployableObject(null);
        File dir = this.incDeployment.getDirectoryForNewApplication(this.target, deployable, deployment.getDeploymentConfiguration());
        if (!this.cleanup(dir)) {
            this.setStatusDistributeFailed("Failed to cleanup the data after unsucesful distribution");
        }
    }

    private boolean cleanup(File f) {
        String[] chNames = f.list();
        boolean deleted = true;
        for (int i = 0; i < chNames.length; ++i) {
            File ch = new File(f.getAbsolutePath(), chNames[i]);
            deleted = ch.isDirectory() ? deleted && this.cleanup(ch) : deleted && ch.delete();
        }
        deleted = deleted && f.delete();
        return deleted;
    }

    private void _distribute(Iterator rootedEntries, File dir, String childModuleUri) {
        Object lock = null;
        Object in = null;
        Object out = null;
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File parent = dir.getParentFile();
            FileObject destRoot = FileUtil.toFileObject((File)parent);
            FileObject[] garbages = destRoot.getChildren();
            for (int i = 0; i < garbages.length; ++i) {
                garbages[i].delete();
            }
            while (rootedEntries.hasNext()) {
                J2eeModule.RootedEntry entry = (J2eeModule.RootedEntry)rootedEntries.next();
                String relativePath = entry.getRelativePath();
                FileObject sourceFO = entry.getFileObject();
                FileObject destFolder = ServerFileDistributor.findOrCreateParentFolder(destRoot, relativePath);
                if (!sourceFO.isData()) continue;
                FileUtil.copyFile((FileObject)sourceFO, (FileObject)destFolder, (String)sourceFO.getName());
            }
            DeploymentConfigurationProvider dcp = this.dtarget.getDeploymentConfigurationProvider();
            DeploymentConfiguration config = dcp.getDeploymentConfiguration();
            DeployableObject deployable = dcp.getDeployableObject(childModuleUri);
        }
        catch (Exception e) {
            String msg = NbBundle.getMessage(InitialServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)e);
            this.setStatusDistributeFailed(msg);
            throw new RuntimeException(e);
        }
        finally {
            if (lock != null) {
                try {
                    lock.releaseLock();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void setStatusDistributeRunning(String message) {
        this.notify(this.createRunningProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeFailed(String message) {
        this.notify(this.createFailedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeCompleted(String message) {
        this.notify(this.createCompletedProgressEvent(CommandType.DISTRIBUTE, message));
    }
}

