/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.jmi.javamodel.ArrayAccess;
import org.netbeans.jmi.javamodel.BehavioralFeature;
import org.netbeans.jmi.javamodel.BooleanLiteral;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.CharLiteral;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ConditionalExpression;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.DoubleLiteral;
import org.netbeans.jmi.javamodel.ErrorInfo;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FloatLiteral;
import org.netbeans.jmi.javamodel.IntLiteral;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LongLiteral;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.NullLiteral;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.java.hints.AddCastJavaHint;
import org.netbeans.modules.java.hints.AddThrowsClauseJavaHint;
import org.netbeans.modules.java.hints.CreateFieldJavaHint;
import org.netbeans.modules.java.hints.CreateLocVarJavaHint;
import org.netbeans.modules.java.hints.CreateMethodJavaHint;
import org.netbeans.modules.java.hints.CreateParameterJavaHint;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.java.hints.ImplementMethodJavaHint;
import org.netbeans.modules.java.hints.ImplementMethodJavaHint2;
import org.netbeans.modules.java.hints.ImportJavaHint;
import org.netbeans.modules.java.hints.InitializeVariableHint;
import org.netbeans.modules.java.hints.MakeClassAbstractJavaHint;
import org.netbeans.modules.java.hints.TryWrapperJavaHint;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.internalapi.ParsingListener;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;

public final class JavaHintsProvider
extends HintsProvider
implements ParsingListener {
    private static ErrorManager ERR;
    private static final String INCOMPATIBLE_TYPES = "prob.found.req";
    private static final String CANT_RESOLVE = "cant.resolve";
    private static final String CANT_RESOLVE_LOCATION = "cant.resolve.location";
    private static final String CANT_APPLY_SYMBOL = "cant.apply.symbol";
    private static final String UNREPORTED_EXCEPTION_ERROR = "unreported.exception.need.to.catch.or.throw";
    private static final String VAR_MIGHT_NOT_HAVE_BEEN_INITIALIZED = "var.might.not.have.been.initialized";
    private static final String DOES_NOT_OVERRIDE_ABSTRACT = "does.not.override.abstract";
    private static final String ABSTRACT_CANT_BE_INSTANTIATED = "abstract.cant.be.instantiated";
    private static final String DOESNT_EXIST = "doesnt.exist";
    private static final String KINDNAME_CONSTRUCTOR = "kindname.constructor";
    private static final String KINDNAME_VARIABLE = "kindname.variable";
    private static final String KINDNAME_METHOD = "kindname.method";
    private static final int TabInc = 8;
    private static HintCreator[] creators;
    private static FieldHintCreator[] fieldHintCreators;
    private static MethodHintCreator[] methodHintCreators;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaHintsProvider() {
        JavaMetamodel.getManager();
        JavaMetamodel.addParsingListener((ParsingListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getHints(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) return Collections.EMPTY_LIST;
        try {
            JavaMetamodel m;
            Resource resource;
            ArrayList result;
            block27: {
                List errors;
                BaseDocument baseDoc = (BaseDocument)doc;
                result = new ArrayList();
                resource = null;
                JMIUtils utils = null;
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    utils = JMIUtils.get((BaseDocument)baseDoc);
                    resource = utils.getResource();
                    if (resource == null) {
                        List list = Collections.EMPTY_LIST;
                        return list;
                    }
                    errors = resource.getErrors();
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
                int lineNumber = Utilities.getLineOffset((BaseDocument)baseDoc, (int)offset) + 1;
                int realStart = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDoc, (int)Utilities.getRowStart((BaseDocument)baseDoc, (int)offset));
                int realEnd = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDoc, (int)Utilities.getRowEnd((BaseDocument)baseDoc, (int)offset));
                if (realStart > realEnd) {
                    return Collections.EMPTY_LIST;
                }
                if (errors.size() == 0) {
                    return Collections.EMPTY_LIST;
                }
                offset = Math.min(Math.max(offset, realStart), realEnd);
                HashSet<String> handledDescriptions = new HashSet<String>();
                m = JavaMetamodel.getManager();
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    Field f;
                    if (!resource.isValid()) {
                        List list = Collections.EMPTY_LIST;
                        return list;
                    }
                    JavaModel.setClassPath((Resource)resource);
                    if (ERR.isLoggable(1)) {
                        org.netbeans.jmi.javamodel.Element el = resource.getElementByOffset(offset);
                        ERR.log("el=" + el);
                    }
                    Iterator i = errors.iterator();
                    while (i.hasNext()) {
                        ErrorInfo error = (ErrorInfo)i.next();
                        if (error.getLineNumber() != lineNumber) continue;
                        String description = error.getDescription();
                        if (ERR.isLoggable(1)) {
                            ERR.log("description = " + description);
                            ERR.log("line = " + error.getLineNumber());
                            ERR.log("column = " + error.getColumn());
                        }
                        if (handledDescriptions.contains(description)) continue;
                        handledDescriptions.add(description);
                        for (int cntr = 0; cntr < creators.length; ++cntr) {
                            if (!error.getErrorId().equals(creators[cntr].getErrorId())) continue;
                            creators[cntr].createHint(utils, resource, doc, error, result);
                        }
                    }
                    org.netbeans.jmi.javamodel.Element e = resource.getElementByOffset(offset);
                    if (ERR.isLoggable(1)) {
                        ERR.log("element = " + e);
                    }
                    if (e instanceof Field) {
                        f = (Field)e;
                        for (int i2 = 0; i2 < fieldHintCreators.length; ++i2) {
                            fieldHintCreators[i2].createHint(utils, resource, doc, f, offset, result);
                        }
                        break block27;
                    }
                    f = JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)e);
                    if (!(f instanceof CallableFeature)) break block27;
                    CallableFeature feature = (CallableFeature)f;
                    PositionBounds bounds = m.getElementPosition((org.netbeans.jmi.javamodel.Element)feature);
                    if (feature instanceof Method && bounds.getBegin().getOffset() <= offset && bounds.getEnd().getOffset() >= offset) {
                        for (int i3 = 0; i3 < methodHintCreators.length; ++i3) {
                            methodHintCreators[i3].createHint(utils, resource, doc, (Method)feature, offset, result);
                        }
                    }
                }
                catch (Exception e) {
                    if (resource == null) throw new RuntimeException(e);
                    if (!m.isModified(m.getFileObject(resource))) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    JavaModel.getJavaRepository().endTrans();
                }
            }
            if (!m.isModified(m.getFileObject(resource))) return result;
            return Collections.EMPTY_LIST;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean isConstant(Field f, boolean publik) {
        int constModif = 24;
        if (publik) {
            constModif |= 1;
        }
        return (f.getModifiers() & constModif) == constModif;
    }

    private static boolean isFinal(Field f) {
        return (f.getModifiers() & 0x10) == 16;
    }

    private static void handleUnresolvedHints(JMIUtils utils, Resource resource, int errorOffset, ClassDefinition clazz, String symbol, boolean isField, boolean isMethod, boolean isStaticMethodCall, List result) {
        if ((isField || isMethod) && clazz != null && !JavaHintsProvider.isReadOnly(clazz.getResource())) {
            NamedElement unresolvedElement = JavaHintsProvider.getElementByOffset(resource, errorOffset, symbol);
            if (unresolvedElement != null && unresolvedElement.getResource() != null) {
                if (isField) {
                    MultipartId id;
                    Feature feature = JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)unresolvedElement);
                    result.add(new CreateFieldJavaHint(unresolvedElement, clazz));
                    boolean proposeLocalVar = unresolvedElement instanceof MultipartId ? (id = (MultipartId)unresolvedElement).getParent() == null : false;
                    if (feature instanceof BehavioralFeature && proposeLocalVar) {
                        if (feature instanceof CallableFeature) {
                            result.add(new CreateParameterJavaHint(unresolvedElement));
                        }
                        result.add(new CreateLocVarJavaHint(unresolvedElement));
                    }
                } else if (isMethod && unresolvedElement instanceof Invocation) {
                    result.add(new CreateMethodJavaHint(unresolvedElement, clazz));
                }
            }
        } else if (isStaticMethodCall) {
            JavaHintsProvider.addImportVariants(utils, resource, symbol, result);
        }
    }

    private static void addImportVariants(JMIUtils utils, Resource resource, String className, List result) {
        List classes = JavaHintsProvider.findClasses(utils, className, JavaHintsProvider.getTopJavaClass(resource));
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            JavaClass c = (JavaClass)it.next();
            ImportJavaHint importHint = new ImportJavaHint(resource, c);
            if (result.contains((Object)importHint)) continue;
            result.add(0, importHint);
        }
    }

    private static JavaClass getTopJavaClass(Resource res) {
        Iterator cls;
        if (res != null && (cls = res.getClassifiers().iterator()).hasNext()) {
            return (JavaClass)cls.next();
        }
        return null;
    }

    private static boolean isReadOnly(Resource res) {
        return res == null || (res.getStatus() & Integer.MIN_VALUE) != 0 || !JavaMetamodel.getManager().getFileObject(res).canWrite();
    }

    public void resourceParsed(Resource rsc) {
        DataObject od = JavaMetamodel.getManager().getDataObject(rsc);
        if (od != null) {
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            this.firePropertyChangeEvent("refresh", null, ec.getDocument());
        }
    }

    public static List findClasses(JMIUtils utils, String name, JavaClass context) {
        TreeSet<JavaClass> ret = new TreeSet<JavaClass>(utils.getNaturalMemberNameComparator());
        ClassPath cp = JavaMetamodel.getManager().getClassPath();
        FileObject[] cpRoots = cp.getRoots();
        for (int i = 0; i < cpRoots.length; ++i) {
            if (!$assertionsDisabled && cpRoots[i] == null) {
                throw new AssertionError((Object)"Classpath root is null");
            }
            ClassIndex ci = ClassIndex.getIndex((JavaModelPackage)JavaModel.getJavaExtent((FileObject)cpRoots[i]));
            if (ci == null) {
                ErrorManager.getDefault().log(1, "Index not found for " + cpRoots[i]);
                continue;
            }
            Iterator it = ci.getClassesBySimpleName(name).iterator();
            while (it.hasNext()) {
                JavaClass javaClass = (JavaClass)it.next();
                if (javaClass.isInner() || !utils.isAccessible((ClassDefinition)javaClass, context)) continue;
                ret.add(javaClass);
            }
        }
        return new ArrayList(ret);
    }

    public static int getErrorOffset(Document doc, ErrorInfo error) {
        Element lineRoot = ((BaseDocument)doc).getParagraphElement(0).getParentElement();
        Element line = lineRoot.getElement(error.getLineNumber() - 1);
        String s = null;
        int lineOffset = line.getStartOffset();
        try {
            s = doc.getText(lineOffset, line.getEndOffset() - lineOffset);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        int origColumn = error.getColumn() - 1;
        int column = 0;
        int newColumn = 0;
        while (column < origColumn) {
            column = s.charAt(newColumn) == '\t' ? column / 8 * 8 + 8 : ++column;
            ++newColumn;
        }
        return lineOffset + newColumn;
    }

    private static NamedElement getElementByOffset(Resource resource, int offset, String symbol) {
        org.netbeans.jmi.javamodel.Element el = resource.getElementByOffset(offset);
        int index = symbol.indexOf(40);
        if (index != -1) {
            symbol = symbol.substring(0, index);
        }
        int i = 0;
        while (i < 2) {
            NamedElement nel;
            if (el instanceof NamedElement && symbol.equals((nel = (NamedElement)el).getName())) {
                return nel;
            }
            ++i;
            el = (org.netbeans.jmi.javamodel.Element)el.refImmediateComposite();
        }
        return null;
    }

    static {
        $assertionsDisabled = !JavaHintsProvider.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
        creators = new HintCreator[]{new UnreportedExceptionHintCreator(), new IncompatibleTypesHintCreator(), new IncorrectArgumentsHintCreator(), new ImplementAbstractMethodsHintCreator(), new ImplementAbstractMethods2HintCreator(), new InitializeVariableHintCreator(), new UnresolvedSymbolCreator(), new UnresolvedSymbolCreatorNoLocation(), new PackageDoesNotExistCreator()};
        fieldHintCreators = new FieldHintCreator[0];
        methodHintCreators = new MethodHintCreator[0];
    }

    private static class PackageDoesNotExistCreator
    extends HintCreator {
        private PackageDoesNotExistCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.DOESNT_EXIST;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            JavaHintsProvider.addImportVariants(utils, resource, (String)error.getArguments().get(0), result);
        }
    }

    private static class UnresolvedSymbolCreatorNoLocation
    extends HintCreator {
        private UnresolvedSymbolCreatorNoLocation() {
        }

        public String getErrorId() {
            return JavaHintsProvider.CANT_RESOLVE;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            JavaHintsProvider.addImportVariants(utils, resource, (String)error.getArguments().get(1), result);
        }
    }

    private static class UnresolvedSymbolCreator
    extends HintCreator {
        private UnresolvedSymbolCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.CANT_RESOLVE_LOCATION;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            List invParams;
            int paramCount;
            NewClassExpression expr;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            List arguments = error.getArguments();
            String type = (String)arguments.get(0);
            String invName = (String)arguments.get(1);
            String className = (String)arguments.get(5);
            if (!JavaHintsProvider.KINDNAME_VARIABLE.equals(type) && !JavaHintsProvider.KINDNAME_CONSTRUCTOR.equals(type)) {
                JavaHintsProvider.addImportVariants(utils, resource, invName, result);
            }
            JavaClass clazz = utils.getExactClass(className);
            if (JavaHintsProvider.KINDNAME_METHOD.equals(type)) {
                MethodInvocation inv;
                List invParams2;
                int paramCount2;
                NamedElement el = JavaHintsProvider.getElementByOffset(resource, JavaHintsProvider.getErrorOffset(doc, error), invName);
                if (el != null && el instanceof MethodInvocation && (paramCount2 = (invParams2 = (inv = (MethodInvocation)el).getParameters()).size()) > 0) {
                    clazz = this.getParentClass(inv);
                    List methods = DeclarationInfo.getMethodsByNameAndParamCount((ClassDefinition)clazz, invName, paramCount2);
                    ClassDefinition invClass = DeclarationInfo.getContainingClass((org.netbeans.jmi.javamodel.Element)inv);
                    Iterator it = methods.iterator();
                    while (it.hasNext()) {
                        Method m = (Method)it.next();
                        if (!DeclarationInfo.isFeatureAccessibleFrom((Feature)m, invClass, (Expression)inv.getParentClass())) continue;
                        this.checkParamsAndAddHint(invParams2, m.getParameters(), result);
                    }
                }
            } else if (JavaHintsProvider.KINDNAME_CONSTRUCTOR.equals(type) && (expr = (NewClassExpression)JavaHintsProvider.getElementByOffset(resource, JavaHintsProvider.getErrorOffset(doc, error), invName)) != null && (paramCount = (invParams = expr.getParameters()).size()) != 0) {
                clazz = (ClassDefinition)expr.getClassName().getElement();
                List constructors = DeclarationInfo.getConstructorsByParamCount((ClassDefinition)clazz, paramCount);
                ClassDefinition newExprClass = DeclarationInfo.getContainingClass((org.netbeans.jmi.javamodel.Element)expr);
                Iterator it = constructors.iterator();
                while (it.hasNext()) {
                    Constructor c = (Constructor)it.next();
                    if (!DeclarationInfo.isFeatureAccessibleFrom((Feature)c, newExprClass, null)) continue;
                    this.checkParamsAndAddHint(invParams, c.getParameters(), result);
                }
            }
            String typeString = (String)arguments.get(0);
            String symbol = (String)arguments.get(1);
            String params = (String)arguments.get(2);
            boolean isVariable = JavaHintsProvider.KINDNAME_VARIABLE.equals(typeString);
            boolean isMethod = JavaHintsProvider.KINDNAME_METHOD.equals(typeString);
            boolean isStaticMethodCall = false;
            boolean isField = false;
            BaseDocument bd = (BaseDocument)doc;
            int errorOffset = JavaHintsProvider.getErrorOffset(doc, error);
            if (isVariable) {
                Element le = bd.getParagraphElement(errorOffset);
                String line = null;
                try {
                    int so = le.getStartOffset();
                    line = doc.getText(so, le.getEndOffset() - so - 1);
                }
                catch (BadLocationException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                if (line != null) {
                    isStaticMethodCall = line.indexOf(symbol + ".") != -1;
                    boolean bl = isField = !isStaticMethodCall;
                }
            }
            if (isField || isMethod || isStaticMethodCall) {
                JavaHintsProvider.handleUnresolvedHints(utils, resource, errorOffset, (ClassDefinition)clazz, symbol, isField, isMethod, isStaticMethodCall, result);
            }
        }

        private ClassDefinition getParentClass(MethodInvocation inv) {
            PrimaryExpression parent = inv.getParentClass();
            ClassDefinition clazz = parent != null ? (ClassDefinition)parent.getType() : JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)inv).getDeclaringClass();
            if (inv.isHasSuper()) {
                clazz = clazz.getSuperClass();
            }
            return clazz;
        }

        private void checkParamsAndAddHint(List invParams, List actualParams, List result) {
            int index = -1;
            int sz = invParams.size();
            for (int i = 0; i < sz; ++i) {
                Expression invParamI = (Expression)invParams.get(i);
                Parameter actualParamI = (Parameter)actualParams.get(i);
                if (DeclarationInfo.isAssignableFrom(actualParamI.getType(), invParamI.getType())) continue;
                if (index != -1) {
                    return;
                }
                index = i;
            }
            if (index != -1) {
                Type correctType = ((Parameter)actualParams.get(index)).getType();
                Expression wrongExpr = (Expression)invParams.get(index);
                IncompatibleTypesHintCreator.addCastHint(correctType, wrongExpr, result);
            }
        }
    }

    public static class IncorrectArgumentsHintCreator
    extends HintCreator {
        public String getErrorId() {
            return JavaHintsProvider.CANT_APPLY_SYMBOL;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            List arg = error.getArguments();
            String methodName = (String)arg.get(0);
            int left = methodName.indexOf(40);
            if (left != -1) {
                methodName = methodName.substring(0, left);
            }
            String className = (String)arg.get(1);
            String arguments = (String)arg.get(3);
            boolean isMethod = !className.endsWith("." + methodName);
            boolean isStaticMethodCall = false;
            BaseDocument bd = (BaseDocument)doc;
            if (!isMethod && !isStaticMethodCall) {
                return;
            }
            JavaClass clazz = utils.getExactClass(className);
            if (clazz == null) {
                return;
            }
            int errorOffset = JavaHintsProvider.getErrorOffset(doc, error);
            IncorrectArgumentsHintCreator.addCastsOrInvokeMethods(resource, (ClassDefinition)clazz, doc, errorOffset, methodName, arguments, result);
            JavaHintsProvider.handleUnresolvedHints(utils, resource, errorOffset, (ClassDefinition)clazz, methodName, false, isMethod, isStaticMethodCall, result);
        }

        private static void addCastsOrInvokeMethods(Resource res, ClassDefinition clazz, Document doc, int errorOffset, String methodName, String expectedArgs, List result) {
            StringTokenizer tokExp = new StringTokenizer(expectedArgs, ",");
            String[] expectedTypeNames = new String[tokExp.countTokens()];
            for (int i = 0; i < expectedTypeNames.length; ++i) {
                expectedTypeNames[i] = tokExp.nextToken();
            }
            Method f = DeclarationInfo.getMethodByNameAndParamTypeNames(clazz, methodName, expectedTypeNames);
            Invocation inv = (Invocation)JavaHintsProvider.getElementByOffset(res, errorOffset, methodName);
            if (inv != null && f != null) {
                Parameter[] expectedParams;
                Expression[] invParams = inv.getParameters().toArray(new Expression[0]);
                if (invParams.length != (expectedParams = f.getParameters().toArray(new Parameter[0])).length) {
                    return;
                }
                for (int i = 0; i < invParams.length; ++i) {
                    Type invType = invParams[i].getType();
                    Type expType = expectedParams[i].getType();
                    if (invType == null || expType == null || expType.getName().equals(invType.getName())) continue;
                    IncompatibleTypesHintCreator.addCastHint(expType, invParams[i], result);
                }
            }
        }
    }

    private static class ImplementAbstractMethods2HintCreator
    extends HintCreator {
        private ImplementAbstractMethods2HintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.ABSTRACT_CANT_BE_INSTANTIATED;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            JavaClass clazz;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            if (ERR.isLoggable(1)) {
                ERR.log("pontentially unimplemented methods from: " + error.getArguments().get(0));
            }
            int errorOffset = JavaHintsProvider.getErrorOffset(doc, error);
            NewClassExpression expression = (NewClassExpression)resource.getElementByOffset(errorOffset);
            JavaMetamodel.getManager().setClassPath(JavaModel.getFileObject((Resource)resource), true);
            Type t = ((JavaModelPackage)resource.refImmediatePackage()).getType().resolve((String)error.getArguments().get(0));
            JavaClass javaClass = clazz = t instanceof JavaClass ? (JavaClass)t : null;
            if (ERR.isLoggable(1)) {
                ERR.log("expression=" + expression);
                ERR.log("clazz=" + clazz);
            }
            if (expression != null && clazz != null) {
                ArrayList<Method> unimplementedMethods = new ArrayList<Method>();
                Iterator methods = clazz.getContents().iterator();
                while (methods.hasNext()) {
                    int modifiers;
                    Feature f = (Feature)methods.next();
                    if (!(f instanceof Method)) continue;
                    Method method = (Method)f;
                    if (ERR.isLoggable(1)) {
                        ERR.log("method=" + method);
                    }
                    if (!Modifier.isInterface(modifiers = method.getModifiers()) && !Modifier.isAbstract(modifiers)) continue;
                    if (ERR.isLoggable(1)) {
                        ERR.log("is abstract");
                    }
                    unimplementedMethods.add(method);
                }
                if (!unimplementedMethods.isEmpty()) {
                    if (ERR.isLoggable(1)) {
                        ERR.log("unimplementedMethods=" + unimplementedMethods);
                    }
                    result.add(new ImplementMethodJavaHint2(expression, unimplementedMethods));
                }
            }
        }
    }

    private static class ImplementAbstractMethodsHintCreator
    extends HintCreator {
        private ImplementAbstractMethodsHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.DOES_NOT_OVERRIDE_ABSTRACT;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            List arguments = error.getArguments();
            String subClassName = (String)arguments.get(0);
            String className = (String)arguments.get(2);
            if (className.equals(subClassName)) {
                Type t = JavaModel.getDefaultExtent().getType().resolve(className);
                if (t instanceof JavaClass) {
                    result.add(new MakeClassAbstractJavaHint((JavaClass)t));
                }
                return;
            }
            JavaMetamodel.getManager().setClassPath(JavaModel.getFileObject((Resource)resource), true);
            int errorOffset = JavaHintsProvider.getErrorOffset(doc, error);
            org.netbeans.jmi.javamodel.Element e = resource.getElementByOffset(errorOffset);
            if (e != null && e instanceof ClassDefinition) {
                List methods;
                ClassDefinition def = (ClassDefinition)e;
                String name = def.getName();
                if (name == null) {
                    List list = def.getInterfaces();
                    JavaClass jc = list.size() > 0 ? (JavaClass)list.get(0) : def.getSuperClass();
                    if (jc instanceof ParameterizedType) {
                        jc = ((ParameterizedType)jc).getDefinition();
                    }
                    name = jc.getName();
                    subClassName = className;
                }
                if (name.equals(subClassName) && !(methods = DeclarationInfo.getAbstractMethods(def)).isEmpty()) {
                    result.add(new ImplementMethodJavaHint(def, methods));
                }
            }
            JavaModel.setClassPath((Resource)resource);
        }
    }

    private static class IncompatibleTypesHintCreator
    extends HintCreator {
        private IncompatibleTypesHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.INCOMPATIBLE_TYPES;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            int errorOffset;
            org.netbeans.jmi.javamodel.Element errElement;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            if (ERR.isLoggable(1)) {
                ERR.log("potentially missing cast");
            }
            if ((errElement = resource.getElementByOffset(errorOffset = JavaHintsProvider.getErrorOffset(doc, error))) instanceof ConditionalExpression) {
                Type t = DeclarationInfo.computeType(errElement);
                ConditionalExpression expr = (ConditionalExpression)errElement;
                IncompatibleTypesHintCreator.addCastHint(t, expr.getTruePart(), result);
                IncompatibleTypesHintCreator.addCastHint(t, expr.getFalsePart(), result);
            } else if (errElement instanceof Expression) {
                Type t = DeclarationInfo.computeType(errElement);
                IncompatibleTypesHintCreator.addCastHint(t, (Expression)errElement, result);
            }
        }

        public static void addCastHint(Type toType, Expression castedElement, List result) {
            Type fromType = castedElement.getType();
            if (ERR.isLoggable(1)) {
                ERR.log("toType=" + toType);
                ERR.log("fromType=" + fromType);
            }
            if (toType instanceof ClassDefinition && fromType instanceof ClassDefinition) {
                ClassDefinition toClass = (ClassDefinition)toType;
                ClassDefinition fromClass = (ClassDefinition)fromType;
                if (ERR.isLoggable(1)) {
                    ERR.log("toClass=" + toClass.getName());
                    ERR.log("fromClass=" + fromClass.getName());
                }
                if (!fromClass.isSubTypeOf(toClass) && DeclarationInfo.canbeCastTo((Type)fromClass, (Type)toClass)) {
                    result.add(new AddCastJavaHint(IncompatibleTypesHintCreator.getElementName((org.netbeans.jmi.javamodel.Element)castedElement), toClass, castedElement));
                }
            }
        }

        private static String getElementName(org.netbeans.jmi.javamodel.Element elem) {
            String elementName;
            if (elem instanceof Invocation) {
                Invocation i = (Invocation)elem;
                elementName = i.getName();
                elementName = i.getParameters().isEmpty() ? elementName + "()" : elementName + "(...)";
                if (elem instanceof NewClassExpression) {
                    elementName = "new " + elementName;
                } else if (elem instanceof MethodInvocation) {
                    elementName = "..." + elementName;
                }
            } else {
                elementName = elem instanceof NamedElement ? "..." + ((NamedElement)elem).getName() : (elem instanceof ThisExpression ? "this" : (elem instanceof StringLiteral ? ((StringLiteral)elem).getValue() : (elem instanceof BooleanLiteral ? String.valueOf(((BooleanLiteral)elem).isValue()) : (elem instanceof CharLiteral ? "'" + ((CharLiteral)elem).getValue() + "'" : (elem instanceof DoubleLiteral ? String.valueOf(((DoubleLiteral)elem).getValue()) + "d" : (elem instanceof FloatLiteral ? String.valueOf(((FloatLiteral)elem).getValue()) + "f" : (elem instanceof IntLiteral ? String.valueOf(((IntLiteral)elem).getValue()) : (elem instanceof LongLiteral ? String.valueOf(((LongLiteral)elem).getValue()) + "l" : (elem instanceof NullLiteral ? "null" : (elem instanceof ArrayAccess ? IncompatibleTypesHintCreator.getElementName((org.netbeans.jmi.javamodel.Element)((ArrayAccess)elem).getArray()) + "[]" : "..."))))))))));
            }
            return elementName;
        }
    }

    private static class UnreportedExceptionHintCreator
    extends HintCreator {
        private UnreportedExceptionHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.UNREPORTED_EXCEPTION_ERROR;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            CallableFeature cf;
            if (JavaHintsProvider.isReadOnly(resource)) {
                return;
            }
            JavaClass def = utils.getExactClass((String)error.getArguments().get(0));
            int errorOffset = JavaHintsProvider.getErrorOffset(doc, error);
            org.netbeans.jmi.javamodel.Element el = resource.getElementByOffset(errorOffset);
            Feature f = JavaModelUtil.getDeclaringFeature((org.netbeans.jmi.javamodel.Element)el);
            CallableFeature callableFeature = cf = f instanceof CallableFeature ? (CallableFeature)f : null;
            if (cf != null) {
                if (def != null && def instanceof JavaClass) {
                    cf = (CallableFeature)f;
                    result.add(new AddThrowsClauseJavaHint(cf, def));
                }
                try {
                    result.add(new TryWrapperJavaHint(doc.createPosition(errorOffset), cf));
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
    }

    private static class InitializeVariableHintCreator
    extends HintCreator {
        private InitializeVariableHintCreator() {
        }

        public String getErrorId() {
            return JavaHintsProvider.VAR_MIGHT_NOT_HAVE_BEEN_INITIALIZED;
        }

        public void createHint(JMIUtils utils, Resource resource, Document doc, ErrorInfo error, List result) {
            String varName = (String)error.getArguments().get(0);
            VariableAccess access = (VariableAccess)JavaHintsProvider.getElementByOffset(resource, JavaHintsProvider.getErrorOffset(doc, error), varName);
            if (access != null && varName.equals(access.getName())) {
                result.add(new InitializeVariableHint(access));
            }
        }
    }

    private static abstract class MethodHintCreator {
        private MethodHintCreator() {
        }

        public abstract void createHint(JMIUtils var1, Resource var2, Document var3, Method var4, int var5, List var6);
    }

    private static abstract class FieldHintCreator {
        private FieldHintCreator() {
        }

        public abstract void createHint(JMIUtils var1, Resource var2, Document var3, Field var4, int var5, List var6);
    }

    private static abstract class HintCreator {
        private HintCreator() {
        }

        public abstract String getErrorId();

        public abstract void createHint(JMIUtils var1, Resource var2, Document var3, ErrorInfo var4, List var5);
    }
}

