/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.toplink.essentials.internal.localization.i18n.LoggingLocalizationResource;
import oracle.toplink.essentials.internal.localization.i18n.TraceLocalizationResource;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLogEntry;
import oracle.toplink.essentials.logging.TopLinkLogRecord;
import oracle.toplink.essentials.sessions.Session;

public class JavaLog
extends AbstractSessionLog {
    protected static final String DEFAULT_SESSION_NAME = "defaultsessionname";
    public static final String DEFAULT_TOPLINK_NAMESPACE = "oracle.toplink.essentials";
    protected static final String LOGGING_LOCALIZATION_STRING = "oracle.toplink.essentials.internal.localization.i18n.LoggingLocalizationResource";
    protected static final String TRACE_LOCALIZATION_STRING = "oracle.toplink.essentials.internal.localization.i18n.TraceLocalizationResource";
    private static final Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private static Logger defaultTopLinkLogger = Logger.getLogger("oracle.toplink.essentials");
    private Map nameSpaceMap = new HashMap();
    private String sessionNameSpace;
    private Logger sessionLogger;
    private Map catagoryloggers = new HashMap();

    public int getLevel(String category) {
        Logger logger;
        for (logger = this.getLogger(category); logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return 8;
        }
        int logLevel = logger.getLevel().intValue();
        for (int i = 0; i < levels.length; ++i) {
            if (logLevel != levels[i].intValue()) continue;
            return i;
        }
        return 8;
    }

    public void setLevel(final int level, String category) {
        final Logger logger = this.getLogger(category);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(JavaLog.this.getJavaLevel(level));
                return null;
            }
        });
    }

    protected String getNameSpaceString(String category) {
        if (this.session == null) {
            return DEFAULT_TOPLINK_NAMESPACE;
        }
        if (category == null || category.length() == 0) {
            return this.sessionNameSpace;
        }
        return (String)this.nameSpaceMap.get(category);
    }

    protected Logger getLogger(String category) {
        if (this.session == null) {
            return defaultTopLinkLogger;
        }
        if (category == null || category.length() == 0) {
            return this.sessionLogger;
        }
        Logger logger = (Logger)this.catagoryloggers.get(category);
        assert (logger != null);
        return logger;
    }

    public void setSession(Session session) {
        super.setSession(session);
        if (session != null) {
            String sessionName = session.getName() != null && session.getName().length() != 0 ? session.getName() : DEFAULT_SESSION_NAME;
            this.sessionNameSpace = "oracle.toplink.essentials." + sessionName;
            this.sessionLogger = Logger.getLogger(this.sessionNameSpace);
            for (int i = 0; i < loggerCatagories.length; ++i) {
                String loggerCatagory = loggerCatagories[i];
                String loggerNameSpace = this.sessionNameSpace + "." + loggerCatagory;
                this.nameSpaceMap.put(loggerCatagory, loggerNameSpace);
                this.catagoryloggers.put(loggerCatagory, Logger.getLogger(loggerNameSpace));
            }
        }
    }

    private Level getJavaLevel(int level) {
        return levels[level];
    }

    public boolean shouldLog(int level, String category) {
        Logger logger = this.getLogger(category);
        return logger.isLoggable(this.getJavaLevel(level));
    }

    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(entry.getNameSpace());
        Level javaLevel = this.getJavaLevel(entry.getLevel());
        this.internalLog(entry, javaLevel, logger);
    }

    protected void internalLog(SessionLogEntry entry, Level javaLevel, Logger logger) {
        TopLinkLogRecord lr = new TopLinkLogRecord(javaLevel, entry.getMessage());
        lr.setSourceClassName(null);
        lr.setSourceMethodName(null);
        lr.setParameters(entry.getParameters());
        lr.setLoggerName(this.getNameSpaceString(entry.getNameSpace()));
        if (entry.shouldTranslate()) {
            ListResourceBundle resourceBundle;
            String bundleName;
            if (entry.getLevel() > 3) {
                bundleName = LOGGING_LOCALIZATION_STRING;
                resourceBundle = new LoggingLocalizationResource();
            } else {
                bundleName = TRACE_LOCALIZATION_STRING;
                resourceBundle = new TraceLocalizationResource();
            }
            lr.setResourceBundleName(bundleName);
            lr.setResourceBundle(resourceBundle);
        }
        if (this.shouldPrintSession()) {
            lr.setSessionString(this.getSessionString(entry.getSession()));
        }
        if (this.shouldPrintConnection()) {
            lr.setConnection(entry.getConnection());
        }
        lr.setThrown(entry.getException());
        lr.setShouldLogExceptionStackTrace(this.shouldLogExceptionStackTrace());
        lr.setShouldPrintDate(this.shouldPrintDate());
        lr.setShouldPrintThread(this.shouldPrintThread());
        logger.log(lr);
    }

    public void throwing(Throwable throwable) {
        this.getLogger(null).throwing(null, null, throwable);
    }

    public Object clone() {
        JavaLog cloneLog = (JavaLog)super.clone();
        return cloneLog;
    }
}

