/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SimpleConditionalExpressionNode;
import oracle.toplink.essentials.internal.parsing.SubqueryNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class InNode
extends SimpleConditionalExpressionNode {
    private List theObjects = null;
    private boolean notIndicated = false;

    public void addNodeToTheObjects(Node theNode) {
        this.getTheObjects().add(theNode);
    }

    public void validate(ParseTreeContext context) {
        Object leftType = null;
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            leftType = this.left.getType();
        }
        for (Node node : this.getTheObjects()) {
            node.validate(context);
            node.validateParameter(context, leftType);
            Object nodeType = node.getType();
            if (leftType == null || typeHelper.isAssignableFrom(leftType, nodeType)) continue;
            throw EJBQLException.invalidExpressionArgument("IN", node.getAsString(), typeHelper.getTypeName(leftType));
        }
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        List arguments = this.getTheObjects();
        Node firstArg = (Node)arguments.get(0);
        if (firstArg.isSubqueryNode()) {
            SubqueryNode subqueryNode = (SubqueryNode)firstArg;
            ReportQuery reportQuery = subqueryNode.getReportQuery(context);
            whereClause = this.notIndicated() ? whereClause.notIn(reportQuery) : whereClause.in(reportQuery);
        } else {
            Vector<Expression> inArguments = new Vector<Expression>(arguments.size());
            for (Node nextNode : arguments) {
                inArguments.add(nextNode.generateExpression(context));
            }
            if (inArguments.size() > 0) {
                whereClause = this.notIndicated() ? whereClause.notIn(inArguments) : whereClause.in(inArguments);
            }
        }
        return whereClause;
    }

    public List getTheObjects() {
        if (this.theObjects == null) {
            this.setTheObjects(new Vector());
        }
        return this.theObjects;
    }

    public void setTheObjects(List newTheObjects) {
        this.theObjects = newTheObjects;
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }
}

