/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class ProjectAction
extends LookupSensitiveAction
implements Presenter.Menu,
ContextAwareAction {
    private String command;
    private ProjectActionPerformer performer;
    private String namePattern;
    private String presenterName;
    private JMenuItem menuPresenter;

    public ProjectAction(String command, String namePattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, icon, lookup);
    }

    public ProjectAction(ProjectActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, icon, lookup);
    }

    private ProjectAction(String command, ProjectActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = command;
        if (command != null) {
            ActionsUtil.SHORCUTS_MANAGER.registerAction(command, this);
        }
        this.performer = performer;
        this.namePattern = namePattern;
        this.presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    public void putValue(String key, Object value) {
        super.putValue(key, value);
        if (key == "AcceleratorKey") {
            ActionsUtil.SHORCUTS_MANAGER.registerShortcut(this.command, value);
            if (this.menuPresenter != null) {
                this.menuPresenter.setAccelerator((KeyStroke)value);
            }
        }
    }

    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.command);
        if (projects.length == 1) {
            if (this.command != null) {
                ActionProvider ap = (ActionProvider)projects[0].getLookup().lookup(ActionProvider.class);
                ap.invokeAction(this.command, Lookup.EMPTY);
            } else if (this.performer != null) {
                this.performer.perform(projects[0]);
            }
        }
    }

    protected void refresh(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.command);
        if (this.command != null) {
            this.setEnabled(projects.length == 1);
            this.presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projects);
        } else if (this.performer != null && projects.length == 1) {
            this.setEnabled(this.performer.enable(projects[0]));
            this.presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projects);
        } else {
            this.setEnabled(false);
            this.presenterName = ActionsUtil.formatProjectSensitiveName(this.namePattern, projects);
        }
        this.setLocalizedTextToMenuPresented(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    protected final void setLocalizedTextToMenuPresented(String presenterName) {
        if (this.menuPresenter != null) {
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)presenterName);
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menuPresenter == null) {
            this.menuPresenter = new JMenuItem(this);
            Icon icon = null;
            if (!Boolean.TRUE.equals(this.getValue("noIconInMenu"))) {
                icon = (Icon)this.getValue("SmallIcon");
            }
            this.menuPresenter.setIcon(icon);
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)this.presenterName);
        }
        return this.menuPresenter;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ProjectAction(this.command, this.performer, this.namePattern, (Icon)this.getValue("SmallIcon"), actionContext);
    }
}

