/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.editor.bookmarks.FileBookmarks;
import org.netbeans.modules.editor.bookmarks.FileBookmarksMap;
import org.openide.ErrorManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class BookmarksXMLHandler {
    static final String EDITOR_BOOKMARKS_NAMESPACE_URI = "http://www.netbeans.org/ns/editor-bookmarks/1";
    static final String EDITOR_BOOKMARKS_ELEM = "editor-bookmarks";
    private static final String FILE_ELEM = "file";
    private static final String URL_ELEM = "url";
    private static final String LINE_ELEM = "line";
    static final /* synthetic */ boolean $assertionsDisabled;

    private BookmarksXMLHandler() {
    }

    public static void loadFileBookmarksMap(FileBookmarksMap fileBookmarksMap, Element bookmarksElem, URL baseURL) {
        Node fileElem = BookmarksXMLHandler.skipNonElementNode(bookmarksElem.getFirstChild());
        while (fileElem != null) {
            if (!$assertionsDisabled && !FILE_ELEM.equals(fileElem.getNodeName())) {
                throw new AssertionError();
            }
            Node urlElem = BookmarksXMLHandler.skipNonElementNode(fileElem.getFirstChild());
            if (!$assertionsDisabled && !URL_ELEM.equals(urlElem.getNodeName())) {
                throw new AssertionError();
            }
            Node lineElem = BookmarksXMLHandler.skipNonElementNode(urlElem.getNextSibling());
            int[] lineIndexesArray = new int[1];
            int lineCount = 0;
            while (lineElem != null) {
                if (!$assertionsDisabled && !LINE_ELEM.equals(lineElem.getNodeName())) {
                    throw new AssertionError();
                }
                if (lineCount == lineIndexesArray.length) {
                    lineIndexesArray = BookmarksXMLHandler.reallocateIntArray(lineIndexesArray, lineCount, lineCount << 1);
                }
                try {
                    Node lineElemText = lineElem.getFirstChild();
                    String lineNumberString = lineElemText.getNodeValue();
                    int lineNumber = Integer.parseInt(lineNumberString);
                    lineIndexesArray[lineCount++] = lineNumber;
                }
                catch (DOMException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                catch (NumberFormatException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                lineElem = BookmarksXMLHandler.skipNonElementNode(lineElem.getNextSibling());
            }
            try {
                URL url;
                try {
                    Node urlElemText = urlElem.getFirstChild();
                    String relOrAbsURLString = urlElemText.getNodeValue();
                    URI uri = new URI(relOrAbsURLString);
                    url = !uri.isAbsolute() && baseURL != null ? new URL(baseURL, relOrAbsURLString) : new URL(relOrAbsURLString);
                }
                catch (URISyntaxException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    url = null;
                }
                catch (MalformedURLException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    url = null;
                }
                if (url != null) {
                    if (lineCount != lineIndexesArray.length) {
                        lineIndexesArray = BookmarksXMLHandler.reallocateIntArray(lineIndexesArray, lineCount, lineCount);
                    }
                    fileBookmarksMap.put(new FileBookmarks(url, lineIndexesArray));
                }
            }
            catch (DOMException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            fileElem = BookmarksXMLHandler.skipNonElementNode(fileElem.getNextSibling());
        }
    }

    private static Node skipNonElementNode(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return node;
    }

    public static Element saveFileBookmarksMap(FileBookmarksMap fileBookmarksMap, URI baseURI) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmlDoc = builder.newDocument();
            Element bookmarksElem = xmlDoc.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, EDITOR_BOOKMARKS_ELEM);
            Iterator it = fileBookmarksMap.all().iterator();
            while (it.hasNext()) {
                FileBookmarks bookmarks = (FileBookmarks)it.next();
                if (bookmarks.getBookmarkCount() <= 0) continue;
                BookmarksXMLHandler.saveFileBookmarks(bookmarks, xmlDoc, bookmarksElem, baseURI);
            }
            return bookmarksElem;
        }
        catch (ParserConfigurationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    private static void saveFileBookmarks(FileBookmarks fileBookmarks, Document xmlDoc, Element bookmarksElem, URI baseURI) throws DOMException {
        Element fileElem = xmlDoc.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, FILE_ELEM);
        Element urlElem = xmlDoc.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, URL_ELEM);
        String relOrAbsURL = fileBookmarks.getURL().toExternalForm();
        if (baseURI != null) {
            try {
                URI absURI = new URI(relOrAbsURL);
                URI relURI = baseURI.relativize(absURI);
                relOrAbsURL = relURI.toString();
            }
            catch (URISyntaxException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        urlElem.appendChild(xmlDoc.createTextNode(relOrAbsURL));
        fileElem.appendChild(urlElem);
        int bookmarkCount = fileBookmarks.getBookmarkCount();
        for (int i = 0; i < bookmarkCount; ++i) {
            int bookmarkLine = fileBookmarks.getBookmarkLineIndex(i);
            Element lineElem = xmlDoc.createElementNS(EDITOR_BOOKMARKS_NAMESPACE_URI, LINE_ELEM);
            lineElem.appendChild(xmlDoc.createTextNode(Integer.toString(bookmarkLine)));
            fileElem.appendChild(lineElem);
        }
        bookmarksElem.appendChild(fileElem);
    }

    static int[] reallocateIntArray(int[] intArray, int count, int newLength) {
        int[] newIntArray = new int[newLength];
        System.arraycopy(intArray, 0, newIntArray, 0, count);
        return newIntArray;
    }

    static {
        $assertionsDisabled = !BookmarksXMLHandler.class.desiredAssertionStatus();
    }
}

