/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openidex.search.CompoundSearchInfo;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SharabilityFilter;
import org.openidex.search.SimpleSearchInfo;
import org.openidex.search.SubnodesSearchInfo;
import org.openidex.search.VisibilityFilter;

public final class SearchInfoFactory {
    public static final FileObjectFilter VISIBILITY_FILTER = new VisibilityFilter();
    public static final FileObjectFilter SHARABILITY_FILTER = new SharabilityFilter();

    private SearchInfoFactory() {
    }

    public static SearchInfo createSearchInfo(FileObject folder, boolean recursive, FileObjectFilter[] filters) {
        if (!folder.isFolder()) {
            throw new IllegalArgumentException("folder expected");
        }
        return new SimpleSearchInfo(DataFolder.findFolder((FileObject)folder), recursive, filters);
    }

    public static SearchInfo createSearchInfo(FileObject[] folders, boolean recursive, FileObjectFilter[] filters) {
        if (folders.length == 0) {
            return SimpleSearchInfo.EMPTY_SEARCH_INFO;
        }
        if (folders.length == 1) {
            return SearchInfoFactory.createSearchInfo(folders[0], recursive, filters);
        }
        for (int i = 0; i < folders.length; ++i) {
            if (folders[i].isFolder()) continue;
            throw new IllegalArgumentException("folder expected (index " + i + ')');
        }
        SearchInfo[] nested = new SearchInfo[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            nested[i] = SearchInfoFactory.createSearchInfo(folders[i], recursive, filters);
        }
        return new CompoundSearchInfo(nested);
    }

    public static SearchInfo createSearchInfoBySubnodes(Node node) {
        return new SubnodesSearchInfo(node);
    }
}

