/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public final class JDBCAccessLogValve
extends ValveBase
implements Lifecycle {
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected Driver driver = null;
    private String driverName = null;
    private String connectionURL = null;
    private String tableName = "access";
    private String remoteHostField = "remoteHost";
    private String userField = "userName";
    private String timestampField = "timestamp";
    private String virtualHostField = "virtualHost";
    private String methodField = "method";
    private String queryField = "query";
    private String statusField = "status";
    private String bytesField = "bytes";
    private String refererField = "referer";
    private String userAgentField = "userAgent";
    private String pattern = "common";
    private boolean resolveHosts = false;
    private Connection conn = null;
    private PreparedStatement ps = null;
    private long currentTimeMillis;
    protected static String info = "org.apache.catalina.valves.JDBCAccessLogValve/1.1";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    private boolean started = false;

    public JDBCAccessLogValve() {
        this.currentTimeMillis = new Date().getTime();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setRemoteHostField(String remoteHostField) {
        this.remoteHostField = remoteHostField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public void setVirtualHostField(String virtualHostField) {
        this.virtualHostField = virtualHostField;
    }

    public void setMethodField(String methodField) {
        this.methodField = methodField;
    }

    public void setQueryField(String queryField) {
        this.queryField = queryField;
    }

    public void setStatusField(String statusField) {
        this.statusField = statusField;
    }

    public void setBytesField(String bytesField) {
        this.bytesField = bytesField;
    }

    public void setRefererField(String refererField) {
        this.refererField = refererField;
    }

    public void setUserAgentField(String userAgentField) {
        this.userAgentField = userAgentField;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setResolveHosts(String resolveHosts) {
        this.resolveHosts = new Boolean(resolveHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        int bytes;
        this.getNext().invoke(request, response);
        String remoteHost = "";
        remoteHost = this.resolveHosts ? request.getRemoteHost() : request.getRemoteAddr();
        String user = "";
        if (request != null) {
            user = request.getRemoteUser();
        }
        String query = "";
        if (request != null) {
            query = request.getRequestURI();
        }
        if ((bytes = response.getContentCount()) < 0) {
            bytes = 0;
        }
        int status = response.getStatus();
        if (this.pattern.equals("combined")) {
            String virtualHost = "";
            if (request != null) {
                virtualHost = request.getServerName();
            }
            String method = "";
            if (request != null) {
                method = request.getMethod();
            }
            String referer = "";
            if (request != null) {
                referer = request.getHeader("referer");
            }
            String userAgent = "";
            if (request != null) {
                userAgent = request.getHeader("user-agent");
            }
        }
        JDBCAccessLogValve jDBCAccessLogValve = this;
        synchronized (jDBCAccessLogValve) {
            for (int numberOfTries = 2; numberOfTries > 0; --numberOfTries) {
                try {
                    this.open();
                    this.ps.setString(1, remoteHost);
                    this.ps.setString(2, user);
                    this.ps.setTimestamp(3, new Timestamp(this.getCurrentTimeMillis()));
                    this.ps.setString(4, query);
                    this.ps.setInt(5, status);
                    this.ps.setInt(6, bytes);
                    if (this.pattern.equals("combined")) {
                        String virtualHost = "";
                        if (request != null) {
                            virtualHost = request.getServerName();
                        }
                        String method = "";
                        if (request != null) {
                            method = request.getMethod();
                        }
                        String referer = "";
                        if (request != null) {
                            referer = request.getHeader("referer");
                        }
                        String userAgent = "";
                        if (request != null) {
                            userAgent = request.getHeader("user-agent");
                        }
                        this.ps.setString(7, virtualHost);
                        this.ps.setString(8, method);
                        this.ps.setString(9, referer);
                        this.ps.setString(10, userAgent);
                    }
                    this.ps.executeUpdate();
                    return;
                }
                catch (SQLException e) {
                    this.container.getLogger().error((Object)this.sm.getString("jdbcAccessLogValve.exception"), (Throwable)e);
                    if (this.conn == null) continue;
                    this.close();
                    continue;
                }
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    protected void open() throws SQLException {
        if (this.conn != null) {
            return;
        }
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                throw new SQLException(e.getMessage());
            }
        }
        Properties props = new Properties();
        props.put("autoReconnect", "true");
        if (this.connectionName != null) {
            props.put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            props.put("password", this.connectionPassword);
        }
        this.conn = this.driver.connect(this.connectionURL, props);
        this.conn.setAutoCommit(true);
        if (this.pattern.equals("common")) {
            this.ps = this.conn.prepareStatement("INSERT INTO " + this.tableName + " (" + this.remoteHostField + ", " + this.userField + ", " + this.timestampField + ", " + this.queryField + ", " + this.statusField + ", " + this.bytesField + ") VALUES(?, ?, ?, ?, ?, ?)");
        } else if (this.pattern.equals("combined")) {
            this.ps = this.conn.prepareStatement("INSERT INTO " + this.tableName + " (" + this.remoteHostField + ", " + this.userField + ", " + this.timestampField + ", " + this.queryField + ", " + this.statusField + ", " + this.bytesField + ", " + this.virtualHostField + ", " + this.methodField + ", " + this.refererField + ", " + this.userAgentField + ") VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.ps.close();
        }
        catch (Throwable f) {
            // empty catch block
        }
        this.ps = null;
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            this.container.getLogger().error((Object)this.sm.getString("jdbcAccessLogValeve.close"), (Throwable)e);
        }
        finally {
            this.conn = null;
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.open();
        }
        catch (SQLException e) {
            throw new LifecycleException((Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }

    public long getCurrentTimeMillis() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentTimeMillis > 1000L) {
            this.currentTimeMillis = new Date(systime).getTime();
        }
        return this.currentTimeMillis;
    }
}

