/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.io;

import java.io.IOException;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XByteBuffer {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$io$XByteBuffer == null ? (class$org$apache$catalina$cluster$io$XByteBuffer = XByteBuffer.class$("org.apache.catalina.cluster.io.XByteBuffer")) : class$org$apache$catalina$cluster$io$XByteBuffer));
    public static final byte[] START_DATA = new byte[]{70, 76, 84, 50, 48, 48, 50};
    public static final byte[] END_DATA = new byte[]{84, 76, 70, 50, 48, 48, 51};
    static final int DEF_SIZE = 1024;
    static final int DEF_EXT = 1024;
    protected byte[] buf = null;
    protected int bufSize = 0;
    static /* synthetic */ Class class$org$apache$catalina$cluster$io$XByteBuffer;

    public XByteBuffer(int size) {
        this.buf = new byte[size];
    }

    public XByteBuffer() {
        this(1024);
    }

    public byte[] getBytes() {
        byte[] b = new byte[this.bufSize];
        System.arraycopy(this.buf, 0, b, 0, this.bufSize);
        return b;
    }

    public void clear() {
        this.bufSize = 0;
    }

    public boolean append(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return false;
        }
        int newcount = this.bufSize + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufSize);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.bufSize, len);
        this.bufSize = newcount;
        if (this.bufSize > START_DATA.length && XByteBuffer.firstIndexOf(this.buf, 0, START_DATA) == -1) {
            this.bufSize = 0;
            log.error((Object)"Discarded the package, invalid header");
            return false;
        }
        return true;
    }

    public int countPackages() {
        int newpos;
        int size;
        int index;
        int cnt = 0;
        int pos = START_DATA.length;
        int start = 0;
        while (start < this.bufSize && (index = XByteBuffer.firstIndexOf(this.buf, start, START_DATA)) == start && this.bufSize - start >= 14 && (pos = start + START_DATA.length + 8 + (size = XByteBuffer.toInt(this.buf, pos + 4))) + END_DATA.length <= this.bufSize && (newpos = XByteBuffer.firstIndexOf(this.buf, pos, END_DATA)) == pos) {
            ++cnt;
            start = pos + END_DATA.length;
            pos = start + START_DATA.length;
        }
        return cnt;
    }

    public boolean doesPackageExist() {
        return this.countPackages() > 0;
    }

    public ClusterData extractPackage(boolean clearFromBuffer) throws IOException {
        int psize = this.countPackages();
        if (psize == 0) {
            throw new IllegalStateException("No package exists in XByteBuffer");
        }
        int compress = XByteBuffer.toInt(this.buf, START_DATA.length);
        int size = XByteBuffer.toInt(this.buf, START_DATA.length + 4);
        byte[] data = new byte[size];
        System.arraycopy(this.buf, START_DATA.length + 8, data, 0, size);
        ClusterData cdata = new ClusterData();
        cdata.setMessage(data);
        cdata.setCompress(compress);
        if (clearFromBuffer) {
            int totalsize = START_DATA.length + 8 + size + END_DATA.length;
            this.bufSize -= totalsize;
            System.arraycopy(this.buf, totalsize, this.buf, 0, this.bufSize);
        }
        return cdata;
    }

    public static int toInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static long toLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)n;
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static byte[] toBytes(long n) {
        byte[] b = new byte[8];
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static int firstIndexOf(byte[] src, int srcOff, byte[] find) {
        int result = -1;
        if (find.length > src.length) {
            return result;
        }
        if (find.length == 0 || src.length == 0) {
            return result;
        }
        if (srcOff >= src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean found = false;
        int srclen = src.length;
        int findlen = find.length;
        byte first = find[0];
        int pos = srcOff;
        while (!found) {
            while (pos < srclen && first != src[pos]) {
                ++pos;
            }
            if (pos >= srclen) {
                return -1;
            }
            if (srclen - pos < findlen) {
                return -1;
            }
            found = true;
            for (int i = 1; i < findlen && found; ++i) {
                found = found && find[i] == src[pos + i];
            }
            if (found) {
                result = pos;
                continue;
            }
            if (srclen - pos < findlen) {
                return -1;
            }
            ++pos;
        }
        return result;
    }

    public static byte[] createDataPackage(byte[] indata, int compressed) throws IOException {
        byte[] data = indata;
        byte[] comprdata = XByteBuffer.toBytes(compressed);
        int length = START_DATA.length + 4 + 4 + data.length + END_DATA.length;
        byte[] result = new byte[length];
        System.arraycopy(START_DATA, 0, result, 0, START_DATA.length);
        System.arraycopy(comprdata, 0, result, START_DATA.length, 4);
        System.arraycopy(XByteBuffer.toBytes(data.length), 0, result, START_DATA.length + 4, 4);
        System.arraycopy(data, 0, result, START_DATA.length + 8, data.length);
        System.arraycopy(END_DATA, 0, result, START_DATA.length + 8 + data.length, END_DATA.length);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

