/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.j2ee.clientproject.SourceRoots;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CompiledSourceForBinaryQuery
implements SourceForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();

    public CompiledSourceForBinaryQuery(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots srcRoots, SourceRoots testRoots) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = srcRoots;
        this.testRoots = testRoots;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        SourceForBinaryQuery.Result res;
        if (FileUtil.getArchiveFile((URL)binaryRoot) != null) {
            binaryRoot = FileUtil.getArchiveFile((URL)binaryRoot);
        }
        if ((res = this.cache.get(binaryRoot)) != null) {
            return res;
        }
        SourceRoots src = null;
        if (this.hasSources(binaryRoot, "build.classes.dir")) {
            src = this.sourceRoots;
        } else if (this.hasSources(binaryRoot, "dist.jar")) {
            src = this.sourceRoots;
        } else if (this.hasSources(binaryRoot, "build.test.classes.dir")) {
            src = this.testRoots;
        }
        if (src == null) {
            return null;
        }
        res = new Result(src);
        this.cache.put(binaryRoot, res);
        return res;
    }

    private boolean hasSources(URL binaryRoot, String binaryProperty) {
        try {
            String outDir = this.evaluator.getProperty(binaryProperty);
            if (outDir != null) {
                File f = this.helper.resolveFile(outDir);
                URL url = f.toURI().toURL();
                if (!f.exists() && !f.getPath().toLowerCase().endsWith(".jar")) {
                    assert (!url.toExternalForm().endsWith("/")) : f;
                    url = new URL(url.toExternalForm() + "/");
                }
                if (url.equals(binaryRoot)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURL) {
            ErrorManager.getDefault().notify((Throwable)malformedURL);
        }
        return false;
    }

    private static class Result
    implements SourceForBinaryQuery.Result,
    PropertyChangeListener {
        private ArrayList<ChangeListener> listeners;
        private SourceRoots sourceRoots;

        public Result(SourceRoots sourceRoots) {
            this.sourceRoots = sourceRoots;
            this.sourceRoots.addPropertyChangeListener(this);
        }

        public FileObject[] getRoots() {
            return this.sourceRoots.getRoots();
        }

        public synchronized void addChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("roots".equals(evt.getPropertyName())) {
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator it;
            Result result = this;
            synchronized (result) {
                if (this.listeners == null) {
                    return;
                }
                ArrayList cloned = (ArrayList)this.listeners.clone();
                it = cloned.iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }
    }
}

