/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.CommentTable;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.ModifyColumn;
import org.netbeans.lib.ddl.impl.RemoveColumn;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ColumnNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = -1470704512178901918L;

    public boolean canAdd(Map propmap, String propname) {
        if (propname.equals("decdigits")) {
            int type = (Integer)this.get("datatype");
            return type == 6 || type == 7 || type == 8;
        }
        return super.canAdd(propmap, propname);
    }

    public Object getProperty(String key) {
        Object val;
        if ((key.equals("columnsize") || key.equals("decdigits") || key.equals("ordpos") || key.equals("key_seq")) && (val = this.get(key)) instanceof String) {
            return Integer.valueOf((String)val);
        }
        if (key.equals("isnullable")) {
            String nullable = (String)this.get(key);
            boolean eq = nullable == null ? false : nullable.toUpperCase().equals("YES");
            return eq ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(key);
    }

    public void delete() throws IOException {
        try {
            String code = this.getCode();
            String table = (String)this.get("table");
            Specification spec = (Specification)this.getSpecification();
            RemoveColumn cmd = spec.createCommandRemoveColumn(table);
            cmd.removeColumn((String)this.get(code));
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
            this.fireRefresh();
        }
        catch (Exception exc) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)exc.getMessage(), 0));
        }
    }

    public TableColumn getColumnSpecification() throws DatabaseException {
        TableColumn col;
        block12: {
            col = null;
            try {
                Specification spec = (Specification)this.getSpecification();
                CreateTable cmd = spec.createCommandCreateTable("DUMMY");
                String code = this.getCode();
                if (code.equals("pcolumn")) {
                    col = cmd.createPrimaryKeyColumn(this.getName());
                } else if (code.equals("icolumn")) {
                    col = cmd.createUniqueColumn(this.getName());
                } else if (code.equals("fcolumn")) {
                    col = null;
                } else if (code.equals("column")) {
                    col = cmd.createColumn(this.getName());
                } else {
                    String message = MessageFormat.format(ColumnNodeInfo.bundle().getString("EXC_UnknownCode"), code);
                    throw new DatabaseException(message);
                }
                DriverSpecification drvSpec = this.getDriverSpecification();
                drvSpec.getColumns((String)this.get("table"), (String)this.get(code));
                ResultSet rs = drvSpec.getResultSet();
                if (rs == null) break block12;
                rs.next();
                HashMap rset = drvSpec.getRow();
                try {
                    col.setColumnType(Integer.parseInt((String)rset.get(new Integer(5))));
                    col.setColumnSize(Integer.parseInt((String)rset.get(new Integer(7))));
                }
                catch (NumberFormatException exc) {
                    col.setColumnType(0);
                    col.setColumnSize(0);
                }
                col.setNullAllowed(((String)rset.get(new Integer(18))).toUpperCase().equals("YES"));
                col.setDefaultValue((String)rset.get(new Integer(13)));
                rset.clear();
                rs.close();
            }
            catch (Exception e) {
                throw new DatabaseException(e.getMessage());
            }
        }
        return col;
    }

    public void setProperty(String key, Object obj) {
        try {
            if (key.equals("remarks")) {
                this.setRemarks((String)obj);
            } else if (key.equals("isnullable")) {
                this.setNullAllowed((Boolean)obj);
                obj = ((Boolean)obj).equals(Boolean.TRUE) ? "YES" : "NO";
            } else if (key.equals("columnsize")) {
                this.setColumnSize((Integer)obj);
            } else if (key.equals("decdigits")) {
                this.setDecimalDigits((Integer)obj);
            } else if (key.equals("coldef")) {
                this.setDefaultValue((String)obj);
            } else if (key.equals("datatype")) {
                this.setDataType((Integer)obj);
            }
            super.setProperty(key, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRemarks(String rem) throws DatabaseException {
        String tablename = (String)this.get("table");
        Specification spec = (Specification)this.getSpecification();
        try {
            CommentTable cmd = spec.createCommandCommentTable(tablename, rem);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void setColumnSize(Integer size) throws DatabaseException {
        try {
            Specification spec = (Specification)this.getSpecification();
            ModifyColumn cmd = spec.createCommandModifyColumn(this.getTable());
            TableColumn col = this.getColumnSpecification();
            col.setColumnSize(size);
            cmd.setColumn(col);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void setDecimalDigits(Integer size) throws DatabaseException {
        try {
            Specification spec = (Specification)this.getSpecification();
            ModifyColumn cmd = spec.createCommandModifyColumn(this.getTable());
            TableColumn col = this.getColumnSpecification();
            col.setDecimalSize(size);
            cmd.setColumn(col);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void setDefaultValue(String val) throws DatabaseException {
        try {
            Specification spec = (Specification)this.getSpecification();
            ModifyColumn cmd = spec.createCommandModifyColumn(this.getTable());
            TableColumn col = this.getColumnSpecification();
            col.setDefaultValue(val);
            cmd.setColumn(col);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void setNullAllowed(boolean flag) throws DatabaseException {
        try {
            Specification spec = (Specification)this.getSpecification();
            ModifyColumn cmd = spec.createCommandModifyColumn(this.getTable());
            TableColumn col = this.getColumnSpecification();
            col.setNullAllowed(flag);
            cmd.setColumn(col);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public void setDataType(Integer type) throws DatabaseException {
        try {
            Specification spec = (Specification)this.getSpecification();
            ModifyColumn cmd = spec.createCommandModifyColumn(this.getTable());
            TableColumn col = this.getColumnSpecification();
            col.setColumnType(type);
            cmd.setColumn(col);
            cmd.setObjectOwner((String)this.get("schema"));
            cmd.execute();
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

