/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.modules.Dependency;

final class BinaryEntry
extends AbstractEntry {
    private final String cnb;
    private final File jar;
    private final String cpext;
    private final File nbdestdir;
    private final File clusterDir;
    private final String releaseVersion;
    private final String specVersion;
    private final String[] providedTokens;
    private LocalizedBundleInfo bundleInfo;
    private final ManifestManager.PackageExport[] publicPackages;
    private final String[] friends;
    private final boolean deprecated;
    private final String[] runDependencies;

    public BinaryEntry(String cnb, File jar, File[] exts, File nbdestdir, File clusterDir, String releaseVersion, String specVersion, String[] providedTokens, ManifestManager.PackageExport[] publicPackages, String[] friends, boolean deprecated, Set moduleDependencies) {
        this.cnb = cnb;
        this.jar = jar;
        this.nbdestdir = nbdestdir;
        this.clusterDir = clusterDir;
        StringBuffer _cpext = new StringBuffer();
        for (int i = 0; i < exts.length; ++i) {
            _cpext.append(':');
            _cpext.append(exts[i].getAbsolutePath());
        }
        this.cpext = _cpext.toString();
        this.releaseVersion = releaseVersion;
        this.specVersion = specVersion;
        this.providedTokens = providedTokens;
        this.publicPackages = publicPackages;
        this.friends = friends;
        this.deprecated = deprecated;
        TreeSet<String> deps = new TreeSet<String>();
        Iterator it = moduleDependencies.iterator();
        while (it.hasNext()) {
            String codename = ((Dependency)it.next()).getName();
            int slash = codename.lastIndexOf(47);
            if (slash == -1) {
                deps.add(codename);
                continue;
            }
            deps.add(codename.substring(0, slash));
        }
        this.runDependencies = deps.toArray(new String[deps.size()]);
    }

    public File getSourceLocation() {
        NbPlatform platform = NbPlatform.getPlatformByDestDir(this.getDestDir());
        return platform.getSourceLocationOfModule(this.getJarLocation());
    }

    public String getNetBeansOrgPath() {
        return null;
    }

    public File getJarLocation() {
        return this.jar;
    }

    public File getDestDir() {
        return this.nbdestdir;
    }

    public String getCodeNameBase() {
        return this.cnb;
    }

    public File getClusterDirectory() {
        return this.clusterDir;
    }

    public String getClassPathExtensions() {
        return this.cpext;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public String[] getProvidedTokens() {
        return this.providedTokens;
    }

    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = Util.findLocalizedBundleInfoFromJAR(this.getJarLocation());
            if (this.bundleInfo == null) {
                this.bundleInfo = LocalizedBundleInfo.EMPTY;
            }
        }
        return this.bundleInfo;
    }

    public ManifestManager.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    public boolean isDeclaredAsFriend(String cnb) {
        return BinaryEntry.isDeclaredAsFriend(this.friends, cnb);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        File source = this.getSourceLocation();
        return "BinaryEntry[" + this.getJarLocation() + (source != null ? "," + source : "") + "]";
    }

    protected Set computePublicClassNamesInMainModule() throws IOException {
        HashSet result = new HashSet();
        this.scanJarForPublicClassNames(result, this.jar);
        return result;
    }

    public String[] getRunDependencies() {
        return this.runDependencies;
    }
}

