/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerNode;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.AnnotatedNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesNode;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public final class ModuleLogicalView
implements LogicalViewProvider {
    private final NbModuleProject project;
    static final String IMPORTANT_FILES_NAME = "important.files";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView;

    public ModuleLogicalView(NbModuleProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        return new RootNode(this.project);
    }

    public Node findPath(Node root, Object target) {
        DataObject file;
        if (root.getLookup().lookup(NbModuleProject.class) != this.project) {
            return null;
        }
        Node[] rootChildren = root.getChildren().getNodes(true);
        if (target instanceof FileObject) {
            try {
                file = DataObject.find((FileObject)((FileObject)target));
            }
            catch (DataObjectNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        } else if (target instanceof DataObject) {
            file = (DataObject)target;
        } else {
            return null;
        }
        for (int i = 0; i < rootChildren.length; ++i) {
            Node found = PackageView.findPath((Node)rootChildren[i], (Object)target);
            if (found != null) {
                return found;
            }
            if (!rootChildren[i].getName().equals(IMPORTANT_FILES_NAME)) continue;
            Node[] ifChildren = rootChildren[i].getChildren().getNodes(true);
            for (int j = 0; j < ifChildren.length; ++j) {
                if (ifChildren[j].getCookie(class$org$openide$loaders$DataObject == null ? ModuleLogicalView.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject) != file) continue;
                return ifChildren[j];
            }
        }
        return null;
    }

    static Node createImportantFilesNode(Children ch) {
        return new ImportantFilesNode(ch);
    }

    private static String computeAnnotatedHtmlDisplayName(String htmlDisplayName, Set files) {
        String result = null;
        if (files != null && files.iterator().hasNext()) {
            try {
                FileSystem.HtmlStatus hstat;
                String annotated;
                FileObject fo = (FileObject)files.iterator().next();
                FileSystem.Status stat = fo.getFileSystem().getStatus();
                if (stat instanceof FileSystem.HtmlStatus && !htmlDisplayName.equals(annotated = (hstat = (FileSystem.HtmlStatus)stat).annotateNameHtml(htmlDisplayName, files))) {
                    result = annotated;
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return result;
    }

    static final class SpecialFileNode
    extends FilterNode {
        private final String displayName;

        public SpecialFileNode(Node orig, String displayName) {
            super(orig);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public String getHtmlDisplayName() {
            String result = null;
            DataObject dob = (DataObject)this.getLookup().lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = ModuleLogicalView.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dob != null) {
                Set files = dob.files();
                result = ModuleLogicalView.computeAnnotatedHtmlDisplayName(this.getDisplayName(), files);
            }
            return result;
        }
    }

    private static final class ImportantFilesChildren
    extends Children.Keys {
        private List visibleFiles = new ArrayList();
        private FileChangeListener fcl;
        private static final Map FILES;
        private final NbModuleProject project;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ImportantFilesChildren(NbModuleProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.attachListeners();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.removeListeners();
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof String) {
                String loc = (String)key;
                String locEval = this.project.evaluator().evaluate(loc);
                FileObject file = this.project.getHelper().resolveFileObject(locEval);
                try {
                    Node orig = DataObject.find((FileObject)file).getNodeDelegate();
                    return new Node[]{new SpecialFileNode(orig, (String)FILES.get(loc))};
                }
                catch (DataObjectNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (key instanceof LayerUtils.LayerHandle) {
                return new Node[]{new SpecialFileNode((Node)new LayerNode((LayerUtils.LayerHandle)key), null)};
            }
            throw new AssertionError(key);
        }

        private void refreshKeys() {
            HashSet<FileObject> files = new HashSet<FileObject>();
            ArrayList<Object> newVisibleFiles = new ArrayList<Object>();
            LayerUtils.LayerHandle handle = LayerUtils.layerForProject(this.project);
            FileObject layerFile = handle.getLayerFile();
            if (layerFile != null) {
                newVisibleFiles.add(handle);
                files.add(layerFile);
            }
            Iterator it = FILES.keySet().iterator();
            while (it.hasNext()) {
                String loc = (String)it.next();
                String locEval = this.project.evaluator().evaluate(loc);
                if (locEval == null) {
                    newVisibleFiles.remove(loc);
                    continue;
                }
                FileObject file = this.project.getHelper().resolveFileObject(locEval);
                if (file == null) continue;
                newVisibleFiles.add(loc);
                files.add(file);
            }
            if (!this.isInitialized() || !((Object)newVisibleFiles).equals(this.visibleFiles)) {
                this.visibleFiles = newVisibleFiles;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ImportantFilesChildren.this.setKeys(ImportantFilesChildren.this.visibleFiles);
                    }
                });
                ((ImportantFilesNode)this.getNode()).setFiles(files);
            }
        }

        private void attachListeners() {
            block3: {
                try {
                    if (this.fcl == null) {
                        this.fcl = new FileChangeAdapter(){

                            public void fileDataCreated(FileEvent fe) {
                                ImportantFilesChildren.this.refreshKeys();
                            }

                            public void fileDeleted(FileEvent fe) {
                                ImportantFilesChildren.this.refreshKeys();
                            }
                        };
                        this.project.getProjectDirectory().getFileSystem().addFileChangeListener(this.fcl);
                    }
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }

        private void removeListeners() {
            if (this.fcl != null) {
                block3: {
                    try {
                        this.project.getProjectDirectory().getFileSystem().removeFileChangeListener(this.fcl);
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e);
                    }
                }
                this.fcl = null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView).desiredAssertionStatus();
            FILES = new LinkedHashMap();
            FILES.put("${manifest.mf}", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_module_manifest"));
            FILES.put("${javadoc.arch}", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_arch_desc"));
            FILES.put("${javadoc.apichanges}", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_api_changes"));
            FILES.put("${javadoc.overview}", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_javadoc_overview"));
            FILES.put("build.xml", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_build.xml"));
            FILES.put("nbproject/project.xml", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_project.xml"));
            FILES.put("nbproject/project.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_project.properties"));
            FILES.put("nbproject/private/private.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_private.properties"));
            FILES.put("nbproject/suite.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_suite.properties"));
            FILES.put("nbproject/private/suite-private.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_suite-private.properties"));
            FILES.put("nbproject/platform.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_platform.properties"));
            FILES.put("nbproject/private/platform-private.properties", NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_platform-private.properties"));
        }
    }

    static final class ImportantFilesNode
    extends AnnotatedNode {
        private static final String DISPLAY_NAME = NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_important_files");

        public ImportantFilesNode(NbModuleProject project) {
            super((Children)new ImportantFilesChildren(project));
        }

        ImportantFilesNode(Children ch) {
            super(ch);
        }

        public String getName() {
            return ModuleLogicalView.IMPORTANT_FILES_NAME;
        }

        private Image getIcon(boolean opened) {
            Image badge = Utilities.loadImage((String)"org/netbeans/modules/apisupport/project/resources/config-badge.gif", (boolean)true);
            return Utilities.mergeImages((Image)UIUtil.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        }

        public String getDisplayName() {
            return this.annotateName(DISPLAY_NAME);
        }

        public String getHtmlDisplayName() {
            return ModuleLogicalView.computeAnnotatedHtmlDisplayName(ImportantFilesNode.DISPLAY_NAME, this.getFiles());
        }

        public Image getIcon(int type) {
            return this.annotateIcon(this.getIcon(false), type);
        }

        public Image getOpenedIcon(int type) {
            return this.annotateIcon(this.getIcon(true), type);
        }
    }

    private static final class RootChildren
    extends Children.Keys
    implements ChangeListener {
        private static final String[] SOURCE_GROUP_TYPES = new String[]{"java", "javahelp"};
        private final NbModuleProject project;

        RootChildren(NbModuleProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
            ProjectUtils.getSources((Project)this.project).addChangeListener((ChangeListener)this);
        }

        private void refreshKeys() {
            ArrayList<Object> l = new ArrayList<Object>();
            Sources s = ProjectUtils.getSources((Project)this.project);
            for (int i = 0; i < SOURCE_GROUP_TYPES.length; ++i) {
                SourceGroup[] groups = s.getSourceGroups(SOURCE_GROUP_TYPES[i]);
                l.addAll(Arrays.asList(groups));
            }
            SourceGroup javadocDocfiles = this.makeJavadocDocfilesSourceGroup();
            if (javadocDocfiles != null) {
                l.add(javadocDocfiles);
            }
            l.add(ModuleLogicalView.IMPORTANT_FILES_NAME);
            l.add("libraries");
            this.setKeys(l);
        }

        protected void removeNotify() {
            ProjectUtils.getSources((Project)this.project).removeChangeListener((ChangeListener)this);
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            Object n;
            if (key instanceof SourceGroup) {
                n = PackageView.createPackageView((SourceGroup)((SourceGroup)key));
            } else if (key == ModuleLogicalView.IMPORTANT_FILES_NAME) {
                n = new ImportantFilesNode(this.project);
            } else if (key == "libraries") {
                n = new LibrariesNode(this.project);
            } else {
                throw new AssertionError((Object)("Unknown key: " + key));
            }
            return new Node[]{n};
        }

        private SourceGroup makeJavadocDocfilesSourceGroup() {
            String propname = "javadoc.docfiles";
            String prop = this.project.evaluator().getProperty(propname);
            if (prop == null) {
                return null;
            }
            FileObject root = this.project.getHelper().resolveFileObject(prop);
            if (root == null) {
                return null;
            }
            return GenericSources.group((Project)this.project, (FileObject)root, (String)propname, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"LBL_extra_javadoc_files"), null, null);
        }

        public void stateChanged(ChangeEvent e) {
            this.refreshKeys();
        }
    }

    private static final class RootNode
    extends AnnotatedNode {
        private final NbModuleProject project;

        public RootNode(NbModuleProject project) {
            super((Children)new RootChildren(project), Lookups.fixed((Object[])new Object[]{project}));
            this.project = project;
            this.setForceAnnotation(true);
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.gif");
            ProjectInformation pi = ProjectUtils.getInformation((Project)project);
            this.setDisplayName(pi.getDisplayName());
            this.setShortDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView = ModuleLogicalView.class$("org.netbeans.modules.apisupport.project.ui.ModuleLogicalView")) : class$org$netbeans$modules$apisupport$project$ui$ModuleLogicalView), (String)"HINT_project_root_node", (Object)FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())));
            this.setFiles(this.getProjectFiles());
            pi.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "displayName") {
                        RootNode.this.setDisplayName((String)evt.getNewValue());
                    } else if (evt.getPropertyName() == "name") {
                        RootNode.this.setName((String)evt.getNewValue());
                    }
                }
            });
        }

        private Set getProjectFiles() {
            HashSet<FileObject> roots = new HashSet<FileObject>();
            Sources sources = ProjectUtils.getSources((Project)this.project);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            for (int i = 0; i < groups.length; ++i) {
                SourceGroup group = groups[i];
                FileObject fo = group.getRootFolder();
                if (fo == null) continue;
                FileObject[] files = fo.getChildren();
                for (int j = 0; j < files.length; ++j) {
                    FileObject file = files[j];
                    if (!group.contains(file)) continue;
                    roots.add(file);
                }
            }
            return roots;
        }

        public Action[] getActions(boolean ignore) {
            return ModuleActions.getProjectActions(this.project);
        }

        public Image getIcon(int type) {
            return this.annotateIcon(super.getIcon(type), type);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public void setName(String name) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, (String)name);
        }
    }
}

