/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public final class CreatedModifiedFiles {
    private final SortedSet createdPaths = new TreeSet();
    private final SortedSet modifiedPaths = new TreeSet();
    private final SortedSet invalidPaths = new TreeSet();
    private final NbModuleProject project;
    private final List operations = new ArrayList();
    private LayerUtils.LayerHandle layerHandle;

    LayerUtils.LayerHandle getLayerHandle() {
        if (this.layerHandle == null) {
            this.layerHandle = LayerUtils.layerForProject(this.project);
        }
        return this.layerHandle;
    }

    public CreatedModifiedFiles(NbModuleProject project) {
        this.project = project;
    }

    public void add(Operation operation) {
        this.operations.add(operation);
        this.createdPaths.addAll(Arrays.asList(operation.getCreatedPaths()));
        this.modifiedPaths.addAll(Arrays.asList(operation.getModifiedPaths()));
        this.invalidPaths.addAll(Arrays.asList(operation.getInvalidPaths()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        boolean oldAutosave = false;
        if (this.layerHandle != null) {
            oldAutosave = this.layerHandle.isAutosave();
            this.layerHandle.setAutosave(false);
        }
        try {
            Iterator it = this.operations.iterator();
            while (it.hasNext()) {
                Operation op = (Operation)it.next();
                op.run();
            }
            if (this.layerHandle != null) {
                this.layerHandle.save();
            }
        }
        finally {
            if (this.layerHandle != null) {
                this.layerHandle.setAutosave(oldAutosave);
            }
        }
    }

    public String[] getCreatedPaths() {
        if (this.createdPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.createdPaths.size()];
        return this.createdPaths.toArray(s);
    }

    public String[] getModifiedPaths() {
        if (this.modifiedPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.modifiedPaths.size()];
        return this.modifiedPaths.toArray(s);
    }

    public String[] getInvalidPaths() {
        if (this.invalidPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.invalidPaths.size()];
        return this.invalidPaths.toArray(s);
    }

    public Operation createFile(String path, URL content) {
        return CreatedModifiedFilesFactory.createFile(this.project, path, content);
    }

    public Operation createFileWithSubstitutions(String path, URL content, Map tokens) {
        return CreatedModifiedFilesFactory.createFileWithSubstitutions(this.project, path, content, tokens);
    }

    public Operation bundleKey(String bundlePath, String key, String value) {
        return CreatedModifiedFilesFactory.bundleKey(this.project, key, value, bundlePath);
    }

    public Operation bundleKeyDefaultBundle(String key, String value) {
        return CreatedModifiedFilesFactory.bundleKeyDefaultBundle(this.project, key, value);
    }

    public Operation addLoaderSection(String dataLoaderClass, String installBefore) {
        return CreatedModifiedFilesFactory.addLoaderSection(this.project, dataLoaderClass, installBefore);
    }

    public Operation addLookupRegistration(String interfaceClass, String implClass) {
        return CreatedModifiedFilesFactory.addLookupRegistration(this.project, interfaceClass, implClass);
    }

    public Operation addModuleDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) {
        return CreatedModifiedFilesFactory.addModuleDependency(this.project, codeNameBase, releaseVersion, version, useInCompiler);
    }

    public Operation addModuleDependency(String codeNameBase) {
        return this.addModuleDependency(codeNameBase, null, null, true);
    }

    public Operation createLayerEntry(String layerPath, URL content, Map substitutionTokens, String localizedDisplayName, Map fileAttributes) {
        return CreatedModifiedFilesFactory.createLayerEntry(this, this.project, layerPath, content, substitutionTokens, localizedDisplayName, fileAttributes);
    }

    public Operation manifestModification(String section, Map attributes) {
        return CreatedModifiedFilesFactory.manifestModification(this.project, section, attributes);
    }

    public Operation propertiesModification(String propertyPath, Map properties) {
        return CreatedModifiedFilesFactory.propertiesModification(this.project, propertyPath, properties);
    }

    public Operation createLayerAttribute(final String parentPath, final String attrName, final Object attrValue) {
        return this.layerModifications(new LayerOperation(){

            public void run(FileSystem layer) throws IOException {
                FileObject f = layer.findResource(parentPath);
                if (f == null) {
                    throw new IOException(parentPath);
                }
                f.setAttribute(attrName, attrValue);
            }
        }, Collections.EMPTY_SET);
    }

    public Operation orderLayerEntry(final String layerPath, final String precedingItemName, final String followingItemName) {
        return this.layerModifications(new LayerOperation(){

            public void run(FileSystem layer) throws IOException {
                FileObject f = FileUtil.createFolder((FileObject)layer.getRoot(), (String)layerPath);
                f.setAttribute(precedingItemName + '/' + followingItemName, (Object)Boolean.TRUE);
            }
        }, Collections.EMPTY_SET);
    }

    public Operation layerModifications(LayerOperation op, Set externalFiles) {
        return CreatedModifiedFilesFactory.layerModifications(this.project, op, externalFiles, this);
    }

    public static interface LayerOperation {
        public void run(FileSystem var1) throws IOException;
    }

    public static interface Operation {
        public void run() throws IOException;

        public String[] getModifiedPaths();

        public String[] getCreatedPaths();

        public String[] getInvalidPaths();
    }
}

