/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public final class MasterURLMapper
extends URLMapper {
    public FileObject[] getFileObjects(URL url) {
        MasterFileSystem hfs = MasterFileSystem.getDefault();
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        FileObject retVal = null;
        String filePath = null;
        try {
            filePath = FileUtil.normalizeFile((File)new File(URI.create(url.toExternalForm()))).getAbsolutePath();
        }
        catch (IllegalArgumentException e) {
            StringBuffer sb = new StringBuffer();
            sb.append(e.getLocalizedMessage()).append(" [").append(url.toExternalForm()).append("]");
            IllegalArgumentException iax = new IllegalArgumentException(sb.toString());
            if (Utilities.isWindows() && url.getAuthority() != null) {
                ErrorManager.getDefault().annotate((Throwable)iax, "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
            }
            ErrorManager.getDefault().notify((Throwable)iax);
            return null;
        }
        retVal = hfs.findResource(filePath);
        if (!(retVal instanceof MasterFileObject)) {
            return null;
        }
        if (!retVal.isValid()) {
            return null;
        }
        return new FileObject[]{retVal};
    }

    public URL getURL(FileObject fo, int type) {
        if (type == 2 || !(fo instanceof MasterFileObject)) {
            return null;
        }
        MasterFileObject hfo = (MasterFileObject)fo;
        File f = hfo != null ? hfo.getResource().getFile() : null;
        try {
            return f != null ? MasterURLMapper.fileToURL(f, fo) : null;
        }
        catch (MalformedURLException mfx) {
            return null;
        }
    }

    private static boolean isWindowsDriveRoot(File file) {
        return (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && file.getParent() == null;
    }

    static URL fileToURL(File file, FileObject fo) throws MalformedURLException {
        URL retVal = null;
        if (MasterURLMapper.isWindowsDriveRoot(file)) {
            retVal = new URL("file:/" + file.getAbsolutePath());
        } else {
            String pathSeparator;
            String urlDef;
            if (fo.isFolder() && (!fo.isValid() || fo.isVirtual()) && !(urlDef = file.toURI().toURL().toExternalForm()).endsWith(pathSeparator = "/")) {
                retVal = new URL(urlDef + pathSeparator);
            }
            retVal = retVal == null ? file.toURI().toURL() : retVal;
        }
        return retVal;
    }
}

