/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.jaxrpc;

import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.model.Model;
import com.sun.xml.rpc.spi.model.Service;
import com.sun.xml.rpc.spi.tools.CompileTool;
import com.sun.xml.rpc.spi.tools.GeneratedFileInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.modules.websvc.registry.jaxrpc.Configuration;
import org.netbeans.modules.websvc.registry.jaxrpc.WSCompileArguments;
import org.netbeans.modules.websvc.registry.jaxrpc.WrapperClientBeanInfoWriter;
import org.netbeans.modules.websvc.registry.jaxrpc.WrapperClientWriter;
import org.netbeans.modules.websvc.registry.jaxrpc.WsdlType;
import org.netbeans.modules.websvc.registry.model.WebServiceData;
import org.netbeans.modules.websvc.registry.util.Util;
import org.netbeans.modules.websvc.registry.util.WebProxySetter;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class Wsdl2Java {
    private String program = "wscompile";
    private String outputDir;
    private String nonClassOutputDir;
    private String sourceOutputDir;
    private URL wsdlUrl;
    private String packageName;
    private JaxRpcObjectFactory jaxprObjectFactory;
    private CompileTool compTool;
    private File webserviceClient;
    private File webserviceClientBeanInfo;
    public static final String DEFAULT_TARGET_PACKAGE = "webservice";

    public Wsdl2Java() {
        System.setProperty("http.proxyHost", WebProxySetter.getInstance().getProxyHost());
        System.setProperty("http.proxyPort", WebProxySetter.getInstance().getProxyPort());
        this.jaxprObjectFactory = JaxRpcObjectFactory.newInstance();
    }

    public void setOutputDirectory(String path) {
        this.outputDir = path;
    }

    public String getOutputDirectory() {
        if (this.outputDir == null) {
            this.outputDir = System.getProperty("user.home");
        }
        return this.outputDir;
    }

    public void setNonClassOutputDirectory(String path) {
        this.nonClassOutputDir = path;
    }

    public String getNonClassOutputDirectory() {
        if (this.nonClassOutputDir == null) {
            this.nonClassOutputDir = this.getOutputDirectory();
        }
        return this.nonClassOutputDir;
    }

    public void setSourceOutputDirectory(String path) {
        this.sourceOutputDir = path;
    }

    public String getSourceOutputDirectory() {
        if (this.sourceOutputDir == null) {
            this.sourceOutputDir = this.getOutputDirectory();
        }
        return this.sourceOutputDir;
    }

    public File getWebserviceClient() {
        return this.webserviceClient;
    }

    public File getWebserviceClientBeanInfo() {
        return this.webserviceClientBeanInfo;
    }

    public void setWsdlUrl(URL url) {
        this.wsdlUrl = url;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setPackageName(String pkgName) {
        this.packageName = pkgName;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = DEFAULT_TARGET_PACKAGE;
        }
        return this.packageName;
    }

    public boolean execute(WebServiceData inWSData, File errorFile) {
        PrintStream ps = null;
        try {
            FileOutputStream fdout = new FileOutputStream(errorFile);
            BufferedOutputStream bos = new BufferedOutputStream(fdout, 2048);
            ps = new PrintStream(bos, false);
        }
        catch (Exception exc) {
            ps = System.out;
        }
        return this.execute(inWSData, ps);
    }

    public boolean execute(WebServiceData inWSData, OutputStream outputStream) {
        this.jaxprObjectFactory = JaxRpcObjectFactory.newInstance();
        this.compTool = this.jaxprObjectFactory.createCompileTool(outputStream, this.program);
        WSCompileArguments wsCompileArgs = new WSCompileArguments();
        wsCompileArgs.setClasspath(Util.getRuntimeClassPath());
        File outDir = new File(this.getOutputDirectory());
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        wsCompileArgs.setOutputDirectory(outDir.getAbsolutePath());
        wsCompileArgs.setGen("client");
        wsCompileArgs.setVerbose(false);
        wsCompileArgs.setKeep(false);
        wsCompileArgs.addFeature("searchschema");
        File nonClassDir = new File(this.getNonClassOutputDirectory());
        if (!nonClassDir.exists()) {
            nonClassDir.mkdirs();
        }
        wsCompileArgs.setNonclassOutputDirectory(nonClassDir.getAbsolutePath());
        File srcDir = new File(this.getSourceOutputDirectory());
        if (!srcDir.exists()) {
            srcDir.mkdirs();
        }
        wsCompileArgs.setSourceOutputDirectory(srcDir.getAbsolutePath());
        Configuration config = new Configuration();
        WsdlType wsdl = new WsdlType();
        config.setWsdl(wsdl);
        try {
            wsdl.setLocation(this.getWsdlUrl());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        wsdl.setPackageName(this.getPackageName());
        wsCompileArgs.setConfiguration(config);
        boolean ret = false;
        try {
            ret = this.compTool.run(wsCompileArgs.toArgs());
            if (ret) {
                this.createWrapperClients(inWSData);
            } else {
                ErrorManager.getDefault().log(this.getClass().getName() + NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_INTERNAL"));
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_EXTERNAL"));
            }
        }
        catch (Exception exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
            ErrorManager.getDefault().log(this.getClass().getName() + NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_INTERNAL"));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_EXTERNAL"));
        }
        return ret;
    }

    public void createWrapperClients(WebServiceData inWSData) {
        Model model;
        File sourceDir = new File(this.getSourceOutputDirectory());
        String pkgName = this.getPackageName();
        StringTokenizer strTokenizer = new StringTokenizer(this.getPackageName(), ".");
        while (strTokenizer.hasMoreTokens()) {
            sourceDir = new File(sourceDir, strTokenizer.nextToken());
        }
        if (!sourceDir.exists()) {
            ErrorManager.getDefault().log(this.getClass().getName() + NbBundle.getMessage(this.getClass(), (String)"ERROR_CREATING_SOURCEDIR"));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_CREATING_SOURCEDIR"));
        }
        if ((model = this.compTool.getProcessor().getModel()) == null) {
            ErrorManager.getDefault().log(this.getClass().getName() + NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_INTERNAL"));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_EXTERNAL"));
            return;
        }
        Iterator services = model.getServices();
        while (services.hasNext()) {
            Service service = (Service)services.next();
            String serviceFullName = service.getJavaIntf().getName();
            String serviceName = serviceFullName.substring(serviceFullName.lastIndexOf(".") + 1);
            Iterator ports = service.getPorts();
            String displayName = inWSData.getDisplayName();
            String clientNameRoot = displayName.substring(displayName.lastIndexOf(46) + 1, displayName.length());
            this.webserviceClient = new File(sourceDir, clientNameRoot + "Client.java");
            this.webserviceClientBeanInfo = new File(sourceDir, clientNameRoot + "ClientBeanInfo.java");
            WrapperClientWriter beanWriter = null;
            WrapperClientBeanInfoWriter beanInfoWriter = null;
            try {
                beanWriter = new WrapperClientWriter(new FileWriter(this.webserviceClient));
                beanInfoWriter = new WrapperClientBeanInfoWriter(new FileWriter(this.webserviceClientBeanInfo));
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"ERROR_WSCOMPILE_EXTERNAL"));
                return;
            }
            beanWriter.setPackage(this.getPackageName());
            beanWriter.setName(clientNameRoot + "Client");
            beanWriter.setContainedClassInfo(serviceName);
            beanWriter.addImport(inWSData.getPackageName() + ".*");
            beanInfoWriter.setPackage(this.getPackageName());
            beanInfoWriter.setName(clientNameRoot + "Client");
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                beanWriter.addPort(port);
            }
            beanWriter.writeClass();
            beanWriter.flush();
            beanWriter.close();
            beanInfoWriter.writeBeanInfo();
            beanInfoWriter.flush();
            beanInfoWriter.close();
        }
    }

    public Model getModel() {
        return this.compTool.getProcessor().getModel();
    }

    public File[] getGeneratedFiles() {
        return this.getGeneratedFiles(false);
    }

    public File[] getGeneratedJavaFiles() {
        return this.getGeneratedFiles(true);
    }

    public File[] getGeneratedFiles(boolean onlyJava) {
        HashSet<File> generatedFiles = new HashSet<File>();
        Iterator iter = this.compTool.getEnvironment().getGeneratedFiles();
        while (iter.hasNext()) {
            File file;
            Object obj = iter.next();
            if (obj instanceof File) {
                file = (File)obj;
            } else {
                if (!(obj instanceof GeneratedFileInfo)) continue;
                file = ((GeneratedFileInfo)obj).getFile();
            }
            if (!file.exists()) continue;
            if (onlyJava) {
                if (!file.getName().endsWith(".java")) continue;
                generatedFiles.add(file);
                continue;
            }
            generatedFiles.add(file);
        }
        return generatedFiles.toArray(new File[generatedFiles.size()]);
    }

    public static void main(String[] args) {
        System.setProperty("http.proxyHost", "webcache.sfbay.sun.com");
        System.setProperty("http.proxyPort", "8080");
        Wsdl2Java wsdl2java = new Wsdl2Java();
        wsdl2java.setOutputDirectory("D:\\wsdl2java\\classes");
        File wsdlFile = new File("D:\\wsdl2java\\JavaTravellerService.wsdl");
        try {
            wsdl2java.setWsdlUrl(wsdlFile.toURL());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(-1);
        }
        WebServiceData wsData = new WebServiceData();
        wsData.setDisplayName("JavaTraveller_service");
        if (wsdl2java.execute(wsData, System.out)) {
            System.out.println("Client Proxy Successfully created");
        } else {
            System.out.println("Client Proxy creation failed");
        }
    }
}

